@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ram.kotlin

import com.pulumi.aws.ram.ResourceShareArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a Resource Access Manager (RAM) Resource Share. To associate principals with the share, see the `aws.ram.PrincipalAssociation` resource. To associate resources with the share, see the `aws.ram.ResourceAssociation` resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ram.ResourceShare("example", {
 *     name: "example",
 *     allowExternalPrincipals: true,
 *     tags: {
 *         Environment: "Production",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ram.ResourceShare("example",
 *     name="example",
 *     allow_external_principals=True,
 *     tags={
 *         "Environment": "Production",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Ram.ResourceShare("example", new()
 *     {
 *         Name = "example",
 *         AllowExternalPrincipals = true,
 *         Tags =
 *         {
 *             { "Environment", "Production" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ram"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ram.NewResourceShare(ctx, "example", &ram.ResourceShareArgs{
 * 			Name:                    pulumi.String("example"),
 * 			AllowExternalPrincipals: pulumi.Bool(true),
 * 			Tags: pulumi.StringMap{
 * 				"Environment": pulumi.String("Production"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ram.ResourceShare;
 * import com.pulumi.aws.ram.ResourceShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceShare("example", ResourceShareArgs.builder()
 *             .name("example")
 *             .allowExternalPrincipals(true)
 *             .tags(Map.of("Environment", "Production"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ram:ResourceShare
 *     properties:
 *       name: example
 *       allowExternalPrincipals: true
 *       tags:
 *         Environment: Production
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import resource shares using the `arn` of the resource share. For example:
 * ```sh
 * $ pulumi import aws:ram/resourceShare:ResourceShare example arn:aws:ram:eu-west-1:123456789012:resource-share/73da1ab9-b94a-4ba3-8eb4-45917f7f4b12
 * ```
 * @property allowExternalPrincipals Indicates whether principals outside your organization can be associated with a resource share.
 * @property name The name of the resource share.
 * @property permissionArns Specifies the Amazon Resource Names (ARNs) of the RAM permission to associate with the resource share. If you do not specify an ARN for the permission, RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.
 * @property tags A map of tags to assign to the resource share. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ResourceShareArgs(
    public val allowExternalPrincipals: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val permissionArns: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ram.ResourceShareArgs> {
    override fun toJava(): com.pulumi.aws.ram.ResourceShareArgs =
        com.pulumi.aws.ram.ResourceShareArgs.builder()
            .allowExternalPrincipals(allowExternalPrincipals?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .permissionArns(permissionArns?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResourceShareArgs].
 */
@PulumiTagMarker
public class ResourceShareArgsBuilder internal constructor() {
    private var allowExternalPrincipals: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var permissionArns: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Indicates whether principals outside your organization can be associated with a resource share.
     */
    @JvmName("fyqprhwmyoqowxhy")
    public suspend fun allowExternalPrincipals(`value`: Output<Boolean>) {
        this.allowExternalPrincipals = value
    }

    /**
     * @param value The name of the resource share.
     */
    @JvmName("bgbrgjevsuqfuokm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the Amazon Resource Names (ARNs) of the RAM permission to associate with the resource share. If you do not specify an ARN for the permission, RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.
     */
    @JvmName("lelhupidtlrchqho")
    public suspend fun permissionArns(`value`: Output<List<String>>) {
        this.permissionArns = value
    }

    @JvmName("liscqlftbwcwyyol")
    public suspend fun permissionArns(vararg values: Output<String>) {
        this.permissionArns = Output.all(values.asList())
    }

    /**
     * @param values Specifies the Amazon Resource Names (ARNs) of the RAM permission to associate with the resource share. If you do not specify an ARN for the permission, RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.
     */
    @JvmName("qmigvkknjoqqyyci")
    public suspend fun permissionArns(values: List<Output<String>>) {
        this.permissionArns = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource share. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qqgohtqtfwhudfmt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Indicates whether principals outside your organization can be associated with a resource share.
     */
    @JvmName("ktdquaqqnnlnrbrf")
    public suspend fun allowExternalPrincipals(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowExternalPrincipals = mapped
    }

    /**
     * @param value The name of the resource share.
     */
    @JvmName("yithqjmkvudmattk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the Amazon Resource Names (ARNs) of the RAM permission to associate with the resource share. If you do not specify an ARN for the permission, RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.
     */
    @JvmName("okexpwdjonriuwek")
    public suspend fun permissionArns(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionArns = mapped
    }

    /**
     * @param values Specifies the Amazon Resource Names (ARNs) of the RAM permission to associate with the resource share. If you do not specify an ARN for the permission, RAM automatically attaches the default version of the permission for each resource type. You can associate only one permission with each resource type included in the resource share.
     */
    @JvmName("oonbycfbvfssgklo")
    public suspend fun permissionArns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissionArns = mapped
    }

    /**
     * @param value A map of tags to assign to the resource share. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aiidoiusufdmsjij")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource share. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("omtvvtwnburrpcvx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ResourceShareArgs = ResourceShareArgs(
        allowExternalPrincipals = allowExternalPrincipals,
        name = name,
        permissionArns = permissionArns,
        tags = tags,
    )
}
