@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ram.kotlin.inputs

import com.pulumi.aws.ram.inputs.GetResourceSharePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResourceShare.
 * @property filters Filter used to scope the list e.g., by tags. See [related docs] (https://docs.aws.amazon.com/ram/latest/APIReference/API_TagFilter.html).
 * @property name Name of the resource share to retrieve.
 * @property resourceOwner Owner of the resource share. Valid values are `SELF` or `OTHER-ACCOUNTS`.
 * @property resourceShareStatus Specifies that you want to retrieve details of only those resource shares that have this status. Valid values are `PENDING`, `ACTIVE`, `FAILED`, `DELETING`, and `DELETED`.
 * @property tags Tags attached to the resource share.
 */
public data class GetResourceSharePlainArgs(
    public val filters: List<GetResourceShareFilter>? = null,
    public val name: String? = null,
    public val resourceOwner: String,
    public val resourceShareStatus: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ram.inputs.GetResourceSharePlainArgs> {
    override fun toJava(): com.pulumi.aws.ram.inputs.GetResourceSharePlainArgs =
        com.pulumi.aws.ram.inputs.GetResourceSharePlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .name(name?.let({ args0 -> args0 }))
            .resourceOwner(resourceOwner.let({ args0 -> args0 }))
            .resourceShareStatus(resourceShareStatus?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetResourceSharePlainArgs].
 */
@PulumiTagMarker
public class GetResourceSharePlainArgsBuilder internal constructor() {
    private var filters: List<GetResourceShareFilter>? = null

    private var name: String? = null

    private var resourceOwner: String? = null

    private var resourceShareStatus: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Filter used to scope the list e.g., by tags. See [related docs] (https://docs.aws.amazon.com/ram/latest/APIReference/API_TagFilter.html).
     */
    @JvmName("ntsugaswexjwwwqn")
    public suspend fun filters(`value`: List<GetResourceShareFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Filter used to scope the list e.g., by tags. See [related docs] (https://docs.aws.amazon.com/ram/latest/APIReference/API_TagFilter.html).
     */
    @JvmName("jkxrnkxdimqcdwdb")
    public suspend fun filters(argument: List<suspend GetResourceShareFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetResourceShareFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Filter used to scope the list e.g., by tags. See [related docs] (https://docs.aws.amazon.com/ram/latest/APIReference/API_TagFilter.html).
     */
    @JvmName("ngdqbactkvheqauo")
    public suspend fun filters(vararg argument: suspend GetResourceShareFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetResourceShareFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Filter used to scope the list e.g., by tags. See [related docs] (https://docs.aws.amazon.com/ram/latest/APIReference/API_TagFilter.html).
     */
    @JvmName("ailtqpkskuqndnfp")
    public suspend fun filters(argument: suspend GetResourceShareFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetResourceShareFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Filter used to scope the list e.g., by tags. See [related docs] (https://docs.aws.amazon.com/ram/latest/APIReference/API_TagFilter.html).
     */
    @JvmName("iocyyovyrsrvnpef")
    public suspend fun filters(vararg values: GetResourceShareFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Name of the resource share to retrieve.
     */
    @JvmName("fmpvckiahvrdkfgc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Owner of the resource share. Valid values are `SELF` or `OTHER-ACCOUNTS`.
     */
    @JvmName("tchpuvorqgoposef")
    public suspend fun resourceOwner(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceOwner = mapped
    }

    /**
     * @param value Specifies that you want to retrieve details of only those resource shares that have this status. Valid values are `PENDING`, `ACTIVE`, `FAILED`, `DELETING`, and `DELETED`.
     */
    @JvmName("ntjsyfofjybevksg")
    public suspend fun resourceShareStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceShareStatus = mapped
    }

    /**
     * @param value Tags attached to the resource share.
     */
    @JvmName("pdmohfqdhaibrqum")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Tags attached to the resource share.
     */
    @JvmName("dfvscexrcddggpfx")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetResourceSharePlainArgs = GetResourceSharePlainArgs(
        filters = filters,
        name = name,
        resourceOwner = resourceOwner ?: throw PulumiNullFieldException("resourceOwner"),
        resourceShareStatus = resourceShareStatus,
        tags = tags,
    )
}
