@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rbin.kotlin.inputs

import com.pulumi.aws.rbin.inputs.RuleLockConfigurationUnlockDelayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property unlockDelayUnit The unit of time in which to measure the unlock delay. Currently, the unlock delay can be measure only in days.
 * @property unlockDelayValue The unlock delay period, measured in the unit specified for UnlockDelayUnit.
 */
public data class RuleLockConfigurationUnlockDelayArgs(
    public val unlockDelayUnit: Output<String>,
    public val unlockDelayValue: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.rbin.inputs.RuleLockConfigurationUnlockDelayArgs> {
    override fun toJava(): com.pulumi.aws.rbin.inputs.RuleLockConfigurationUnlockDelayArgs =
        com.pulumi.aws.rbin.inputs.RuleLockConfigurationUnlockDelayArgs.builder()
            .unlockDelayUnit(unlockDelayUnit.applyValue({ args0 -> args0 }))
            .unlockDelayValue(unlockDelayValue.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleLockConfigurationUnlockDelayArgs].
 */
@PulumiTagMarker
public class RuleLockConfigurationUnlockDelayArgsBuilder internal constructor() {
    private var unlockDelayUnit: Output<String>? = null

    private var unlockDelayValue: Output<Int>? = null

    /**
     * @param value The unit of time in which to measure the unlock delay. Currently, the unlock delay can be measure only in days.
     */
    @JvmName("qiureqcokchsmimu")
    public suspend fun unlockDelayUnit(`value`: Output<String>) {
        this.unlockDelayUnit = value
    }

    /**
     * @param value The unlock delay period, measured in the unit specified for UnlockDelayUnit.
     */
    @JvmName("ejofneatqfmvijrm")
    public suspend fun unlockDelayValue(`value`: Output<Int>) {
        this.unlockDelayValue = value
    }

    /**
     * @param value The unit of time in which to measure the unlock delay. Currently, the unlock delay can be measure only in days.
     */
    @JvmName("cxgdwpaiaqieqprc")
    public suspend fun unlockDelayUnit(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unlockDelayUnit = mapped
    }

    /**
     * @param value The unlock delay period, measured in the unit specified for UnlockDelayUnit.
     */
    @JvmName("jmvfmwnbeadsteit")
    public suspend fun unlockDelayValue(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.unlockDelayValue = mapped
    }

    internal fun build(): RuleLockConfigurationUnlockDelayArgs = RuleLockConfigurationUnlockDelayArgs(
        unlockDelayUnit = unlockDelayUnit ?: throw PulumiNullFieldException("unlockDelayUnit"),
        unlockDelayValue = unlockDelayValue ?: throw PulumiNullFieldException("unlockDelayValue"),
    )
}
