@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rbin.kotlin.inputs

import com.pulumi.aws.rbin.inputs.RuleResourceTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceTagKey The tag key.
 * The following argument is optional:
 * @property resourceTagValue The tag value.
 */
public data class RuleResourceTagArgs(
    public val resourceTagKey: Output<String>,
    public val resourceTagValue: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rbin.inputs.RuleResourceTagArgs> {
    override fun toJava(): com.pulumi.aws.rbin.inputs.RuleResourceTagArgs =
        com.pulumi.aws.rbin.inputs.RuleResourceTagArgs.builder()
            .resourceTagKey(resourceTagKey.applyValue({ args0 -> args0 }))
            .resourceTagValue(resourceTagValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RuleResourceTagArgs].
 */
@PulumiTagMarker
public class RuleResourceTagArgsBuilder internal constructor() {
    private var resourceTagKey: Output<String>? = null

    private var resourceTagValue: Output<String>? = null

    /**
     * @param value The tag key.
     * The following argument is optional:
     */
    @JvmName("rnshmdycipgooflk")
    public suspend fun resourceTagKey(`value`: Output<String>) {
        this.resourceTagKey = value
    }

    /**
     * @param value The tag value.
     */
    @JvmName("ynjfbfulierbgaoi")
    public suspend fun resourceTagValue(`value`: Output<String>) {
        this.resourceTagValue = value
    }

    /**
     * @param value The tag key.
     * The following argument is optional:
     */
    @JvmName("tbwqqcqusejcicng")
    public suspend fun resourceTagKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTagKey = mapped
    }

    /**
     * @param value The tag value.
     */
    @JvmName("mlhyvuogcdsbxxeb")
    public suspend fun resourceTagValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTagValue = mapped
    }

    internal fun build(): RuleResourceTagArgs = RuleResourceTagArgs(
        resourceTagKey = resourceTagKey ?: throw PulumiNullFieldException("resourceTagKey"),
        resourceTagValue = resourceTagValue,
    )
}
