@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.CertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.Certificate("example", {certificateIdentifier: "rds-ca-rsa4096-g1"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.Certificate("example", certificate_identifier="rds-ca-rsa4096-g1")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.Certificate("example", new()
 *     {
 *         CertificateIdentifier = "rds-ca-rsa4096-g1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewCertificate(ctx, "example", &rds.CertificateArgs{
 * 			CertificateIdentifier: pulumi.String("rds-ca-rsa4096-g1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Certificate;
 * import com.pulumi.aws.rds.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Certificate("example", CertificateArgs.builder()
 *             .certificateIdentifier("rds-ca-rsa4096-g1")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:Certificate
 *     properties:
 *       certificateIdentifier: rds-ca-rsa4096-g1
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the default EBS encryption state. For example:
 * ```sh
 * $ pulumi import aws:rds/certificate:Certificate example default
 * ```
 * @property certificateIdentifier Certificate identifier. For example, `rds-ca-rsa4096-g1`. Refer to [AWS RDS (Relational Database) Certificate Identifier](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html#UsingWithRDS.SSL.CertificateIdentifier) for more information.
 */
public data class CertificateArgs(
    public val certificateIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.CertificateArgs> {
    override fun toJava(): com.pulumi.aws.rds.CertificateArgs =
        com.pulumi.aws.rds.CertificateArgs.builder()
            .certificateIdentifier(certificateIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CertificateArgs].
 */
@PulumiTagMarker
public class CertificateArgsBuilder internal constructor() {
    private var certificateIdentifier: Output<String>? = null

    /**
     * @param value Certificate identifier. For example, `rds-ca-rsa4096-g1`. Refer to [AWS RDS (Relational Database) Certificate Identifier](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html#UsingWithRDS.SSL.CertificateIdentifier) for more information.
     */
    @JvmName("bsdfhiogcwjbkdgp")
    public suspend fun certificateIdentifier(`value`: Output<String>) {
        this.certificateIdentifier = value
    }

    /**
     * @param value Certificate identifier. For example, `rds-ca-rsa4096-g1`. Refer to [AWS RDS (Relational Database) Certificate Identifier](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html#UsingWithRDS.SSL.CertificateIdentifier) for more information.
     */
    @JvmName("dcyohrcqbcirjltm")
    public suspend fun certificateIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificateIdentifier = mapped
    }

    internal fun build(): CertificateArgs = CertificateArgs(
        certificateIdentifier = certificateIdentifier,
    )
}
