@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ClusterActivityStream].
 */
@PulumiTagMarker
public class ClusterActivityStreamResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterActivityStreamArgs = ClusterActivityStreamArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterActivityStreamArgsBuilder.() -> Unit) {
        val builder = ClusterActivityStreamArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClusterActivityStream {
        val builtJavaResource = com.pulumi.aws.rds.ClusterActivityStream(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterActivityStream(builtJavaResource)
    }
}

/**
 * Manages RDS Aurora Cluster Database Activity Streams.
 * Database Activity Streams have some limits and requirements, refer to the [Monitoring Amazon Aurora using Database Activity Streams](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/DBActivityStreams.html) documentation for detailed limitations and requirements.
 * > **Note:** This resource always calls the RDS [`StartActivityStream`][2] API with the `ApplyImmediately` parameter set to `true`. This is because the provider needs the activity stream to be started in order for it to get the associated attributes.
 * > **Note:** This resource depends on having at least one `aws.rds.ClusterInstance` created. To avoid race conditions when all resources are being created together, add an explicit resource reference using the resource `depends_on` meta-argument.
 * > **Note:** This resource is available in all regions except the following: `cn-north-1`, `cn-northwest-1`, `us-gov-east-1`, `us-gov-west-1`
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.rds.Cluster("default", {
 *     clusterIdentifier: "aurora-cluster-demo",
 *     availabilityZones: [
 *         "us-west-2a",
 *         "us-west-2b",
 *         "us-west-2c",
 *     ],
 *     databaseName: "mydb",
 *     masterUsername: "foo",
 *     masterPassword: "mustbeeightcharaters",
 *     engine: aws.rds.EngineType.AuroraPostgresql,
 *     engineVersion: "13.4",
 * });
 * const defaultClusterInstance = new aws.rds.ClusterInstance("default", {
 *     identifier: "aurora-instance-demo",
 *     clusterIdentifier: _default.clusterIdentifier,
 *     engine: _default.engine,
 *     instanceClass: aws.rds.InstanceType.R6G_Large,
 * });
 * const defaultKey = new aws.kms.Key("default", {description: "AWS KMS Key to encrypt Database Activity Stream"});
 * const defaultClusterActivityStream = new aws.rds.ClusterActivityStream("default", {
 *     resourceArn: _default.arn,
 *     mode: "async",
 *     kmsKeyId: defaultKey.keyId,
 * }, {
 *     dependsOn: [defaultClusterInstance],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.rds.Cluster("default",
 *     cluster_identifier="aurora-cluster-demo",
 *     availability_zones=[
 *         "us-west-2a",
 *         "us-west-2b",
 *         "us-west-2c",
 *     ],
 *     database_name="mydb",
 *     master_username="foo",
 *     master_password="mustbeeightcharaters",
 *     engine=aws.rds.EngineType.AURORA_POSTGRESQL,
 *     engine_version="13.4")
 * default_cluster_instance = aws.rds.ClusterInstance("default",
 *     identifier="aurora-instance-demo",
 *     cluster_identifier=default.cluster_identifier,
 *     engine=default.engine,
 *     instance_class=aws.rds.InstanceType.R6_G_LARGE)
 * default_key = aws.kms.Key("default", description="AWS KMS Key to encrypt Database Activity Stream")
 * default_cluster_activity_stream = aws.rds.ClusterActivityStream("default",
 *     resource_arn=default.arn,
 *     mode="async",
 *     kms_key_id=default_key.key_id,
 *     opts = pulumi.ResourceOptions(depends_on=[default_cluster_instance]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Rds.Cluster("default", new()
 *     {
 *         ClusterIdentifier = "aurora-cluster-demo",
 *         AvailabilityZones = new[]
 *         {
 *             "us-west-2a",
 *             "us-west-2b",
 *             "us-west-2c",
 *         },
 *         DatabaseName = "mydb",
 *         MasterUsername = "foo",
 *         MasterPassword = "mustbeeightcharaters",
 *         Engine = Aws.Rds.EngineType.AuroraPostgresql,
 *         EngineVersion = "13.4",
 *     });
 *     var defaultClusterInstance = new Aws.Rds.ClusterInstance("default", new()
 *     {
 *         Identifier = "aurora-instance-demo",
 *         ClusterIdentifier = @default.ClusterIdentifier,
 *         Engine = @default.Engine,
 *         InstanceClass = Aws.Rds.InstanceType.R6G_Large,
 *     });
 *     var defaultKey = new Aws.Kms.Key("default", new()
 *     {
 *         Description = "AWS KMS Key to encrypt Database Activity Stream",
 *     });
 *     var defaultClusterActivityStream = new Aws.Rds.ClusterActivityStream("default", new()
 *     {
 *         ResourceArn = @default.Arn,
 *         Mode = "async",
 *         KmsKeyId = defaultKey.KeyId,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             defaultClusterInstance,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewCluster(ctx, "default", &rds.ClusterArgs{
 * 			ClusterIdentifier: pulumi.String("aurora-cluster-demo"),
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("us-west-2a"),
 * 				pulumi.String("us-west-2b"),
 * 				pulumi.String("us-west-2c"),
 * 			},
 * 			DatabaseName:   pulumi.String("mydb"),
 * 			MasterUsername: pulumi.String("foo"),
 * 			MasterPassword: pulumi.String("mustbeeightcharaters"),
 * 			Engine:         pulumi.String(rds.EngineTypeAuroraPostgresql),
 * 			EngineVersion:  pulumi.String("13.4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultClusterInstance, err := rds.NewClusterInstance(ctx, "default", &rds.ClusterInstanceArgs{
 * 			Identifier:        pulumi.String("aurora-instance-demo"),
 * 			ClusterIdentifier: _default.ClusterIdentifier,
 * 			Engine:            _default.Engine,
 * 			InstanceClass:     pulumi.String(rds.InstanceType_R6G_Large),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultKey, err := kms.NewKey(ctx, "default", &kms.KeyArgs{
 * 			Description: pulumi.String("AWS KMS Key to encrypt Database Activity Stream"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewClusterActivityStream(ctx, "default", &rds.ClusterActivityStreamArgs{
 * 			ResourceArn: _default.Arn,
 * 			Mode:        pulumi.String("async"),
 * 			KmsKeyId:    defaultKey.KeyId,
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			defaultClusterInstance,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Cluster;
 * import com.pulumi.aws.rds.ClusterArgs;
 * import com.pulumi.aws.rds.ClusterInstance;
 * import com.pulumi.aws.rds.ClusterInstanceArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.rds.ClusterActivityStream;
 * import com.pulumi.aws.rds.ClusterActivityStreamArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Cluster("default", ClusterArgs.builder()
 *             .clusterIdentifier("aurora-cluster-demo")
 *             .availabilityZones(
 *                 "us-west-2a",
 *                 "us-west-2b",
 *                 "us-west-2c")
 *             .databaseName("mydb")
 *             .masterUsername("foo")
 *             .masterPassword("mustbeeightcharaters")
 *             .engine("aurora-postgresql")
 *             .engineVersion("13.4")
 *             .build());
 *         var defaultClusterInstance = new ClusterInstance("defaultClusterInstance", ClusterInstanceArgs.builder()
 *             .identifier("aurora-instance-demo")
 *             .clusterIdentifier(default_.clusterIdentifier())
 *             .engine(default_.engine())
 *             .instanceClass("db.r6g.large")
 *             .build());
 *         var defaultKey = new Key("defaultKey", KeyArgs.builder()
 *             .description("AWS KMS Key to encrypt Database Activity Stream")
 *             .build());
 *         var defaultClusterActivityStream = new ClusterActivityStream("defaultClusterActivityStream", ClusterActivityStreamArgs.builder()
 *             .resourceArn(default_.arn())
 *             .mode("async")
 *             .kmsKeyId(defaultKey.keyId())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(defaultClusterInstance)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:rds:Cluster
 *     properties:
 *       clusterIdentifier: aurora-cluster-demo
 *       availabilityZones:
 *         - us-west-2a
 *         - us-west-2b
 *         - us-west-2c
 *       databaseName: mydb
 *       masterUsername: foo
 *       masterPassword: mustbeeightcharaters
 *       engine: aurora-postgresql
 *       engineVersion: '13.4'
 *   defaultClusterInstance:
 *     type: aws:rds:ClusterInstance
 *     name: default
 *     properties:
 *       identifier: aurora-instance-demo
 *       clusterIdentifier: ${default.clusterIdentifier}
 *       engine: ${default.engine}
 *       instanceClass: db.r6g.large
 *   defaultKey:
 *     type: aws:kms:Key
 *     name: default
 *     properties:
 *       description: AWS KMS Key to encrypt Database Activity Stream
 *   defaultClusterActivityStream:
 *     type: aws:rds:ClusterActivityStream
 *     name: default
 *     properties:
 *       resourceArn: ${default.arn}
 *       mode: async
 *       kmsKeyId: ${defaultKey.keyId}
 *     options:
 *       dependson:
 *         - ${defaultClusterInstance}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import RDS Aurora Cluster Database Activity Streams using the `resource_arn`. For example:
 * ```sh
 * $ pulumi import aws:rds/clusterActivityStream:ClusterActivityStream default arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster-demo
 * ```
 */
public class ClusterActivityStream internal constructor(
    override val javaResource: com.pulumi.aws.rds.ClusterActivityStream,
) : KotlinCustomResource(javaResource, ClusterActivityStreamMapper) {
    /**
     * Specifies whether the database activity stream includes engine-native audit fields. This option only applies to an Oracle DB instance. By default, no engine-native audit fields are included. Defaults `false`.
     */
    public val engineNativeAuditFieldsIncluded: Output<Boolean>?
        get() = javaResource.engineNativeAuditFieldsIncluded().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Amazon Kinesis data stream to be used for the database activity stream.
     */
    public val kinesisStreamName: Output<String>
        get() = javaResource.kinesisStreamName().applyValue({ args0 -> args0 })

    /**
     * The AWS KMS key identifier for encrypting messages in the database activity stream. The AWS KMS key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Specifies the mode of the database activity stream. Database events such as a change or access generate an activity stream event. The database session can handle these events either synchronously or asynchronously. One of: `sync`, `async`.
     */
    public val mode: Output<String>
        get() = javaResource.mode().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the DB cluster.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })
}

public object ClusterActivityStreamMapper : ResourceMapper<ClusterActivityStream> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.ClusterActivityStream::class == javaResource::class

    override fun map(javaResource: Resource): ClusterActivityStream =
        ClusterActivityStream(javaResource as com.pulumi.aws.rds.ClusterActivityStream)
}

/**
 * @see [ClusterActivityStream].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterActivityStream].
 */
public suspend fun clusterActivityStream(
    name: String,
    block: suspend ClusterActivityStreamResourceBuilder.() -> Unit,
): ClusterActivityStream {
    val builder = ClusterActivityStreamResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterActivityStream].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterActivityStream(name: String): ClusterActivityStream {
    val builder = ClusterActivityStreamResourceBuilder()
    builder.name(name)
    return builder.build()
}
