@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.kotlin.outputs.ClusterParameterGroupParameter
import com.pulumi.aws.rds.kotlin.outputs.ClusterParameterGroupParameter.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ClusterParameterGroup].
 */
@PulumiTagMarker
public class ClusterParameterGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterParameterGroupArgs = ClusterParameterGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterParameterGroupArgsBuilder.() -> Unit) {
        val builder = ClusterParameterGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClusterParameterGroup {
        val builtJavaResource = com.pulumi.aws.rds.ClusterParameterGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterParameterGroup(builtJavaResource)
    }
}

/**
 * Provides an RDS DB cluster parameter group resource. Documentation of the available parameters for various Aurora engines can be found at:
 * * [Aurora MySQL Parameters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Reference.html)
 * * [Aurora PostgreSQL Parameters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraPostgreSQL.Reference.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.rds.ClusterParameterGroup("default", {
 *     name: "rds-cluster-pg",
 *     family: "aurora5.6",
 *     description: "RDS default cluster parameter group",
 *     parameters: [
 *         {
 *             name: "character_set_server",
 *             value: "utf8",
 *         },
 *         {
 *             name: "character_set_client",
 *             value: "utf8",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.rds.ClusterParameterGroup("default",
 *     name="rds-cluster-pg",
 *     family="aurora5.6",
 *     description="RDS default cluster parameter group",
 *     parameters=[
 *         {
 *             "name": "character_set_server",
 *             "value": "utf8",
 *         },
 *         {
 *             "name": "character_set_client",
 *             "value": "utf8",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Rds.ClusterParameterGroup("default", new()
 *     {
 *         Name = "rds-cluster-pg",
 *         Family = "aurora5.6",
 *         Description = "RDS default cluster parameter group",
 *         Parameters = new[]
 *         {
 *             new Aws.Rds.Inputs.ClusterParameterGroupParameterArgs
 *             {
 *                 Name = "character_set_server",
 *                 Value = "utf8",
 *             },
 *             new Aws.Rds.Inputs.ClusterParameterGroupParameterArgs
 *             {
 *                 Name = "character_set_client",
 *                 Value = "utf8",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewClusterParameterGroup(ctx, "default", &rds.ClusterParameterGroupArgs{
 * 			Name:        pulumi.String("rds-cluster-pg"),
 * 			Family:      pulumi.String("aurora5.6"),
 * 			Description: pulumi.String("RDS default cluster parameter group"),
 * 			Parameters: rds.ClusterParameterGroupParameterArray{
 * 				&rds.ClusterParameterGroupParameterArgs{
 * 					Name:  pulumi.String("character_set_server"),
 * 					Value: pulumi.String("utf8"),
 * 				},
 * 				&rds.ClusterParameterGroupParameterArgs{
 * 					Name:  pulumi.String("character_set_client"),
 * 					Value: pulumi.String("utf8"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.ClusterParameterGroup;
 * import com.pulumi.aws.rds.ClusterParameterGroupArgs;
 * import com.pulumi.aws.rds.inputs.ClusterParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new ClusterParameterGroup("default", ClusterParameterGroupArgs.builder()
 *             .name("rds-cluster-pg")
 *             .family("aurora5.6")
 *             .description("RDS default cluster parameter group")
 *             .parameters(
 *                 ClusterParameterGroupParameterArgs.builder()
 *                     .name("character_set_server")
 *                     .value("utf8")
 *                     .build(),
 *                 ClusterParameterGroupParameterArgs.builder()
 *                     .name("character_set_client")
 *                     .value("utf8")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:rds:ClusterParameterGroup
 *     properties:
 *       name: rds-cluster-pg
 *       family: aurora5.6
 *       description: RDS default cluster parameter group
 *       parameters:
 *         - name: character_set_server
 *           value: utf8
 *         - name: character_set_client
 *           value: utf8
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import RDS Cluster Parameter Groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:rds/clusterParameterGroup:ClusterParameterGroup cluster_pg production-pg-1
 * ```
 */
public class ClusterParameterGroup internal constructor(
    override val javaResource: com.pulumi.aws.rds.ClusterParameterGroup,
) : KotlinCustomResource(javaResource, ClusterParameterGroupMapper) {
    /**
     * The ARN of the db cluster parameter group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the DB cluster parameter group. Defaults to "Managed by Pulumi".
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The family of the DB cluster parameter group.
     */
    public val family: Output<String>
        get() = javaResource.family().applyValue({ args0 -> args0 })

    /**
     * The name of the DB parameter.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * A list of DB parameters to apply. Note that parameters may differ from a family to an other. Full list of all parameters can be discovered via [`aws rds describe-db-cluster-parameters`](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-cluster-parameters.html) after initial creation of the group.
     */
    public val parameters: Output<List<ClusterParameterGroupParameter>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ClusterParameterGroupMapper : ResourceMapper<ClusterParameterGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.ClusterParameterGroup::class == javaResource::class

    override fun map(javaResource: Resource): ClusterParameterGroup =
        ClusterParameterGroup(javaResource as com.pulumi.aws.rds.ClusterParameterGroup)
}

/**
 * @see [ClusterParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterParameterGroup].
 */
public suspend fun clusterParameterGroup(
    name: String,
    block: suspend ClusterParameterGroupResourceBuilder.() -> Unit,
): ClusterParameterGroup {
    val builder = ClusterParameterGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterParameterGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterParameterGroup(name: String): ClusterParameterGroup {
    val builder = ClusterParameterGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
