@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.ClusterParameterGroupArgs.builder
import com.pulumi.aws.rds.kotlin.inputs.ClusterParameterGroupParameterArgs
import com.pulumi.aws.rds.kotlin.inputs.ClusterParameterGroupParameterArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an RDS DB cluster parameter group resource. Documentation of the available parameters for various Aurora engines can be found at:
 * * [Aurora MySQL Parameters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraMySQL.Reference.html)
 * * [Aurora PostgreSQL Parameters](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/AuroraPostgreSQL.Reference.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.rds.ClusterParameterGroup("default", {
 *     name: "rds-cluster-pg",
 *     family: "aurora5.6",
 *     description: "RDS default cluster parameter group",
 *     parameters: [
 *         {
 *             name: "character_set_server",
 *             value: "utf8",
 *         },
 *         {
 *             name: "character_set_client",
 *             value: "utf8",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.rds.ClusterParameterGroup("default",
 *     name="rds-cluster-pg",
 *     family="aurora5.6",
 *     description="RDS default cluster parameter group",
 *     parameters=[
 *         {
 *             "name": "character_set_server",
 *             "value": "utf8",
 *         },
 *         {
 *             "name": "character_set_client",
 *             "value": "utf8",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Rds.ClusterParameterGroup("default", new()
 *     {
 *         Name = "rds-cluster-pg",
 *         Family = "aurora5.6",
 *         Description = "RDS default cluster parameter group",
 *         Parameters = new[]
 *         {
 *             new Aws.Rds.Inputs.ClusterParameterGroupParameterArgs
 *             {
 *                 Name = "character_set_server",
 *                 Value = "utf8",
 *             },
 *             new Aws.Rds.Inputs.ClusterParameterGroupParameterArgs
 *             {
 *                 Name = "character_set_client",
 *                 Value = "utf8",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewClusterParameterGroup(ctx, "default", &rds.ClusterParameterGroupArgs{
 * 			Name:        pulumi.String("rds-cluster-pg"),
 * 			Family:      pulumi.String("aurora5.6"),
 * 			Description: pulumi.String("RDS default cluster parameter group"),
 * 			Parameters: rds.ClusterParameterGroupParameterArray{
 * 				&rds.ClusterParameterGroupParameterArgs{
 * 					Name:  pulumi.String("character_set_server"),
 * 					Value: pulumi.String("utf8"),
 * 				},
 * 				&rds.ClusterParameterGroupParameterArgs{
 * 					Name:  pulumi.String("character_set_client"),
 * 					Value: pulumi.String("utf8"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.ClusterParameterGroup;
 * import com.pulumi.aws.rds.ClusterParameterGroupArgs;
 * import com.pulumi.aws.rds.inputs.ClusterParameterGroupParameterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new ClusterParameterGroup("default", ClusterParameterGroupArgs.builder()
 *             .name("rds-cluster-pg")
 *             .family("aurora5.6")
 *             .description("RDS default cluster parameter group")
 *             .parameters(
 *                 ClusterParameterGroupParameterArgs.builder()
 *                     .name("character_set_server")
 *                     .value("utf8")
 *                     .build(),
 *                 ClusterParameterGroupParameterArgs.builder()
 *                     .name("character_set_client")
 *                     .value("utf8")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:rds:ClusterParameterGroup
 *     properties:
 *       name: rds-cluster-pg
 *       family: aurora5.6
 *       description: RDS default cluster parameter group
 *       parameters:
 *         - name: character_set_server
 *           value: utf8
 *         - name: character_set_client
 *           value: utf8
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import RDS Cluster Parameter Groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:rds/clusterParameterGroup:ClusterParameterGroup cluster_pg production-pg-1
 * ```
 * @property description The description of the DB cluster parameter group. Defaults to "Managed by Pulumi".
 * @property family The family of the DB cluster parameter group.
 * @property name The name of the DB parameter.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property parameters A list of DB parameters to apply. Note that parameters may differ from a family to an other. Full list of all parameters can be discovered via [`aws rds describe-db-cluster-parameters`](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-cluster-parameters.html) after initial creation of the group.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ClusterParameterGroupArgs(
    public val description: Output<String>? = null,
    public val family: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val parameters: Output<List<ClusterParameterGroupParameterArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.ClusterParameterGroupArgs> {
    override fun toJava(): com.pulumi.aws.rds.ClusterParameterGroupArgs =
        com.pulumi.aws.rds.ClusterParameterGroupArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterParameterGroupArgs].
 */
@PulumiTagMarker
public class ClusterParameterGroupArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var family: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var parameters: Output<List<ClusterParameterGroupParameterArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the DB cluster parameter group. Defaults to "Managed by Pulumi".
     */
    @JvmName("pqsotnbfjmvvripg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The family of the DB cluster parameter group.
     */
    @JvmName("fwufweieostvxocb")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The name of the DB parameter.
     */
    @JvmName("blijistawvfqqvog")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("sovmdhnlsteylufb")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value A list of DB parameters to apply. Note that parameters may differ from a family to an other. Full list of all parameters can be discovered via [`aws rds describe-db-cluster-parameters`](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-cluster-parameters.html) after initial creation of the group.
     */
    @JvmName("exeawfoaxevqartv")
    public suspend fun parameters(`value`: Output<List<ClusterParameterGroupParameterArgs>>) {
        this.parameters = value
    }

    @JvmName("wsmypjignydtgcpj")
    public suspend fun parameters(vararg values: Output<ClusterParameterGroupParameterArgs>) {
        this.parameters = Output.all(values.asList())
    }

    /**
     * @param values A list of DB parameters to apply. Note that parameters may differ from a family to an other. Full list of all parameters can be discovered via [`aws rds describe-db-cluster-parameters`](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-cluster-parameters.html) after initial creation of the group.
     */
    @JvmName("hxexrxjtltrtclru")
    public suspend fun parameters(values: List<Output<ClusterParameterGroupParameterArgs>>) {
        this.parameters = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pmalcvkejnmwtgba")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the DB cluster parameter group. Defaults to "Managed by Pulumi".
     */
    @JvmName("polhbjvkhqovfihe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The family of the DB cluster parameter group.
     */
    @JvmName("lrawokxvbpervadw")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The name of the DB parameter.
     */
    @JvmName("mbkwvmdtcaognbfj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("qyayhsxfgoinvugo")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value A list of DB parameters to apply. Note that parameters may differ from a family to an other. Full list of all parameters can be discovered via [`aws rds describe-db-cluster-parameters`](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-cluster-parameters.html) after initial creation of the group.
     */
    @JvmName("nqivjecuvkkkrqwi")
    public suspend fun parameters(`value`: List<ClusterParameterGroupParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument A list of DB parameters to apply. Note that parameters may differ from a family to an other. Full list of all parameters can be discovered via [`aws rds describe-db-cluster-parameters`](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-cluster-parameters.html) after initial creation of the group.
     */
    @JvmName("cwtbublxqaganjuc")
    public suspend fun parameters(argument: List<suspend ClusterParameterGroupParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ClusterParameterGroupParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument A list of DB parameters to apply. Note that parameters may differ from a family to an other. Full list of all parameters can be discovered via [`aws rds describe-db-cluster-parameters`](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-cluster-parameters.html) after initial creation of the group.
     */
    @JvmName("eipafsxjrcaljhkd")
    public suspend fun parameters(vararg argument: suspend ClusterParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ClusterParameterGroupParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param argument A list of DB parameters to apply. Note that parameters may differ from a family to an other. Full list of all parameters can be discovered via [`aws rds describe-db-cluster-parameters`](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-cluster-parameters.html) after initial creation of the group.
     */
    @JvmName("vrslxkeglgjngygm")
    public suspend fun parameters(argument: suspend ClusterParameterGroupParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ClusterParameterGroupParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values A list of DB parameters to apply. Note that parameters may differ from a family to an other. Full list of all parameters can be discovered via [`aws rds describe-db-cluster-parameters`](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-cluster-parameters.html) after initial creation of the group.
     */
    @JvmName("jjdbcyuydatjpmmn")
    public suspend fun parameters(vararg values: ClusterParameterGroupParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fdgihwimryirnqgk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hhwgwolkiwuqfyxn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterParameterGroupArgs = ClusterParameterGroupArgs(
        description = description,
        family = family,
        name = name,
        namePrefix = namePrefix,
        parameters = parameters,
        tags = tags,
    )
}
