@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ClusterRoleAssociation].
 */
@PulumiTagMarker
public class ClusterRoleAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterRoleAssociationArgs = ClusterRoleAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterRoleAssociationArgsBuilder.() -> Unit) {
        val builder = ClusterRoleAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClusterRoleAssociation {
        val builtJavaResource = com.pulumi.aws.rds.ClusterRoleAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterRoleAssociation(builtJavaResource)
    }
}

/**
 * Manages a RDS DB Cluster association with an IAM Role. Example use cases:
 * * [Creating an IAM Role to Allow Amazon Aurora to Access AWS Services](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Integrating.Authorizing.IAM.CreateRole.html)
 * * [Importing Amazon S3 Data into an RDS PostgreSQL DB Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PostgreSQL.S3Import.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.ClusterRoleAssociation("example", {
 *     dbClusterIdentifier: exampleAwsRdsCluster.id,
 *     featureName: "S3_INTEGRATION",
 *     roleArn: exampleAwsIamRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.ClusterRoleAssociation("example",
 *     db_cluster_identifier=example_aws_rds_cluster["id"],
 *     feature_name="S3_INTEGRATION",
 *     role_arn=example_aws_iam_role["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.ClusterRoleAssociation("example", new()
 *     {
 *         DbClusterIdentifier = exampleAwsRdsCluster.Id,
 *         FeatureName = "S3_INTEGRATION",
 *         RoleArn = exampleAwsIamRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewClusterRoleAssociation(ctx, "example", &rds.ClusterRoleAssociationArgs{
 * 			DbClusterIdentifier: pulumi.Any(exampleAwsRdsCluster.Id),
 * 			FeatureName:         pulumi.String("S3_INTEGRATION"),
 * 			RoleArn:             pulumi.Any(exampleAwsIamRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.ClusterRoleAssociation;
 * import com.pulumi.aws.rds.ClusterRoleAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterRoleAssociation("example", ClusterRoleAssociationArgs.builder()
 *             .dbClusterIdentifier(exampleAwsRdsCluster.id())
 *             .featureName("S3_INTEGRATION")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:ClusterRoleAssociation
 *     properties:
 *       dbClusterIdentifier: ${exampleAwsRdsCluster.id}
 *       featureName: S3_INTEGRATION
 *       roleArn: ${exampleAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_rds_cluster_role_association` using the DB Cluster Identifier and IAM Role ARN separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:rds/clusterRoleAssociation:ClusterRoleAssociation example my-db-cluster,arn:aws:iam::123456789012:role/my-role
 * ```
 */
public class ClusterRoleAssociation internal constructor(
    override val javaResource: com.pulumi.aws.rds.ClusterRoleAssociation,
) : KotlinCustomResource(javaResource, ClusterRoleAssociationMapper) {
    /**
     * DB Cluster Identifier to associate with the IAM Role.
     */
    public val dbClusterIdentifier: Output<String>
        get() = javaResource.dbClusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * Name of the feature for association. This can be found in the AWS documentation relevant to the integration or a full list is available in the `SupportedFeatureNames` list returned by [AWS CLI rds describe-db-engine-versions](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html).
     */
    public val featureName: Output<String>
        get() = javaResource.featureName().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the IAM Role to associate with the DB Cluster.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })
}

public object ClusterRoleAssociationMapper : ResourceMapper<ClusterRoleAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.ClusterRoleAssociation::class == javaResource::class

    override fun map(javaResource: Resource): ClusterRoleAssociation =
        ClusterRoleAssociation(javaResource as com.pulumi.aws.rds.ClusterRoleAssociation)
}

/**
 * @see [ClusterRoleAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterRoleAssociation].
 */
public suspend fun clusterRoleAssociation(
    name: String,
    block: suspend ClusterRoleAssociationResourceBuilder.() -> Unit,
): ClusterRoleAssociation {
    val builder = ClusterRoleAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterRoleAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterRoleAssociation(name: String): ClusterRoleAssociation {
    val builder = ClusterRoleAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
