@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.ClusterRoleAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manages a RDS DB Cluster association with an IAM Role. Example use cases:
 * * [Creating an IAM Role to Allow Amazon Aurora to Access AWS Services](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Integrating.Authorizing.IAM.CreateRole.html)
 * * [Importing Amazon S3 Data into an RDS PostgreSQL DB Cluster](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PostgreSQL.S3Import.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.ClusterRoleAssociation("example", {
 *     dbClusterIdentifier: exampleAwsRdsCluster.id,
 *     featureName: "S3_INTEGRATION",
 *     roleArn: exampleAwsIamRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.ClusterRoleAssociation("example",
 *     db_cluster_identifier=example_aws_rds_cluster["id"],
 *     feature_name="S3_INTEGRATION",
 *     role_arn=example_aws_iam_role["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.ClusterRoleAssociation("example", new()
 *     {
 *         DbClusterIdentifier = exampleAwsRdsCluster.Id,
 *         FeatureName = "S3_INTEGRATION",
 *         RoleArn = exampleAwsIamRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewClusterRoleAssociation(ctx, "example", &rds.ClusterRoleAssociationArgs{
 * 			DbClusterIdentifier: pulumi.Any(exampleAwsRdsCluster.Id),
 * 			FeatureName:         pulumi.String("S3_INTEGRATION"),
 * 			RoleArn:             pulumi.Any(exampleAwsIamRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.ClusterRoleAssociation;
 * import com.pulumi.aws.rds.ClusterRoleAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterRoleAssociation("example", ClusterRoleAssociationArgs.builder()
 *             .dbClusterIdentifier(exampleAwsRdsCluster.id())
 *             .featureName("S3_INTEGRATION")
 *             .roleArn(exampleAwsIamRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:ClusterRoleAssociation
 *     properties:
 *       dbClusterIdentifier: ${exampleAwsRdsCluster.id}
 *       featureName: S3_INTEGRATION
 *       roleArn: ${exampleAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_rds_cluster_role_association` using the DB Cluster Identifier and IAM Role ARN separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:rds/clusterRoleAssociation:ClusterRoleAssociation example my-db-cluster,arn:aws:iam::123456789012:role/my-role
 * ```
 * @property dbClusterIdentifier DB Cluster Identifier to associate with the IAM Role.
 * @property featureName Name of the feature for association. This can be found in the AWS documentation relevant to the integration or a full list is available in the `SupportedFeatureNames` list returned by [AWS CLI rds describe-db-engine-versions](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html).
 * @property roleArn Amazon Resource Name (ARN) of the IAM Role to associate with the DB Cluster.
 */
public data class ClusterRoleAssociationArgs(
    public val dbClusterIdentifier: Output<String>? = null,
    public val featureName: Output<String>? = null,
    public val roleArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.ClusterRoleAssociationArgs> {
    override fun toJava(): com.pulumi.aws.rds.ClusterRoleAssociationArgs =
        com.pulumi.aws.rds.ClusterRoleAssociationArgs.builder()
            .dbClusterIdentifier(dbClusterIdentifier?.applyValue({ args0 -> args0 }))
            .featureName(featureName?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterRoleAssociationArgs].
 */
@PulumiTagMarker
public class ClusterRoleAssociationArgsBuilder internal constructor() {
    private var dbClusterIdentifier: Output<String>? = null

    private var featureName: Output<String>? = null

    private var roleArn: Output<String>? = null

    /**
     * @param value DB Cluster Identifier to associate with the IAM Role.
     */
    @JvmName("lppjyaqucxaricco")
    public suspend fun dbClusterIdentifier(`value`: Output<String>) {
        this.dbClusterIdentifier = value
    }

    /**
     * @param value Name of the feature for association. This can be found in the AWS documentation relevant to the integration or a full list is available in the `SupportedFeatureNames` list returned by [AWS CLI rds describe-db-engine-versions](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html).
     */
    @JvmName("rxcefkbrgqaishah")
    public suspend fun featureName(`value`: Output<String>) {
        this.featureName = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role to associate with the DB Cluster.
     */
    @JvmName("wibrrwtlhjsswqgq")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value DB Cluster Identifier to associate with the IAM Role.
     */
    @JvmName("msfkefgjjqfxpebe")
    public suspend fun dbClusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterIdentifier = mapped
    }

    /**
     * @param value Name of the feature for association. This can be found in the AWS documentation relevant to the integration or a full list is available in the `SupportedFeatureNames` list returned by [AWS CLI rds describe-db-engine-versions](https://docs.aws.amazon.com/cli/latest/reference/rds/describe-db-engine-versions.html).
     */
    @JvmName("oyebffsksghkvnoy")
    public suspend fun featureName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featureName = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role to associate with the DB Cluster.
     */
    @JvmName("fjecodvcljwvcxtn")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    internal fun build(): ClusterRoleAssociationArgs = ClusterRoleAssociationArgs(
        dbClusterIdentifier = dbClusterIdentifier,
        featureName = featureName,
        roleArn = roleArn,
    )
}
