@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ClusterSnapshot].
 */
@PulumiTagMarker
public class ClusterSnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterSnapshotArgs = ClusterSnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterSnapshotArgsBuilder.() -> Unit) {
        val builder = ClusterSnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ClusterSnapshot {
        val builtJavaResource = com.pulumi.aws.rds.ClusterSnapshot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ClusterSnapshot(builtJavaResource)
    }
}

/**
 * Manages an RDS database cluster snapshot for Aurora clusters. For managing RDS database instance snapshots, see the `aws.rds.Snapshot` resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.ClusterSnapshot("example", {
 *     dbClusterIdentifier: exampleAwsRdsCluster.id,
 *     dbClusterSnapshotIdentifier: "resourcetestsnapshot1234",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.ClusterSnapshot("example",
 *     db_cluster_identifier=example_aws_rds_cluster["id"],
 *     db_cluster_snapshot_identifier="resourcetestsnapshot1234")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.ClusterSnapshot("example", new()
 *     {
 *         DbClusterIdentifier = exampleAwsRdsCluster.Id,
 *         DbClusterSnapshotIdentifier = "resourcetestsnapshot1234",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewClusterSnapshot(ctx, "example", &rds.ClusterSnapshotArgs{
 * 			DbClusterIdentifier:         pulumi.Any(exampleAwsRdsCluster.Id),
 * 			DbClusterSnapshotIdentifier: pulumi.String("resourcetestsnapshot1234"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.ClusterSnapshot;
 * import com.pulumi.aws.rds.ClusterSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterSnapshot("example", ClusterSnapshotArgs.builder()
 *             .dbClusterIdentifier(exampleAwsRdsCluster.id())
 *             .dbClusterSnapshotIdentifier("resourcetestsnapshot1234")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:ClusterSnapshot
 *     properties:
 *       dbClusterIdentifier: ${exampleAwsRdsCluster.id}
 *       dbClusterSnapshotIdentifier: resourcetestsnapshot1234
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_db_cluster_snapshot` using the cluster snapshot identifier. For example:
 * ```sh
 * $ pulumi import aws:rds/clusterSnapshot:ClusterSnapshot example my-cluster-snapshot
 * ```
 */
public class ClusterSnapshot internal constructor(
    override val javaResource: com.pulumi.aws.rds.ClusterSnapshot,
) : KotlinCustomResource(javaResource, ClusterSnapshotMapper) {
    /**
     * Allocated storage size in gigabytes (GB).
     */
    public val allocatedStorage: Output<Int>
        get() = javaResource.allocatedStorage().applyValue({ args0 -> args0 })

    /**
     * List of EC2 Availability Zones that instances in the DB cluster snapshot can be restored in.
     */
    public val availabilityZones: Output<List<String>>
        get() = javaResource.availabilityZones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The DB Cluster Identifier from which to take the snapshot.
     */
    public val dbClusterIdentifier: Output<String>
        get() = javaResource.dbClusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) for the DB Cluster Snapshot.
     */
    public val dbClusterSnapshotArn: Output<String>
        get() = javaResource.dbClusterSnapshotArn().applyValue({ args0 -> args0 })

    /**
     * The Identifier for the snapshot.
     */
    public val dbClusterSnapshotIdentifier: Output<String>
        get() = javaResource.dbClusterSnapshotIdentifier().applyValue({ args0 -> args0 })

    /**
     * Name of the database engine.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * Version of the database engine for this DB cluster snapshot.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    /**
     * If storage_encrypted is true, the AWS KMS key identifier for the encrypted DB cluster snapshot.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * License model information for the restored DB cluster.
     */
    public val licenseModel: Output<String>
        get() = javaResource.licenseModel().applyValue({ args0 -> args0 })

    /**
     * Port that the DB cluster was listening on at the time of the snapshot.
     */
    public val port: Output<Int>
        get() = javaResource.port().applyValue({ args0 -> args0 })

    /**
     * List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    public val sharedAccounts: Output<List<String>>?
        get() = javaResource.sharedAccounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    public val snapshotType: Output<String>
        get() = javaResource.snapshotType().applyValue({ args0 -> args0 })

    public val sourceDbClusterSnapshotArn: Output<String>
        get() = javaResource.sourceDbClusterSnapshotArn().applyValue({ args0 -> args0 })

    /**
     * The status of this DB Cluster Snapshot.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Whether the DB cluster snapshot is encrypted.
     */
    public val storageEncrypted: Output<Boolean>
        get() = javaResource.storageEncrypted().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The VPC ID associated with the DB cluster snapshot.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object ClusterSnapshotMapper : ResourceMapper<ClusterSnapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.ClusterSnapshot::class == javaResource::class

    override fun map(javaResource: Resource): ClusterSnapshot = ClusterSnapshot(
        javaResource as
            com.pulumi.aws.rds.ClusterSnapshot,
    )
}

/**
 * @see [ClusterSnapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClusterSnapshot].
 */
public suspend fun clusterSnapshot(
    name: String,
    block: suspend ClusterSnapshotResourceBuilder.() -> Unit,
): ClusterSnapshot {
    val builder = ClusterSnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClusterSnapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun clusterSnapshot(name: String): ClusterSnapshot {
    val builder = ClusterSnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
