@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.ClusterSnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an RDS database cluster snapshot for Aurora clusters. For managing RDS database instance snapshots, see the `aws.rds.Snapshot` resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.ClusterSnapshot("example", {
 *     dbClusterIdentifier: exampleAwsRdsCluster.id,
 *     dbClusterSnapshotIdentifier: "resourcetestsnapshot1234",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.ClusterSnapshot("example",
 *     db_cluster_identifier=example_aws_rds_cluster["id"],
 *     db_cluster_snapshot_identifier="resourcetestsnapshot1234")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.ClusterSnapshot("example", new()
 *     {
 *         DbClusterIdentifier = exampleAwsRdsCluster.Id,
 *         DbClusterSnapshotIdentifier = "resourcetestsnapshot1234",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewClusterSnapshot(ctx, "example", &rds.ClusterSnapshotArgs{
 * 			DbClusterIdentifier:         pulumi.Any(exampleAwsRdsCluster.Id),
 * 			DbClusterSnapshotIdentifier: pulumi.String("resourcetestsnapshot1234"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.ClusterSnapshot;
 * import com.pulumi.aws.rds.ClusterSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ClusterSnapshot("example", ClusterSnapshotArgs.builder()
 *             .dbClusterIdentifier(exampleAwsRdsCluster.id())
 *             .dbClusterSnapshotIdentifier("resourcetestsnapshot1234")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:ClusterSnapshot
 *     properties:
 *       dbClusterIdentifier: ${exampleAwsRdsCluster.id}
 *       dbClusterSnapshotIdentifier: resourcetestsnapshot1234
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_db_cluster_snapshot` using the cluster snapshot identifier. For example:
 * ```sh
 * $ pulumi import aws:rds/clusterSnapshot:ClusterSnapshot example my-cluster-snapshot
 * ```
 * @property dbClusterIdentifier The DB Cluster Identifier from which to take the snapshot.
 * @property dbClusterSnapshotIdentifier The Identifier for the snapshot.
 * @property sharedAccounts List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
 * @property tags A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ClusterSnapshotArgs(
    public val dbClusterIdentifier: Output<String>? = null,
    public val dbClusterSnapshotIdentifier: Output<String>? = null,
    public val sharedAccounts: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.ClusterSnapshotArgs> {
    override fun toJava(): com.pulumi.aws.rds.ClusterSnapshotArgs =
        com.pulumi.aws.rds.ClusterSnapshotArgs.builder()
            .dbClusterIdentifier(dbClusterIdentifier?.applyValue({ args0 -> args0 }))
            .dbClusterSnapshotIdentifier(dbClusterSnapshotIdentifier?.applyValue({ args0 -> args0 }))
            .sharedAccounts(sharedAccounts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClusterSnapshotArgs].
 */
@PulumiTagMarker
public class ClusterSnapshotArgsBuilder internal constructor() {
    private var dbClusterIdentifier: Output<String>? = null

    private var dbClusterSnapshotIdentifier: Output<String>? = null

    private var sharedAccounts: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The DB Cluster Identifier from which to take the snapshot.
     */
    @JvmName("cichlwfqciohpkkg")
    public suspend fun dbClusterIdentifier(`value`: Output<String>) {
        this.dbClusterIdentifier = value
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("kofpfladusnmfmue")
    public suspend fun dbClusterSnapshotIdentifier(`value`: Output<String>) {
        this.dbClusterSnapshotIdentifier = value
    }

    /**
     * @param value List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("wexfnridppoedtmh")
    public suspend fun sharedAccounts(`value`: Output<List<String>>) {
        this.sharedAccounts = value
    }

    @JvmName("kkigofkfxphqqfdi")
    public suspend fun sharedAccounts(vararg values: Output<String>) {
        this.sharedAccounts = Output.all(values.asList())
    }

    /**
     * @param values List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("sorfnepdfjonkquu")
    public suspend fun sharedAccounts(values: List<Output<String>>) {
        this.sharedAccounts = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("equpoarvxpgxstgo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The DB Cluster Identifier from which to take the snapshot.
     */
    @JvmName("prnngxbcskfbhrkb")
    public suspend fun dbClusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterIdentifier = mapped
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("xkembichokbbcbjr")
    public suspend fun dbClusterSnapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterSnapshotIdentifier = mapped
    }

    /**
     * @param value List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("xdabobioqmlfbfef")
    public suspend fun sharedAccounts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccounts = mapped
    }

    /**
     * @param values List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("saeuntgindyhmgwa")
    public suspend fun sharedAccounts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sharedAccounts = mapped
    }

    /**
     * @param value A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xysmxclgpndacekn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the DB cluster. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("echspndfcresvhti")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClusterSnapshotArgs = ClusterSnapshotArgs(
        dbClusterIdentifier = dbClusterIdentifier,
        dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier,
        sharedAccounts = sharedAccounts,
        tags = tags,
    )
}
