@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [EventSubscription].
 */
@PulumiTagMarker
public class EventSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventSubscriptionArgs = EventSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventSubscriptionArgsBuilder.() -> Unit) {
        val builder = EventSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventSubscription {
        val builtJavaResource = com.pulumi.aws.rds.EventSubscription(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventSubscription(builtJavaResource)
    }
}

/**
 * Provides a DB event subscription resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.rds.Instance("default", {
 *     allocatedStorage: 10,
 *     engine: "mysql",
 *     engineVersion: "5.6.17",
 *     instanceClass: aws.rds.InstanceType.T2_Micro,
 *     dbName: "mydb",
 *     username: "foo",
 *     password: "bar",
 *     dbSubnetGroupName: "my_database_subnet_group",
 *     parameterGroupName: "default.mysql5.6",
 * });
 * const defaultTopic = new aws.sns.Topic("default", {name: "rds-events"});
 * const defaultEventSubscription = new aws.rds.EventSubscription("default", {
 *     name: "rds-event-sub",
 *     snsTopic: defaultTopic.arn,
 *     sourceType: "db-instance",
 *     sourceIds: [_default&#46;identifier],
 *     eventCategories: [
 *         "availability",
 *         "deletion",
 *         "failover",
 *         "failure",
 *         "low storage",
 *         "maintenance",
 *         "notification",
 *         "read replica",
 *         "recovery",
 *         "restoration",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.rds.Instance("default",
 *     allocated_storage=10,
 *     engine="mysql",
 *     engine_version="5.6.17",
 *     instance_class=aws.rds.InstanceType.T2_MICRO,
 *     db_name="mydb",
 *     username="foo",
 *     password="bar",
 *     db_subnet_group_name="my_database_subnet_group",
 *     parameter_group_name="default.mysql5.6")
 * default_topic = aws.sns.Topic("default", name="rds-events")
 * default_event_subscription = aws.rds.EventSubscription("default",
 *     name="rds-event-sub",
 *     sns_topic=default_topic.arn,
 *     source_type="db-instance",
 *     source_ids=[default&#46;identifier],
 *     event_categories=[
 *         "availability",
 *         "deletion",
 *         "failover",
 *         "failure",
 *         "low storage",
 *         "maintenance",
 *         "notification",
 *         "read replica",
 *         "recovery",
 *         "restoration",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Rds.Instance("default", new()
 *     {
 *         AllocatedStorage = 10,
 *         Engine = "mysql",
 *         EngineVersion = "5.6.17",
 *         InstanceClass = Aws.Rds.InstanceType.T2_Micro,
 *         DbName = "mydb",
 *         Username = "foo",
 *         Password = "bar",
 *         DbSubnetGroupName = "my_database_subnet_group",
 *         ParameterGroupName = "default.mysql5.6",
 *     });
 *     var defaultTopic = new Aws.Sns.Topic("default", new()
 *     {
 *         Name = "rds-events",
 *     });
 *     var defaultEventSubscription = new Aws.Rds.EventSubscription("default", new()
 *     {
 *         Name = "rds-event-sub",
 *         SnsTopic = defaultTopic.Arn,
 *         SourceType = "db-instance",
 *         SourceIds = new[]
 *         {
 *             @default.Identifier,
 *         },
 *         EventCategories = new[]
 *         {
 *             "availability",
 *             "deletion",
 *             "failover",
 *             "failure",
 *             "low storage",
 *             "maintenance",
 *             "notification",
 *             "read replica",
 *             "recovery",
 *             "restoration",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewInstance(ctx, "default", &rds.InstanceArgs{
 * 			AllocatedStorage:   pulumi.Int(10),
 * 			Engine:             pulumi.String("mysql"),
 * 			EngineVersion:      pulumi.String("5.6.17"),
 * 			InstanceClass:      pulumi.String(rds.InstanceType_T2_Micro),
 * 			DbName:             pulumi.String("mydb"),
 * 			Username:           pulumi.String("foo"),
 * 			Password:           pulumi.String("bar"),
 * 			DbSubnetGroupName:  pulumi.String("my_database_subnet_group"),
 * 			ParameterGroupName: pulumi.String("default.mysql5.6"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTopic, err := sns.NewTopic(ctx, "default", &sns.TopicArgs{
 * 			Name: pulumi.String("rds-events"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewEventSubscription(ctx, "default", &rds.EventSubscriptionArgs{
 * 			Name:       pulumi.String("rds-event-sub"),
 * 			SnsTopic:   defaultTopic.Arn,
 * 			SourceType: pulumi.String("db-instance"),
 * 			SourceIds: pulumi.StringArray{
 * 				_default.Identifier,
 * 			},
 * 			EventCategories: pulumi.StringArray{
 * 				pulumi.String("availability"),
 * 				pulumi.String("deletion"),
 * 				pulumi.String("failover"),
 * 				pulumi.String("failure"),
 * 				pulumi.String("low storage"),
 * 				pulumi.String("maintenance"),
 * 				pulumi.String("notification"),
 * 				pulumi.String("read replica"),
 * 				pulumi.String("recovery"),
 * 				pulumi.String("restoration"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.rds.EventSubscription;
 * import com.pulumi.aws.rds.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .allocatedStorage(10)
 *             .engine("mysql")
 *             .engineVersion("5.6.17")
 *             .instanceClass("db.t2.micro")
 *             .dbName("mydb")
 *             .username("foo")
 *             .password("bar")
 *             .dbSubnetGroupName("my_database_subnet_group")
 *             .parameterGroupName("default.mysql5.6")
 *             .build());
 *         var defaultTopic = new Topic("defaultTopic", TopicArgs.builder()
 *             .name("rds-events")
 *             .build());
 *         var defaultEventSubscription = new EventSubscription("defaultEventSubscription", EventSubscriptionArgs.builder()
 *             .name("rds-event-sub")
 *             .snsTopic(defaultTopic.arn())
 *             .sourceType("db-instance")
 *             .sourceIds(default_.identifier())
 *             .eventCategories(
 *                 "availability",
 *                 "deletion",
 *                 "failover",
 *                 "failure",
 *                 "low storage",
 *                 "maintenance",
 *                 "notification",
 *                 "read replica",
 *                 "recovery",
 *                 "restoration")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:rds:Instance
 *     properties:
 *       allocatedStorage: 10
 *       engine: mysql
 *       engineVersion: 5.6.17
 *       instanceClass: db.t2.micro
 *       dbName: mydb
 *       username: foo
 *       password: bar
 *       dbSubnetGroupName: my_database_subnet_group
 *       parameterGroupName: default.mysql5.6
 *   defaultTopic:
 *     type: aws:sns:Topic
 *     name: default
 *     properties:
 *       name: rds-events
 *   defaultEventSubscription:
 *     type: aws:rds:EventSubscription
 *     name: default
 *     properties:
 *       name: rds-event-sub
 *       snsTopic: ${defaultTopic.arn}
 *       sourceType: db-instance
 *       sourceIds:
 *         - ${default.identifier}
 *       eventCategories:
 *         - availability
 *         - deletion
 *         - failover
 *         - failure
 *         - low storage
 *         - maintenance
 *         - notification
 *         - read replica
 *         - recovery
 *         - restoration
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DB Event Subscriptions using the `name`. For example:
 * ```sh
 * $ pulumi import aws:rds/eventSubscription:EventSubscription default rds-event-sub
 * ```
 */
public class EventSubscription internal constructor(
    override val javaResource: com.pulumi.aws.rds.EventSubscription,
) : KotlinCustomResource(javaResource, EventSubscriptionMapper) {
    /**
     * The Amazon Resource Name of the RDS event notification subscription
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The AWS customer account associated with the RDS event notification subscription
     */
    public val customerAwsId: Output<String>
        get() = javaResource.customerAwsId().applyValue({ args0 -> args0 })

    /**
     * A boolean flag to enable/disable the subscription. Defaults to true.
     */
    public val enabled: Output<Boolean>?
        get() = javaResource.enabled().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A list of event categories for a SourceType that you want to subscribe to. See http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html or run `aws rds describe-event-categories`.
     */
    public val eventCategories: Output<List<String>>?
        get() = javaResource.eventCategories().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The name of the DB event subscription. By default generated by this provider.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The name of the DB event subscription. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * The SNS topic to send events to.
     */
    public val snsTopic: Output<String>
        get() = javaResource.snsTopic().applyValue({ args0 -> args0 })

    /**
     * A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
     */
    public val sourceIds: Output<List<String>>?
        get() = javaResource.sourceIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The type of source that will be generating the events. Valid options are `db-instance`, `db-security-group`, `db-parameter-group`, `db-snapshot`, `db-cluster`, `db-cluster-snapshot`, or `db-proxy`. If not set, all sources will be subscribed to.
     */
    public val sourceType: Output<String>?
        get() = javaResource.sourceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object EventSubscriptionMapper : ResourceMapper<EventSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.EventSubscription::class == javaResource::class

    override fun map(javaResource: Resource): EventSubscription = EventSubscription(
        javaResource as
            com.pulumi.aws.rds.EventSubscription,
    )
}

/**
 * @see [EventSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventSubscription].
 */
public suspend fun eventSubscription(
    name: String,
    block: suspend EventSubscriptionResourceBuilder.() -> Unit,
): EventSubscription {
    val builder = EventSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventSubscription(name: String): EventSubscription {
    val builder = EventSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
