@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.EventSubscriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a DB event subscription resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.rds.Instance("default", {
 *     allocatedStorage: 10,
 *     engine: "mysql",
 *     engineVersion: "5.6.17",
 *     instanceClass: aws.rds.InstanceType.T2_Micro,
 *     dbName: "mydb",
 *     username: "foo",
 *     password: "bar",
 *     dbSubnetGroupName: "my_database_subnet_group",
 *     parameterGroupName: "default.mysql5.6",
 * });
 * const defaultTopic = new aws.sns.Topic("default", {name: "rds-events"});
 * const defaultEventSubscription = new aws.rds.EventSubscription("default", {
 *     name: "rds-event-sub",
 *     snsTopic: defaultTopic.arn,
 *     sourceType: "db-instance",
 *     sourceIds: [_default&#46;identifier],
 *     eventCategories: [
 *         "availability",
 *         "deletion",
 *         "failover",
 *         "failure",
 *         "low storage",
 *         "maintenance",
 *         "notification",
 *         "read replica",
 *         "recovery",
 *         "restoration",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.rds.Instance("default",
 *     allocated_storage=10,
 *     engine="mysql",
 *     engine_version="5.6.17",
 *     instance_class=aws.rds.InstanceType.T2_MICRO,
 *     db_name="mydb",
 *     username="foo",
 *     password="bar",
 *     db_subnet_group_name="my_database_subnet_group",
 *     parameter_group_name="default.mysql5.6")
 * default_topic = aws.sns.Topic("default", name="rds-events")
 * default_event_subscription = aws.rds.EventSubscription("default",
 *     name="rds-event-sub",
 *     sns_topic=default_topic.arn,
 *     source_type="db-instance",
 *     source_ids=[default&#46;identifier],
 *     event_categories=[
 *         "availability",
 *         "deletion",
 *         "failover",
 *         "failure",
 *         "low storage",
 *         "maintenance",
 *         "notification",
 *         "read replica",
 *         "recovery",
 *         "restoration",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Rds.Instance("default", new()
 *     {
 *         AllocatedStorage = 10,
 *         Engine = "mysql",
 *         EngineVersion = "5.6.17",
 *         InstanceClass = Aws.Rds.InstanceType.T2_Micro,
 *         DbName = "mydb",
 *         Username = "foo",
 *         Password = "bar",
 *         DbSubnetGroupName = "my_database_subnet_group",
 *         ParameterGroupName = "default.mysql5.6",
 *     });
 *     var defaultTopic = new Aws.Sns.Topic("default", new()
 *     {
 *         Name = "rds-events",
 *     });
 *     var defaultEventSubscription = new Aws.Rds.EventSubscription("default", new()
 *     {
 *         Name = "rds-event-sub",
 *         SnsTopic = defaultTopic.Arn,
 *         SourceType = "db-instance",
 *         SourceIds = new[]
 *         {
 *             @default.Identifier,
 *         },
 *         EventCategories = new[]
 *         {
 *             "availability",
 *             "deletion",
 *             "failover",
 *             "failure",
 *             "low storage",
 *             "maintenance",
 *             "notification",
 *             "read replica",
 *             "recovery",
 *             "restoration",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewInstance(ctx, "default", &rds.InstanceArgs{
 * 			AllocatedStorage:   pulumi.Int(10),
 * 			Engine:             pulumi.String("mysql"),
 * 			EngineVersion:      pulumi.String("5.6.17"),
 * 			InstanceClass:      pulumi.String(rds.InstanceType_T2_Micro),
 * 			DbName:             pulumi.String("mydb"),
 * 			Username:           pulumi.String("foo"),
 * 			Password:           pulumi.String("bar"),
 * 			DbSubnetGroupName:  pulumi.String("my_database_subnet_group"),
 * 			ParameterGroupName: pulumi.String("default.mysql5.6"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultTopic, err := sns.NewTopic(ctx, "default", &sns.TopicArgs{
 * 			Name: pulumi.String("rds-events"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewEventSubscription(ctx, "default", &rds.EventSubscriptionArgs{
 * 			Name:       pulumi.String("rds-event-sub"),
 * 			SnsTopic:   defaultTopic.Arn,
 * 			SourceType: pulumi.String("db-instance"),
 * 			SourceIds: pulumi.StringArray{
 * 				_default.Identifier,
 * 			},
 * 			EventCategories: pulumi.StringArray{
 * 				pulumi.String("availability"),
 * 				pulumi.String("deletion"),
 * 				pulumi.String("failover"),
 * 				pulumi.String("failure"),
 * 				pulumi.String("low storage"),
 * 				pulumi.String("maintenance"),
 * 				pulumi.String("notification"),
 * 				pulumi.String("read replica"),
 * 				pulumi.String("recovery"),
 * 				pulumi.String("restoration"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.rds.EventSubscription;
 * import com.pulumi.aws.rds.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .allocatedStorage(10)
 *             .engine("mysql")
 *             .engineVersion("5.6.17")
 *             .instanceClass("db.t2.micro")
 *             .dbName("mydb")
 *             .username("foo")
 *             .password("bar")
 *             .dbSubnetGroupName("my_database_subnet_group")
 *             .parameterGroupName("default.mysql5.6")
 *             .build());
 *         var defaultTopic = new Topic("defaultTopic", TopicArgs.builder()
 *             .name("rds-events")
 *             .build());
 *         var defaultEventSubscription = new EventSubscription("defaultEventSubscription", EventSubscriptionArgs.builder()
 *             .name("rds-event-sub")
 *             .snsTopic(defaultTopic.arn())
 *             .sourceType("db-instance")
 *             .sourceIds(default_.identifier())
 *             .eventCategories(
 *                 "availability",
 *                 "deletion",
 *                 "failover",
 *                 "failure",
 *                 "low storage",
 *                 "maintenance",
 *                 "notification",
 *                 "read replica",
 *                 "recovery",
 *                 "restoration")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:rds:Instance
 *     properties:
 *       allocatedStorage: 10
 *       engine: mysql
 *       engineVersion: 5.6.17
 *       instanceClass: db.t2.micro
 *       dbName: mydb
 *       username: foo
 *       password: bar
 *       dbSubnetGroupName: my_database_subnet_group
 *       parameterGroupName: default.mysql5.6
 *   defaultTopic:
 *     type: aws:sns:Topic
 *     name: default
 *     properties:
 *       name: rds-events
 *   defaultEventSubscription:
 *     type: aws:rds:EventSubscription
 *     name: default
 *     properties:
 *       name: rds-event-sub
 *       snsTopic: ${defaultTopic.arn}
 *       sourceType: db-instance
 *       sourceIds:
 *         - ${default.identifier}
 *       eventCategories:
 *         - availability
 *         - deletion
 *         - failover
 *         - failure
 *         - low storage
 *         - maintenance
 *         - notification
 *         - read replica
 *         - recovery
 *         - restoration
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DB Event Subscriptions using the `name`. For example:
 * ```sh
 * $ pulumi import aws:rds/eventSubscription:EventSubscription default rds-event-sub
 * ```
 * @property enabled A boolean flag to enable/disable the subscription. Defaults to true.
 * @property eventCategories A list of event categories for a SourceType that you want to subscribe to. See http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html or run `aws rds describe-event-categories`.
 * @property name The name of the DB event subscription. By default generated by this provider.
 * @property namePrefix The name of the DB event subscription. Conflicts with `name`.
 * @property snsTopic The SNS topic to send events to.
 * @property sourceIds A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
 * @property sourceType The type of source that will be generating the events. Valid options are `db-instance`, `db-security-group`, `db-parameter-group`, `db-snapshot`, `db-cluster`, `db-cluster-snapshot`, or `db-proxy`. If not set, all sources will be subscribed to.
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class EventSubscriptionArgs(
    public val enabled: Output<Boolean>? = null,
    public val eventCategories: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val snsTopic: Output<String>? = null,
    public val sourceIds: Output<List<String>>? = null,
    public val sourceType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.EventSubscriptionArgs> {
    override fun toJava(): com.pulumi.aws.rds.EventSubscriptionArgs =
        com.pulumi.aws.rds.EventSubscriptionArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .eventCategories(eventCategories?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .snsTopic(snsTopic?.applyValue({ args0 -> args0 }))
            .sourceIds(sourceIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceType(sourceType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EventSubscriptionArgs].
 */
@PulumiTagMarker
public class EventSubscriptionArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var eventCategories: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var snsTopic: Output<String>? = null

    private var sourceIds: Output<List<String>>? = null

    private var sourceType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A boolean flag to enable/disable the subscription. Defaults to true.
     */
    @JvmName("yvakafwrnlgsccqb")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value A list of event categories for a SourceType that you want to subscribe to. See http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html or run `aws rds describe-event-categories`.
     */
    @JvmName("ovpofekdfkqwgcoc")
    public suspend fun eventCategories(`value`: Output<List<String>>) {
        this.eventCategories = value
    }

    @JvmName("hbjseyoemhknnmkj")
    public suspend fun eventCategories(vararg values: Output<String>) {
        this.eventCategories = Output.all(values.asList())
    }

    /**
     * @param values A list of event categories for a SourceType that you want to subscribe to. See http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html or run `aws rds describe-event-categories`.
     */
    @JvmName("xmhobyuaktfdclra")
    public suspend fun eventCategories(values: List<Output<String>>) {
        this.eventCategories = Output.all(values)
    }

    /**
     * @param value The name of the DB event subscription. By default generated by this provider.
     */
    @JvmName("hxepmovvxixksgss")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the DB event subscription. Conflicts with `name`.
     */
    @JvmName("ybaedgngfboqrbhj")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The SNS topic to send events to.
     */
    @JvmName("itoribdaqjuumxfi")
    public suspend fun snsTopic(`value`: Output<String>) {
        this.snsTopic = value
    }

    /**
     * @param value A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
     */
    @JvmName("eyhlkxhdtipgwwuo")
    public suspend fun sourceIds(`value`: Output<List<String>>) {
        this.sourceIds = value
    }

    @JvmName("dmntrkjyyaxlvnwr")
    public suspend fun sourceIds(vararg values: Output<String>) {
        this.sourceIds = Output.all(values.asList())
    }

    /**
     * @param values A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
     */
    @JvmName("qlaxeysqesxrwoas")
    public suspend fun sourceIds(values: List<Output<String>>) {
        this.sourceIds = Output.all(values)
    }

    /**
     * @param value The type of source that will be generating the events. Valid options are `db-instance`, `db-security-group`, `db-parameter-group`, `db-snapshot`, `db-cluster`, `db-cluster-snapshot`, or `db-proxy`. If not set, all sources will be subscribed to.
     */
    @JvmName("cpcaqkgkqgctdlio")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lellgbjlesmarakh")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A boolean flag to enable/disable the subscription. Defaults to true.
     */
    @JvmName("nmewrvqqrsehalvg")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value A list of event categories for a SourceType that you want to subscribe to. See http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html or run `aws rds describe-event-categories`.
     */
    @JvmName("ewbkiglqwxrmcaqm")
    public suspend fun eventCategories(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventCategories = mapped
    }

    /**
     * @param values A list of event categories for a SourceType that you want to subscribe to. See http://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html or run `aws rds describe-event-categories`.
     */
    @JvmName("jskdjxmstkmweknf")
    public suspend fun eventCategories(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventCategories = mapped
    }

    /**
     * @param value The name of the DB event subscription. By default generated by this provider.
     */
    @JvmName("wdrbvpcdoubhfcci")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the DB event subscription. Conflicts with `name`.
     */
    @JvmName("omaohdqwwgwghpin")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The SNS topic to send events to.
     */
    @JvmName("ihrlqgwcfxvtwomj")
    public suspend fun snsTopic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snsTopic = mapped
    }

    /**
     * @param value A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
     */
    @JvmName("ndrofdpkgtlsnxtm")
    public suspend fun sourceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceIds = mapped
    }

    /**
     * @param values A list of identifiers of the event sources for which events will be returned. If not specified, then all sources are included in the response. If specified, a source_type must also be specified.
     */
    @JvmName("mcexvgpcvvjrpyqg")
    public suspend fun sourceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIds = mapped
    }

    /**
     * @param value The type of source that will be generating the events. Valid options are `db-instance`, `db-security-group`, `db-parameter-group`, `db-snapshot`, `db-cluster`, `db-cluster-snapshot`, or `db-proxy`. If not set, all sources will be subscribed to.
     */
    @JvmName("nxhbkyesdxwusidh")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bonnwruqyfrmfseu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yurplcjebbxpcwre")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EventSubscriptionArgs = EventSubscriptionArgs(
        enabled = enabled,
        eventCategories = eventCategories,
        name = name,
        namePrefix = namePrefix,
        snsTopic = snsTopic,
        sourceIds = sourceIds,
        sourceType = sourceType,
        tags = tags,
    )
}
