@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.kotlin.outputs.ExportTaskTimeouts
import com.pulumi.aws.rds.kotlin.outputs.ExportTaskTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ExportTask].
 */
@PulumiTagMarker
public class ExportTaskResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExportTaskArgs = ExportTaskArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExportTaskArgsBuilder.() -> Unit) {
        val builder = ExportTaskArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ExportTask {
        val builtJavaResource = com.pulumi.aws.rds.ExportTask(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ExportTask(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS RDS (Relational Database) Export Task.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.ExportTask("example", {
 *     exportTaskIdentifier: "example",
 *     sourceArn: exampleAwsDbSnapshot.dbSnapshotArn,
 *     s3BucketName: exampleAwsS3Bucket.id,
 *     iamRoleArn: exampleAwsIamRole.arn,
 *     kmsKeyId: exampleAwsKmsKey.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.ExportTask("example",
 *     export_task_identifier="example",
 *     source_arn=example_aws_db_snapshot["dbSnapshotArn"],
 *     s3_bucket_name=example_aws_s3_bucket["id"],
 *     iam_role_arn=example_aws_iam_role["arn"],
 *     kms_key_id=example_aws_kms_key["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.ExportTask("example", new()
 *     {
 *         ExportTaskIdentifier = "example",
 *         SourceArn = exampleAwsDbSnapshot.DbSnapshotArn,
 *         S3BucketName = exampleAwsS3Bucket.Id,
 *         IamRoleArn = exampleAwsIamRole.Arn,
 *         KmsKeyId = exampleAwsKmsKey.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewExportTask(ctx, "example", &rds.ExportTaskArgs{
 * 			ExportTaskIdentifier: pulumi.String("example"),
 * 			SourceArn:            pulumi.Any(exampleAwsDbSnapshot.DbSnapshotArn),
 * 			S3BucketName:         pulumi.Any(exampleAwsS3Bucket.Id),
 * 			IamRoleArn:           pulumi.Any(exampleAwsIamRole.Arn),
 * 			KmsKeyId:             pulumi.Any(exampleAwsKmsKey.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.ExportTask;
 * import com.pulumi.aws.rds.ExportTaskArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ExportTask("example", ExportTaskArgs.builder()
 *             .exportTaskIdentifier("example")
 *             .sourceArn(exampleAwsDbSnapshot.dbSnapshotArn())
 *             .s3BucketName(exampleAwsS3Bucket.id())
 *             .iamRoleArn(exampleAwsIamRole.arn())
 *             .kmsKeyId(exampleAwsKmsKey.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:ExportTask
 *     properties:
 *       exportTaskIdentifier: example
 *       sourceArn: ${exampleAwsDbSnapshot.dbSnapshotArn}
 *       s3BucketName: ${exampleAwsS3Bucket.id}
 *       iamRoleArn: ${exampleAwsIamRole.arn}
 *       kmsKeyId: ${exampleAwsKmsKey.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Complete Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleBucketV2 = new aws.s3.BucketV2("example", {
 *     bucket: "example",
 *     forceDestroy: true,
 * });
 * const exampleBucketAclV2 = new aws.s3.BucketAclV2("example", {
 *     bucket: exampleBucketV2.id,
 *     acl: "private",
 * });
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "example",
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: "sts:AssumeRole",
 *             Effect: "Allow",
 *             Sid: "",
 *             Principal: {
 *                 Service: "export.rds.amazonaws.com",
 *             },
 *         }],
 *     }),
 * });
 * const example = aws.iam.getPolicyDocumentOutput({
 *     statements: [
 *         {
 *             actions: ["s3:ListAllMyBuckets"],
 *             resources: ["*"],
 *         },
 *         {
 *             actions: [
 *                 "s3:GetBucketLocation",
 *                 "s3:ListBucket",
 *             ],
 *             resources: [exampleBucketV2&#46;arn],
 *         },
 *         {
 *             actions: [
 *                 "s3:GetObject",
 *                 "s3:PutObject",
 *                 "s3:DeleteObject",
 *             ],
 *             resources: [pulumi&#46;interpolate`${exampleBucketV2&#46;arn}/*`],
 *         },
 *     ],
 * });
 * const examplePolicy = new aws.iam.Policy("example", {
 *     name: "example",
 *     policy: example.apply(example => example.json),
 * });
 * const exampleRolePolicyAttachment = new aws.iam.RolePolicyAttachment("example", {
 *     role: exampleRole.name,
 *     policyArn: examplePolicy.arn,
 * });
 * const exampleKey = new aws.kms.Key("example", {deletionWindowInDays: 10});
 * const exampleInstance = new aws.rds.Instance("example", {
 *     identifier: "example",
 *     allocatedStorage: 10,
 *     dbName: "test",
 *     engine: "mysql",
 *     engineVersion: "5.7",
 *     instanceClass: aws.rds.InstanceType.T3_Micro,
 *     username: "foo",
 *     password: "foobarbaz",
 *     parameterGroupName: "default.mysql5.7",
 *     skipFinalSnapshot: true,
 * });
 * const exampleSnapshot = new aws.rds.Snapshot("example", {
 *     dbInstanceIdentifier: exampleInstance.identifier,
 *     dbSnapshotIdentifier: "example",
 * });
 * const exampleExportTask = new aws.rds.ExportTask("example", {
 *     exportTaskIdentifier: "example",
 *     sourceArn: exampleSnapshot.dbSnapshotArn,
 *     s3BucketName: exampleBucketV2.id,
 *     iamRoleArn: exampleRole.arn,
 *     kmsKeyId: exampleKey.arn,
 *     exportOnlies: ["database"],
 *     s3Prefix: "my_prefix/example",
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example_bucket_v2 = aws.s3.BucketV2("example",
 *     bucket="example",
 *     force_destroy=True)
 * example_bucket_acl_v2 = aws.s3.BucketAclV2("example",
 *     bucket=example_bucket_v2.id,
 *     acl="private")
 * example_role = aws.iam.Role("example",
 *     name="example",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": "sts:AssumeRole",
 *             "Effect": "Allow",
 *             "Sid": "",
 *             "Principal": {
 *                 "Service": "export.rds.amazonaws.com",
 *             },
 *         }],
 *     }))
 * example = aws.iam.get_policy_document_output(statements=[
 *     {
 *         "actions": ["s3:ListAllMyBuckets"],
 *         "resources": ["*"],
 *     },
 *     {
 *         "actions": [
 *             "s3:GetBucketLocation",
 *             "s3:ListBucket",
 *         ],
 *         "resources": [example_bucket_v2&#46;arn],
 *     },
 *     {
 *         "actions": [
 *             "s3:GetObject",
 *             "s3:PutObject",
 *             "s3:DeleteObject",
 *         ],
 *         "resources": [example_bucket_v2&#46;arn&#46;apply(lambda arn: f"{arn}/*")],
 *     },
 * ])
 * example_policy = aws.iam.Policy("example",
 *     name="example",
 *     policy=example.json)
 * example_role_policy_attachment = aws.iam.RolePolicyAttachment("example",
 *     role=example_role.name,
 *     policy_arn=example_policy.arn)
 * example_key = aws.kms.Key("example", deletion_window_in_days=10)
 * example_instance = aws.rds.Instance("example",
 *     identifier="example",
 *     allocated_storage=10,
 *     db_name="test",
 *     engine="mysql",
 *     engine_version="5.7",
 *     instance_class=aws.rds.InstanceType.T3_MICRO,
 *     username="foo",
 *     password="foobarbaz",
 *     parameter_group_name="default.mysql5.7",
 *     skip_final_snapshot=True)
 * example_snapshot = aws.rds.Snapshot("example",
 *     db_instance_identifier=example_instance.identifier,
 *     db_snapshot_identifier="example")
 * example_export_task = aws.rds.ExportTask("example",
 *     export_task_identifier="example",
 *     source_arn=example_snapshot.db_snapshot_arn,
 *     s3_bucket_name=example_bucket_v2.id,
 *     iam_role_arn=example_role.arn,
 *     kms_key_id=example_key.arn,
 *     export_onlies=["database"],
 *     s3_prefix="my_prefix/example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleBucketV2 = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *         ForceDestroy = true,
 *     });
 *     var exampleBucketAclV2 = new Aws.S3.BucketAclV2("example", new()
 *     {
 *         Bucket = exampleBucketV2.Id,
 *         Acl = "private",
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "example",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = "sts:AssumeRole",
 *                     ["Effect"] = "Allow",
 *                     ["Sid"] = "",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "export.rds.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *     });
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "s3:ListAllMyBuckets",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "s3:GetBucketLocation",
 *                     "s3:ListBucket",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     exampleBucketV2.Arn,
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "s3:GetObject",
 *                     "s3:PutObject",
 *                     "s3:DeleteObject",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     $"{exampleBucketV2.Arn}/*",
 *                 },
 *             },
 *         },
 *     });
 *     var examplePolicy = new Aws.Iam.Policy("example", new()
 *     {
 *         Name = "example",
 *         PolicyDocument = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleRolePolicyAttachment = new Aws.Iam.RolePolicyAttachment("example", new()
 *     {
 *         Role = exampleRole.Name,
 *         PolicyArn = examplePolicy.Arn,
 *     });
 *     var exampleKey = new Aws.Kms.Key("example", new()
 *     {
 *         DeletionWindowInDays = 10,
 *     });
 *     var exampleInstance = new Aws.Rds.Instance("example", new()
 *     {
 *         Identifier = "example",
 *         AllocatedStorage = 10,
 *         DbName = "test",
 *         Engine = "mysql",
 *         EngineVersion = "5.7",
 *         InstanceClass = Aws.Rds.InstanceType.T3_Micro,
 *         Username = "foo",
 *         Password = "foobarbaz",
 *         ParameterGroupName = "default.mysql5.7",
 *         SkipFinalSnapshot = true,
 *     });
 *     var exampleSnapshot = new Aws.Rds.Snapshot("example", new()
 *     {
 *         DbInstanceIdentifier = exampleInstance.Identifier,
 *         DbSnapshotIdentifier = "example",
 *     });
 *     var exampleExportTask = new Aws.Rds.ExportTask("example", new()
 *     {
 *         ExportTaskIdentifier = "example",
 *         SourceArn = exampleSnapshot.DbSnapshotArn,
 *         S3BucketName = exampleBucketV2.Id,
 *         IamRoleArn = exampleRole.Arn,
 *         KmsKeyId = exampleKey.Arn,
 *         ExportOnlies = new[]
 *         {
 *             "database",
 *         },
 *         S3Prefix = "my_prefix/example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleBucketV2, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket:       pulumi.String("example"),
 * 			ForceDestroy: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketAclV2(ctx, "example", &s3.BucketAclV2Args{
 * 			Bucket: exampleBucketV2.ID(),
 * 			Acl:    pulumi.String("private"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": "sts:AssumeRole",
 * 					"Effect": "Allow",
 * 					"Sid":    "",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "export.rds.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("example"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("s3:ListAllMyBuckets"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						pulumi.String("*"),
 * 					},
 * 				},
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("s3:GetBucketLocation"),
 * 						pulumi.String("s3:ListBucket"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						exampleBucketV2.Arn,
 * 					},
 * 				},
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("s3:GetObject"),
 * 						pulumi.String("s3:PutObject"),
 * 						pulumi.String("s3:DeleteObject"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						exampleBucketV2.Arn.ApplyT(func(arn string) (string, error) {
 * 							return fmt.Sprintf("%v/*", arn), nil
 * 						}).(pulumi.StringOutput),
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		examplePolicy, err := iam.NewPolicy(ctx, "example", &iam.PolicyArgs{
 * 			Name: pulumi.String("example"),
 * 			Policy: pulumi.String(example.ApplyT(func(example iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &example.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "example", &iam.RolePolicyAttachmentArgs{
 * 			Role:      exampleRole.Name,
 * 			PolicyArn: examplePolicy.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleKey, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			DeletionWindowInDays: pulumi.Int(10),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleInstance, err := rds.NewInstance(ctx, "example", &rds.InstanceArgs{
 * 			Identifier:         pulumi.String("example"),
 * 			AllocatedStorage:   pulumi.Int(10),
 * 			DbName:             pulumi.String("test"),
 * 			Engine:             pulumi.String("mysql"),
 * 			EngineVersion:      pulumi.String("5.7"),
 * 			InstanceClass:      pulumi.String(rds.InstanceType_T3_Micro),
 * 			Username:           pulumi.String("foo"),
 * 			Password:           pulumi.String("foobarbaz"),
 * 			ParameterGroupName: pulumi.String("default.mysql5.7"),
 * 			SkipFinalSnapshot:  pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSnapshot, err := rds.NewSnapshot(ctx, "example", &rds.SnapshotArgs{
 * 			DbInstanceIdentifier: exampleInstance.Identifier,
 * 			DbSnapshotIdentifier: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewExportTask(ctx, "example", &rds.ExportTaskArgs{
 * 			ExportTaskIdentifier: pulumi.String("example"),
 * 			SourceArn:            exampleSnapshot.DbSnapshotArn,
 * 			S3BucketName:         exampleBucketV2.ID(),
 * 			IamRoleArn:           exampleRole.Arn,
 * 			KmsKeyId:             exampleKey.Arn,
 * 			ExportOnlies: pulumi.StringArray{
 * 				pulumi.String("database"),
 * 			},
 * 			S3Prefix: pulumi.String("my_prefix/example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import com.pulumi.aws.rds.Snapshot;
 * import com.pulumi.aws.rds.SnapshotArgs;
 * import com.pulumi.aws.rds.ExportTask;
 * import com.pulumi.aws.rds.ExportTaskArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .bucket("example")
 *             .forceDestroy(true)
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("example")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Sid", ""),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "export.rds.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .build());
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .actions("s3:ListAllMyBuckets")
 *                     .resources("*")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .actions(
 *                         "s3:GetBucketLocation",
 *                         "s3:ListBucket")
 *                     .resources(exampleBucketV2.arn())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .actions(
 *                         "s3:GetObject",
 *                         "s3:PutObject",
 *                         "s3:DeleteObject")
 *                     .resources(exampleBucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build())
 *             .build());
 *         var examplePolicy = new Policy("examplePolicy", PolicyArgs.builder()
 *             .name("example")
 *             .policy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(example -> example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var exampleRolePolicyAttachment = new RolePolicyAttachment("exampleRolePolicyAttachment", RolePolicyAttachmentArgs.builder()
 *             .role(exampleRole.name())
 *             .policyArn(examplePolicy.arn())
 *             .build());
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .deletionWindowInDays(10)
 *             .build());
 *         var exampleInstance = new Instance("exampleInstance", InstanceArgs.builder()
 *             .identifier("example")
 *             .allocatedStorage(10)
 *             .dbName("test")
 *             .engine("mysql")
 *             .engineVersion("5.7")
 *             .instanceClass("db.t3.micro")
 *             .username("foo")
 *             .password("foobarbaz")
 *             .parameterGroupName("default.mysql5.7")
 *             .skipFinalSnapshot(true)
 *             .build());
 *         var exampleSnapshot = new Snapshot("exampleSnapshot", SnapshotArgs.builder()
 *             .dbInstanceIdentifier(exampleInstance.identifier())
 *             .dbSnapshotIdentifier("example")
 *             .build());
 *         var exampleExportTask = new ExportTask("exampleExportTask", ExportTaskArgs.builder()
 *             .exportTaskIdentifier("example")
 *             .sourceArn(exampleSnapshot.dbSnapshotArn())
 *             .s3BucketName(exampleBucketV2.id())
 *             .iamRoleArn(exampleRole.arn())
 *             .kmsKeyId(exampleKey.arn())
 *             .exportOnlies("database")
 *             .s3Prefix("my_prefix/example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleBucketV2:
 *     type: aws:s3:BucketV2
 *     name: example
 *     properties:
 *       bucket: example
 *       forceDestroy: true
 *   exampleBucketAclV2:
 *     type: aws:s3:BucketAclV2
 *     name: example
 *     properties:
 *       bucket: ${exampleBucketV2.id}
 *       acl: private
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: example
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action: sts:AssumeRole
 *               Effect: Allow
 *               Sid:
 *               Principal:
 *                 Service: export.rds.amazonaws.com
 *   examplePolicy:
 *     type: aws:iam:Policy
 *     name: example
 *     properties:
 *       name: example
 *       policy: ${example.json}
 *   exampleRolePolicyAttachment:
 *     type: aws:iam:RolePolicyAttachment
 *     name: example
 *     properties:
 *       role: ${exampleRole.name}
 *       policyArn: ${examplePolicy.arn}
 *   exampleKey:
 *     type: aws:kms:Key
 *     name: example
 *     properties:
 *       deletionWindowInDays: 10
 *   exampleInstance:
 *     type: aws:rds:Instance
 *     name: example
 *     properties:
 *       identifier: example
 *       allocatedStorage: 10
 *       dbName: test
 *       engine: mysql
 *       engineVersion: '5.7'
 *       instanceClass: db.t3.micro
 *       username: foo
 *       password: foobarbaz
 *       parameterGroupName: default.mysql5.7
 *       skipFinalSnapshot: true
 *   exampleSnapshot:
 *     type: aws:rds:Snapshot
 *     name: example
 *     properties:
 *       dbInstanceIdentifier: ${exampleInstance.identifier}
 *       dbSnapshotIdentifier: example
 *   exampleExportTask:
 *     type: aws:rds:ExportTask
 *     name: example
 *     properties:
 *       exportTaskIdentifier: example
 *       sourceArn: ${exampleSnapshot.dbSnapshotArn}
 *       s3BucketName: ${exampleBucketV2.id}
 *       iamRoleArn: ${exampleRole.arn}
 *       kmsKeyId: ${exampleKey.arn}
 *       exportOnlies:
 *         - database
 *       s3Prefix: my_prefix/example
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - s3:ListAllMyBuckets
 *             resources:
 *               - '*'
 *           - actions:
 *               - s3:GetBucketLocation
 *               - s3:ListBucket
 *             resources:
 *               - ${exampleBucketV2.arn}
 *           - actions:
 *               - s3:GetObject
 *               - s3:PutObject
 *               - s3:DeleteObject
 *             resources:
 *               - ${exampleBucketV2.arn}/*
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a RDS (Relational Database) Export Task using the `export_task_identifier`. For example:
 * ```sh
 * $ pulumi import aws:rds/exportTask:ExportTask example example
 * ```
 * */*/*/*/*/*/
 */
public class ExportTask internal constructor(
    override val javaResource: com.pulumi.aws.rds.ExportTask,
) : KotlinCustomResource(javaResource, ExportTaskMapper) {
    /**
     * Data to be exported from the snapshot. If this parameter is not provided, all the snapshot data is exported. Valid values are documented in the [AWS StartExportTask API documentation](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestParameters).
     */
    public val exportOnlies: Output<List<String>>?
        get() = javaResource.exportOnlies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Unique identifier for the snapshot export task.
     */
    public val exportTaskIdentifier: Output<String>
        get() = javaResource.exportTaskIdentifier().applyValue({ args0 -> args0 })

    /**
     * Reason the export failed, if it failed.
     */
    public val failureCause: Output<String>
        get() = javaResource.failureCause().applyValue({ args0 -> args0 })

    /**
     * ARN of the IAM role to use for writing to the Amazon S3 bucket.
     */
    public val iamRoleArn: Output<String>
        get() = javaResource.iamRoleArn().applyValue({ args0 -> args0 })

    /**
     * ID of the Amazon Web Services KMS key to use to encrypt the snapshot.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Progress of the snapshot export task as a percentage.
     */
    public val percentProgress: Output<Int>
        get() = javaResource.percentProgress().applyValue({ args0 -> args0 })

    /**
     * Name of the Amazon S3 bucket to export the snapshot to.
     */
    public val s3BucketName: Output<String>
        get() = javaResource.s3BucketName().applyValue({ args0 -> args0 })

    /**
     * Amazon S3 bucket prefix to use as the file name and path of the exported snapshot.
     */
    public val s3Prefix: Output<String>
        get() = javaResource.s3Prefix().applyValue({ args0 -> args0 })

    /**
     * Time that the snapshot was created.
     */
    public val snapshotTime: Output<String>
        get() = javaResource.snapshotTime().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the snapshot to export.
     * The following arguments are optional:
     */
    public val sourceArn: Output<String>
        get() = javaResource.sourceArn().applyValue({ args0 -> args0 })

    /**
     * Type of source for the export.
     */
    public val sourceType: Output<String>
        get() = javaResource.sourceType().applyValue({ args0 -> args0 })

    /**
     * Status of the export task.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Time that the snapshot export task completed.
     */
    public val taskEndTime: Output<String>
        get() = javaResource.taskEndTime().applyValue({ args0 -> args0 })

    /**
     * Time that the snapshot export task started.
     */
    public val taskStartTime: Output<String>
        get() = javaResource.taskStartTime().applyValue({ args0 -> args0 })

    public val timeouts: Output<ExportTaskTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Warning about the snapshot export task, if any.
     */
    public val warningMessage: Output<String>
        get() = javaResource.warningMessage().applyValue({ args0 -> args0 })
}

public object ExportTaskMapper : ResourceMapper<ExportTask> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.ExportTask::class == javaResource::class

    override fun map(javaResource: Resource): ExportTask = ExportTask(
        javaResource as
            com.pulumi.aws.rds.ExportTask,
    )
}

/**
 * @see [ExportTask].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ExportTask].
 */
public suspend fun exportTask(name: String, block: suspend ExportTaskResourceBuilder.() -> Unit): ExportTask {
    val builder = ExportTaskResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ExportTask].
 * @param name The _unique_ name of the resulting resource.
 */
public fun exportTask(name: String): ExportTask {
    val builder = ExportTaskResourceBuilder()
    builder.name(name)
    return builder.build()
}
