@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.kotlin.outputs.GlobalClusterGlobalClusterMember
import com.pulumi.aws.rds.kotlin.outputs.GlobalClusterGlobalClusterMember.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [GlobalCluster].
 */
@PulumiTagMarker
public class GlobalClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GlobalClusterArgs = GlobalClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GlobalClusterArgsBuilder.() -> Unit) {
        val builder = GlobalClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GlobalCluster {
        val builtJavaResource = com.pulumi.aws.rds.GlobalCluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GlobalCluster(builtJavaResource)
    }
}

/**
 * Manages an RDS Global Cluster, which is an Aurora global database spread across multiple regions. The global database contains a single primary cluster with read-write capability, and a read-only secondary cluster that receives data from the primary cluster through high-speed replication performed by the Aurora storage subsystem.
 * More information about Aurora global databases can be found in the [Aurora User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html#aurora-global-database-creating).
 * ## Example Usage
 * ### New MySQL Global Cluster
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.GlobalCluster("example", {
 *     globalClusterIdentifier: "global-test",
 *     engine: "aurora",
 *     engineVersion: "5.6.mysql_aurora.1.22.2",
 *     databaseName: "example_db",
 * });
 * const primary = new aws.rds.Cluster("primary", {
 *     engine: example.engine,
 *     engineVersion: example.engineVersion,
 *     clusterIdentifier: "test-primary-cluster",
 *     masterUsername: "username",
 *     masterPassword: "somepass123",
 *     databaseName: "example_db",
 *     globalClusterIdentifier: example.id,
 *     dbSubnetGroupName: "default",
 * });
 * const primaryClusterInstance = new aws.rds.ClusterInstance("primary", {
 *     engine: example.engine,
 *     engineVersion: example.engineVersion,
 *     identifier: "test-primary-cluster-instance",
 *     clusterIdentifier: primary.id,
 *     instanceClass: aws.rds.InstanceType.R4_Large,
 *     dbSubnetGroupName: "default",
 * });
 * const secondary = new aws.rds.Cluster("secondary", {
 *     engine: example.engine,
 *     engineVersion: example.engineVersion,
 *     clusterIdentifier: "test-secondary-cluster",
 *     globalClusterIdentifier: example.id,
 *     dbSubnetGroupName: "default",
 * }, {
 *     dependsOn: [primaryClusterInstance],
 * });
 * const secondaryClusterInstance = new aws.rds.ClusterInstance("secondary", {
 *     engine: example.engine,
 *     engineVersion: example.engineVersion,
 *     identifier: "test-secondary-cluster-instance",
 *     clusterIdentifier: secondary.id,
 *     instanceClass: aws.rds.InstanceType.R4_Large,
 *     dbSubnetGroupName: "default",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.GlobalCluster("example",
 *     global_cluster_identifier="global-test",
 *     engine="aurora",
 *     engine_version="5.6.mysql_aurora.1.22.2",
 *     database_name="example_db")
 * primary = aws.rds.Cluster("primary",
 *     engine=example.engine,
 *     engine_version=example.engine_version,
 *     cluster_identifier="test-primary-cluster",
 *     master_username="username",
 *     master_password="somepass123",
 *     database_name="example_db",
 *     global_cluster_identifier=example.id,
 *     db_subnet_group_name="default")
 * primary_cluster_instance = aws.rds.ClusterInstance("primary",
 *     engine=example.engine,
 *     engine_version=example.engine_version,
 *     identifier="test-primary-cluster-instance",
 *     cluster_identifier=primary.id,
 *     instance_class=aws.rds.InstanceType.R4_LARGE,
 *     db_subnet_group_name="default")
 * secondary = aws.rds.Cluster("secondary",
 *     engine=example.engine,
 *     engine_version=example.engine_version,
 *     cluster_identifier="test-secondary-cluster",
 *     global_cluster_identifier=example.id,
 *     db_subnet_group_name="default",
 *     opts = pulumi.ResourceOptions(depends_on=[primary_cluster_instance]))
 * secondary_cluster_instance = aws.rds.ClusterInstance("secondary",
 *     engine=example.engine,
 *     engine_version=example.engine_version,
 *     identifier="test-secondary-cluster-instance",
 *     cluster_identifier=secondary.id,
 *     instance_class=aws.rds.InstanceType.R4_LARGE,
 *     db_subnet_group_name="default")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.GlobalCluster("example", new()
 *     {
 *         GlobalClusterIdentifier = "global-test",
 *         Engine = "aurora",
 *         EngineVersion = "5.6.mysql_aurora.1.22.2",
 *         DatabaseName = "example_db",
 *     });
 *     var primary = new Aws.Rds.Cluster("primary", new()
 *     {
 *         Engine = example.Engine,
 *         EngineVersion = example.EngineVersion,
 *         ClusterIdentifier = "test-primary-cluster",
 *         MasterUsername = "username",
 *         MasterPassword = "somepass123",
 *         DatabaseName = "example_db",
 *         GlobalClusterIdentifier = example.Id,
 *         DbSubnetGroupName = "default",
 *     });
 *     var primaryClusterInstance = new Aws.Rds.ClusterInstance("primary", new()
 *     {
 *         Engine = example.Engine,
 *         EngineVersion = example.EngineVersion,
 *         Identifier = "test-primary-cluster-instance",
 *         ClusterIdentifier = primary.Id,
 *         InstanceClass = Aws.Rds.InstanceType.R4_Large,
 *         DbSubnetGroupName = "default",
 *     });
 *     var secondary = new Aws.Rds.Cluster("secondary", new()
 *     {
 *         Engine = example.Engine,
 *         EngineVersion = example.EngineVersion,
 *         ClusterIdentifier = "test-secondary-cluster",
 *         GlobalClusterIdentifier = example.Id,
 *         DbSubnetGroupName = "default",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             primaryClusterInstance,
 *         },
 *     });
 *     var secondaryClusterInstance = new Aws.Rds.ClusterInstance("secondary", new()
 *     {
 *         Engine = example.Engine,
 *         EngineVersion = example.EngineVersion,
 *         Identifier = "test-secondary-cluster-instance",
 *         ClusterIdentifier = secondary.Id,
 *         InstanceClass = Aws.Rds.InstanceType.R4_Large,
 *         DbSubnetGroupName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := rds.NewGlobalCluster(ctx, "example", &rds.GlobalClusterArgs{
 * 			GlobalClusterIdentifier: pulumi.String("global-test"),
 * 			Engine:                  pulumi.String("aurora"),
 * 			EngineVersion:           pulumi.String("5.6.mysql_aurora.1.22.2"),
 * 			DatabaseName:            pulumi.String("example_db"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		primary, err := rds.NewCluster(ctx, "primary", &rds.ClusterArgs{
 * 			Engine:                  example.Engine,
 * 			EngineVersion:           example.EngineVersion,
 * 			ClusterIdentifier:       pulumi.String("test-primary-cluster"),
 * 			MasterUsername:          pulumi.String("username"),
 * 			MasterPassword:          pulumi.String("somepass123"),
 * 			DatabaseName:            pulumi.String("example_db"),
 * 			GlobalClusterIdentifier: example.ID(),
 * 			DbSubnetGroupName:       pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		primaryClusterInstance, err := rds.NewClusterInstance(ctx, "primary", &rds.ClusterInstanceArgs{
 * 			Engine:            example.Engine,
 * 			EngineVersion:     example.EngineVersion,
 * 			Identifier:        pulumi.String("test-primary-cluster-instance"),
 * 			ClusterIdentifier: primary.ID(),
 * 			InstanceClass:     pulumi.String(rds.InstanceType_R4_Large),
 * 			DbSubnetGroupName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		secondary, err := rds.NewCluster(ctx, "secondary", &rds.ClusterArgs{
 * 			Engine:                  example.Engine,
 * 			EngineVersion:           example.EngineVersion,
 * 			ClusterIdentifier:       pulumi.String("test-secondary-cluster"),
 * 			GlobalClusterIdentifier: example.ID(),
 * 			DbSubnetGroupName:       pulumi.String("default"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			primaryClusterInstance,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewClusterInstance(ctx, "secondary", &rds.ClusterInstanceArgs{
 * 			Engine:            example.Engine,
 * 			EngineVersion:     example.EngineVersion,
 * 			Identifier:        pulumi.String("test-secondary-cluster-instance"),
 * 			ClusterIdentifier: secondary.ID(),
 * 			InstanceClass:     pulumi.String(rds.InstanceType_R4_Large),
 * 			DbSubnetGroupName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.GlobalCluster;
 * import com.pulumi.aws.rds.GlobalClusterArgs;
 * import com.pulumi.aws.rds.Cluster;
 * import com.pulumi.aws.rds.ClusterArgs;
 * import com.pulumi.aws.rds.ClusterInstance;
 * import com.pulumi.aws.rds.ClusterInstanceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GlobalCluster("example", GlobalClusterArgs.builder()
 *             .globalClusterIdentifier("global-test")
 *             .engine("aurora")
 *             .engineVersion("5.6.mysql_aurora.1.22.2")
 *             .databaseName("example_db")
 *             .build());
 *         var primary = new Cluster("primary", ClusterArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .clusterIdentifier("test-primary-cluster")
 *             .masterUsername("username")
 *             .masterPassword("somepass123")
 *             .databaseName("example_db")
 *             .globalClusterIdentifier(example.id())
 *             .dbSubnetGroupName("default")
 *             .build());
 *         var primaryClusterInstance = new ClusterInstance("primaryClusterInstance", ClusterInstanceArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .identifier("test-primary-cluster-instance")
 *             .clusterIdentifier(primary.id())
 *             .instanceClass("db.r4.large")
 *             .dbSubnetGroupName("default")
 *             .build());
 *         var secondary = new Cluster("secondary", ClusterArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .clusterIdentifier("test-secondary-cluster")
 *             .globalClusterIdentifier(example.id())
 *             .dbSubnetGroupName("default")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(primaryClusterInstance)
 *                 .build());
 *         var secondaryClusterInstance = new ClusterInstance("secondaryClusterInstance", ClusterInstanceArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .identifier("test-secondary-cluster-instance")
 *             .clusterIdentifier(secondary.id())
 *             .instanceClass("db.r4.large")
 *             .dbSubnetGroupName("default")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:GlobalCluster
 *     properties:
 *       globalClusterIdentifier: global-test
 *       engine: aurora
 *       engineVersion: 5.6.mysql_aurora.1.22.2
 *       databaseName: example_db
 *   primary:
 *     type: aws:rds:Cluster
 *     properties:
 *       engine: ${example.engine}
 *       engineVersion: ${example.engineVersion}
 *       clusterIdentifier: test-primary-cluster
 *       masterUsername: username
 *       masterPassword: somepass123
 *       databaseName: example_db
 *       globalClusterIdentifier: ${example.id}
 *       dbSubnetGroupName: default
 *   primaryClusterInstance:
 *     type: aws:rds:ClusterInstance
 *     name: primary
 *     properties:
 *       engine: ${example.engine}
 *       engineVersion: ${example.engineVersion}
 *       identifier: test-primary-cluster-instance
 *       clusterIdentifier: ${primary.id}
 *       instanceClass: db.r4.large
 *       dbSubnetGroupName: default
 *   secondary:
 *     type: aws:rds:Cluster
 *     properties:
 *       engine: ${example.engine}
 *       engineVersion: ${example.engineVersion}
 *       clusterIdentifier: test-secondary-cluster
 *       globalClusterIdentifier: ${example.id}
 *       dbSubnetGroupName: default
 *     options:
 *       dependson:
 *         - ${primaryClusterInstance}
 *   secondaryClusterInstance:
 *     type: aws:rds:ClusterInstance
 *     name: secondary
 *     properties:
 *       engine: ${example.engine}
 *       engineVersion: ${example.engineVersion}
 *       identifier: test-secondary-cluster-instance
 *       clusterIdentifier: ${secondary.id}
 *       instanceClass: db.r4.large
 *       dbSubnetGroupName: default
 * ```
 * <!--End PulumiCodeChooser -->
 * ### New PostgreSQL Global Cluster
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.GlobalCluster("example", {
 *     globalClusterIdentifier: "global-test",
 *     engine: "aurora-postgresql",
 *     engineVersion: "11.9",
 *     databaseName: "example_db",
 * });
 * const primary = new aws.rds.Cluster("primary", {
 *     engine: example.engine,
 *     engineVersion: example.engineVersion,
 *     clusterIdentifier: "test-primary-cluster",
 *     masterUsername: "username",
 *     masterPassword: "somepass123",
 *     databaseName: "example_db",
 *     globalClusterIdentifier: example.id,
 *     dbSubnetGroupName: "default",
 * });
 * const primaryClusterInstance = new aws.rds.ClusterInstance("primary", {
 *     engine: example.engine,
 *     engineVersion: example.engineVersion,
 *     identifier: "test-primary-cluster-instance",
 *     clusterIdentifier: primary.id,
 *     instanceClass: aws.rds.InstanceType.R4_Large,
 *     dbSubnetGroupName: "default",
 * });
 * const secondary = new aws.rds.Cluster("secondary", {
 *     engine: example.engine,
 *     engineVersion: example.engineVersion,
 *     clusterIdentifier: "test-secondary-cluster",
 *     globalClusterIdentifier: example.id,
 *     skipFinalSnapshot: true,
 *     dbSubnetGroupName: "default",
 * }, {
 *     dependsOn: [primaryClusterInstance],
 * });
 * const secondaryClusterInstance = new aws.rds.ClusterInstance("secondary", {
 *     engine: example.engine,
 *     engineVersion: example.engineVersion,
 *     identifier: "test-secondary-cluster-instance",
 *     clusterIdentifier: secondary.id,
 *     instanceClass: aws.rds.InstanceType.R4_Large,
 *     dbSubnetGroupName: "default",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.GlobalCluster("example",
 *     global_cluster_identifier="global-test",
 *     engine="aurora-postgresql",
 *     engine_version="11.9",
 *     database_name="example_db")
 * primary = aws.rds.Cluster("primary",
 *     engine=example.engine,
 *     engine_version=example.engine_version,
 *     cluster_identifier="test-primary-cluster",
 *     master_username="username",
 *     master_password="somepass123",
 *     database_name="example_db",
 *     global_cluster_identifier=example.id,
 *     db_subnet_group_name="default")
 * primary_cluster_instance = aws.rds.ClusterInstance("primary",
 *     engine=example.engine,
 *     engine_version=example.engine_version,
 *     identifier="test-primary-cluster-instance",
 *     cluster_identifier=primary.id,
 *     instance_class=aws.rds.InstanceType.R4_LARGE,
 *     db_subnet_group_name="default")
 * secondary = aws.rds.Cluster("secondary",
 *     engine=example.engine,
 *     engine_version=example.engine_version,
 *     cluster_identifier="test-secondary-cluster",
 *     global_cluster_identifier=example.id,
 *     skip_final_snapshot=True,
 *     db_subnet_group_name="default",
 *     opts = pulumi.ResourceOptions(depends_on=[primary_cluster_instance]))
 * secondary_cluster_instance = aws.rds.ClusterInstance("secondary",
 *     engine=example.engine,
 *     engine_version=example.engine_version,
 *     identifier="test-secondary-cluster-instance",
 *     cluster_identifier=secondary.id,
 *     instance_class=aws.rds.InstanceType.R4_LARGE,
 *     db_subnet_group_name="default")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.GlobalCluster("example", new()
 *     {
 *         GlobalClusterIdentifier = "global-test",
 *         Engine = "aurora-postgresql",
 *         EngineVersion = "11.9",
 *         DatabaseName = "example_db",
 *     });
 *     var primary = new Aws.Rds.Cluster("primary", new()
 *     {
 *         Engine = example.Engine,
 *         EngineVersion = example.EngineVersion,
 *         ClusterIdentifier = "test-primary-cluster",
 *         MasterUsername = "username",
 *         MasterPassword = "somepass123",
 *         DatabaseName = "example_db",
 *         GlobalClusterIdentifier = example.Id,
 *         DbSubnetGroupName = "default",
 *     });
 *     var primaryClusterInstance = new Aws.Rds.ClusterInstance("primary", new()
 *     {
 *         Engine = example.Engine,
 *         EngineVersion = example.EngineVersion,
 *         Identifier = "test-primary-cluster-instance",
 *         ClusterIdentifier = primary.Id,
 *         InstanceClass = Aws.Rds.InstanceType.R4_Large,
 *         DbSubnetGroupName = "default",
 *     });
 *     var secondary = new Aws.Rds.Cluster("secondary", new()
 *     {
 *         Engine = example.Engine,
 *         EngineVersion = example.EngineVersion,
 *         ClusterIdentifier = "test-secondary-cluster",
 *         GlobalClusterIdentifier = example.Id,
 *         SkipFinalSnapshot = true,
 *         DbSubnetGroupName = "default",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             primaryClusterInstance,
 *         },
 *     });
 *     var secondaryClusterInstance = new Aws.Rds.ClusterInstance("secondary", new()
 *     {
 *         Engine = example.Engine,
 *         EngineVersion = example.EngineVersion,
 *         Identifier = "test-secondary-cluster-instance",
 *         ClusterIdentifier = secondary.Id,
 *         InstanceClass = Aws.Rds.InstanceType.R4_Large,
 *         DbSubnetGroupName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := rds.NewGlobalCluster(ctx, "example", &rds.GlobalClusterArgs{
 * 			GlobalClusterIdentifier: pulumi.String("global-test"),
 * 			Engine:                  pulumi.String("aurora-postgresql"),
 * 			EngineVersion:           pulumi.String("11.9"),
 * 			DatabaseName:            pulumi.String("example_db"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		primary, err := rds.NewCluster(ctx, "primary", &rds.ClusterArgs{
 * 			Engine:                  example.Engine,
 * 			EngineVersion:           example.EngineVersion,
 * 			ClusterIdentifier:       pulumi.String("test-primary-cluster"),
 * 			MasterUsername:          pulumi.String("username"),
 * 			MasterPassword:          pulumi.String("somepass123"),
 * 			DatabaseName:            pulumi.String("example_db"),
 * 			GlobalClusterIdentifier: example.ID(),
 * 			DbSubnetGroupName:       pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		primaryClusterInstance, err := rds.NewClusterInstance(ctx, "primary", &rds.ClusterInstanceArgs{
 * 			Engine:            example.Engine,
 * 			EngineVersion:     example.EngineVersion,
 * 			Identifier:        pulumi.String("test-primary-cluster-instance"),
 * 			ClusterIdentifier: primary.ID(),
 * 			InstanceClass:     pulumi.String(rds.InstanceType_R4_Large),
 * 			DbSubnetGroupName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		secondary, err := rds.NewCluster(ctx, "secondary", &rds.ClusterArgs{
 * 			Engine:                  example.Engine,
 * 			EngineVersion:           example.EngineVersion,
 * 			ClusterIdentifier:       pulumi.String("test-secondary-cluster"),
 * 			GlobalClusterIdentifier: example.ID(),
 * 			SkipFinalSnapshot:       pulumi.Bool(true),
 * 			DbSubnetGroupName:       pulumi.String("default"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			primaryClusterInstance,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewClusterInstance(ctx, "secondary", &rds.ClusterInstanceArgs{
 * 			Engine:            example.Engine,
 * 			EngineVersion:     example.EngineVersion,
 * 			Identifier:        pulumi.String("test-secondary-cluster-instance"),
 * 			ClusterIdentifier: secondary.ID(),
 * 			InstanceClass:     pulumi.String(rds.InstanceType_R4_Large),
 * 			DbSubnetGroupName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.GlobalCluster;
 * import com.pulumi.aws.rds.GlobalClusterArgs;
 * import com.pulumi.aws.rds.Cluster;
 * import com.pulumi.aws.rds.ClusterArgs;
 * import com.pulumi.aws.rds.ClusterInstance;
 * import com.pulumi.aws.rds.ClusterInstanceArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GlobalCluster("example", GlobalClusterArgs.builder()
 *             .globalClusterIdentifier("global-test")
 *             .engine("aurora-postgresql")
 *             .engineVersion("11.9")
 *             .databaseName("example_db")
 *             .build());
 *         var primary = new Cluster("primary", ClusterArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .clusterIdentifier("test-primary-cluster")
 *             .masterUsername("username")
 *             .masterPassword("somepass123")
 *             .databaseName("example_db")
 *             .globalClusterIdentifier(example.id())
 *             .dbSubnetGroupName("default")
 *             .build());
 *         var primaryClusterInstance = new ClusterInstance("primaryClusterInstance", ClusterInstanceArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .identifier("test-primary-cluster-instance")
 *             .clusterIdentifier(primary.id())
 *             .instanceClass("db.r4.large")
 *             .dbSubnetGroupName("default")
 *             .build());
 *         var secondary = new Cluster("secondary", ClusterArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .clusterIdentifier("test-secondary-cluster")
 *             .globalClusterIdentifier(example.id())
 *             .skipFinalSnapshot(true)
 *             .dbSubnetGroupName("default")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(primaryClusterInstance)
 *                 .build());
 *         var secondaryClusterInstance = new ClusterInstance("secondaryClusterInstance", ClusterInstanceArgs.builder()
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .identifier("test-secondary-cluster-instance")
 *             .clusterIdentifier(secondary.id())
 *             .instanceClass("db.r4.large")
 *             .dbSubnetGroupName("default")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:GlobalCluster
 *     properties:
 *       globalClusterIdentifier: global-test
 *       engine: aurora-postgresql
 *       engineVersion: '11.9'
 *       databaseName: example_db
 *   primary:
 *     type: aws:rds:Cluster
 *     properties:
 *       engine: ${example.engine}
 *       engineVersion: ${example.engineVersion}
 *       clusterIdentifier: test-primary-cluster
 *       masterUsername: username
 *       masterPassword: somepass123
 *       databaseName: example_db
 *       globalClusterIdentifier: ${example.id}
 *       dbSubnetGroupName: default
 *   primaryClusterInstance:
 *     type: aws:rds:ClusterInstance
 *     name: primary
 *     properties:
 *       engine: ${example.engine}
 *       engineVersion: ${example.engineVersion}
 *       identifier: test-primary-cluster-instance
 *       clusterIdentifier: ${primary.id}
 *       instanceClass: db.r4.large
 *       dbSubnetGroupName: default
 *   secondary:
 *     type: aws:rds:Cluster
 *     properties:
 *       engine: ${example.engine}
 *       engineVersion: ${example.engineVersion}
 *       clusterIdentifier: test-secondary-cluster
 *       globalClusterIdentifier: ${example.id}
 *       skipFinalSnapshot: true
 *       dbSubnetGroupName: default
 *     options:
 *       dependson:
 *         - ${primaryClusterInstance}
 *   secondaryClusterInstance:
 *     type: aws:rds:ClusterInstance
 *     name: secondary
 *     properties:
 *       engine: ${example.engine}
 *       engineVersion: ${example.engineVersion}
 *       identifier: test-secondary-cluster-instance
 *       clusterIdentifier: ${secondary.id}
 *       instanceClass: db.r4.large
 *       dbSubnetGroupName: default
 * ```
 * <!--End PulumiCodeChooser -->
 * ### New Global Cluster From Existing DB Cluster
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.Cluster("example", {});
 * const exampleGlobalCluster = new aws.rds.GlobalCluster("example", {
 *     forceDestroy: true,
 *     globalClusterIdentifier: "example",
 *     sourceDbClusterIdentifier: example.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.Cluster("example")
 * example_global_cluster = aws.rds.GlobalCluster("example",
 *     force_destroy=True,
 *     global_cluster_identifier="example",
 *     source_db_cluster_identifier=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.Cluster("example");
 *     var exampleGlobalCluster = new Aws.Rds.GlobalCluster("example", new()
 *     {
 *         ForceDestroy = true,
 *         GlobalClusterIdentifier = "example",
 *         SourceDbClusterIdentifier = example.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := rds.NewCluster(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewGlobalCluster(ctx, "example", &rds.GlobalClusterArgs{
 * 			ForceDestroy:              pulumi.Bool(true),
 * 			GlobalClusterIdentifier:   pulumi.String("example"),
 * 			SourceDbClusterIdentifier: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Cluster;
 * import com.pulumi.aws.rds.GlobalCluster;
 * import com.pulumi.aws.rds.GlobalClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Cluster("example");
 *         var exampleGlobalCluster = new GlobalCluster("exampleGlobalCluster", GlobalClusterArgs.builder()
 *             .forceDestroy(true)
 *             .globalClusterIdentifier("example")
 *             .sourceDbClusterIdentifier(example.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:Cluster
 *   exampleGlobalCluster:
 *     type: aws:rds:GlobalCluster
 *     name: example
 *     properties:
 *       forceDestroy: true
 *       globalClusterIdentifier: example
 *       sourceDbClusterIdentifier: ${example.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Upgrading Engine Versions
 * When you upgrade the version of an `aws.rds.GlobalCluster`, the provider will attempt to in-place upgrade the engine versions of all associated clusters. Since the `aws.rds.Cluster` resource is being updated through the `aws.rds.GlobalCluster`, you are likely to get an error (`Provider produced inconsistent final plan`). To avoid this, use the `lifecycle` `ignore_changes` meta argument as shown below on the `aws.rds.Cluster`.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.GlobalCluster("example", {
 *     globalClusterIdentifier: "kyivkharkiv",
 *     engine: "aurora-mysql",
 *     engineVersion: "5.7.mysql_aurora.2.07.5",
 * });
 * const primary = new aws.rds.Cluster("primary", {
 *     allowMajorVersionUpgrade: true,
 *     applyImmediately: true,
 *     clusterIdentifier: "odessadnipro",
 *     databaseName: "totoro",
 *     engine: example.engine,
 *     engineVersion: example.engineVersion,
 *     globalClusterIdentifier: example.id,
 *     masterPassword: "satsukimae",
 *     masterUsername: "maesatsuki",
 *     skipFinalSnapshot: true,
 * });
 * const primaryClusterInstance = new aws.rds.ClusterInstance("primary", {
 *     applyImmediately: true,
 *     clusterIdentifier: primary.id,
 *     engine: primary.engine,
 *     engineVersion: primary.engineVersion,
 *     identifier: "donetsklviv",
 *     instanceClass: aws.rds.InstanceType.R4_Large,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.GlobalCluster("example",
 *     global_cluster_identifier="kyivkharkiv",
 *     engine="aurora-mysql",
 *     engine_version="5.7.mysql_aurora.2.07.5")
 * primary = aws.rds.Cluster("primary",
 *     allow_major_version_upgrade=True,
 *     apply_immediately=True,
 *     cluster_identifier="odessadnipro",
 *     database_name="totoro",
 *     engine=example.engine,
 *     engine_version=example.engine_version,
 *     global_cluster_identifier=example.id,
 *     master_password="satsukimae",
 *     master_username="maesatsuki",
 *     skip_final_snapshot=True)
 * primary_cluster_instance = aws.rds.ClusterInstance("primary",
 *     apply_immediately=True,
 *     cluster_identifier=primary.id,
 *     engine=primary.engine,
 *     engine_version=primary.engine_version,
 *     identifier="donetsklviv",
 *     instance_class=aws.rds.InstanceType.R4_LARGE)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.GlobalCluster("example", new()
 *     {
 *         GlobalClusterIdentifier = "kyivkharkiv",
 *         Engine = "aurora-mysql",
 *         EngineVersion = "5.7.mysql_aurora.2.07.5",
 *     });
 *     var primary = new Aws.Rds.Cluster("primary", new()
 *     {
 *         AllowMajorVersionUpgrade = true,
 *         ApplyImmediately = true,
 *         ClusterIdentifier = "odessadnipro",
 *         DatabaseName = "totoro",
 *         Engine = example.Engine,
 *         EngineVersion = example.EngineVersion,
 *         GlobalClusterIdentifier = example.Id,
 *         MasterPassword = "satsukimae",
 *         MasterUsername = "maesatsuki",
 *         SkipFinalSnapshot = true,
 *     });
 *     var primaryClusterInstance = new Aws.Rds.ClusterInstance("primary", new()
 *     {
 *         ApplyImmediately = true,
 *         ClusterIdentifier = primary.Id,
 *         Engine = primary.Engine,
 *         EngineVersion = primary.EngineVersion,
 *         Identifier = "donetsklviv",
 *         InstanceClass = Aws.Rds.InstanceType.R4_Large,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := rds.NewGlobalCluster(ctx, "example", &rds.GlobalClusterArgs{
 * 			GlobalClusterIdentifier: pulumi.String("kyivkharkiv"),
 * 			Engine:                  pulumi.String("aurora-mysql"),
 * 			EngineVersion:           pulumi.String("5.7.mysql_aurora.2.07.5"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		primary, err := rds.NewCluster(ctx, "primary", &rds.ClusterArgs{
 * 			AllowMajorVersionUpgrade: pulumi.Bool(true),
 * 			ApplyImmediately:         pulumi.Bool(true),
 * 			ClusterIdentifier:        pulumi.String("odessadnipro"),
 * 			DatabaseName:             pulumi.String("totoro"),
 * 			Engine:                   example.Engine,
 * 			EngineVersion:            example.EngineVersion,
 * 			GlobalClusterIdentifier:  example.ID(),
 * 			MasterPassword:           pulumi.String("satsukimae"),
 * 			MasterUsername:           pulumi.String("maesatsuki"),
 * 			SkipFinalSnapshot:        pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewClusterInstance(ctx, "primary", &rds.ClusterInstanceArgs{
 * 			ApplyImmediately:  pulumi.Bool(true),
 * 			ClusterIdentifier: primary.ID(),
 * 			Engine:            primary.Engine,
 * 			EngineVersion:     primary.EngineVersion,
 * 			Identifier:        pulumi.String("donetsklviv"),
 * 			InstanceClass:     pulumi.String(rds.InstanceType_R4_Large),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.GlobalCluster;
 * import com.pulumi.aws.rds.GlobalClusterArgs;
 * import com.pulumi.aws.rds.Cluster;
 * import com.pulumi.aws.rds.ClusterArgs;
 * import com.pulumi.aws.rds.ClusterInstance;
 * import com.pulumi.aws.rds.ClusterInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GlobalCluster("example", GlobalClusterArgs.builder()
 *             .globalClusterIdentifier("kyivkharkiv")
 *             .engine("aurora-mysql")
 *             .engineVersion("5.7.mysql_aurora.2.07.5")
 *             .build());
 *         var primary = new Cluster("primary", ClusterArgs.builder()
 *             .allowMajorVersionUpgrade(true)
 *             .applyImmediately(true)
 *             .clusterIdentifier("odessadnipro")
 *             .databaseName("totoro")
 *             .engine(example.engine())
 *             .engineVersion(example.engineVersion())
 *             .globalClusterIdentifier(example.id())
 *             .masterPassword("satsukimae")
 *             .masterUsername("maesatsuki")
 *             .skipFinalSnapshot(true)
 *             .build());
 *         var primaryClusterInstance = new ClusterInstance("primaryClusterInstance", ClusterInstanceArgs.builder()
 *             .applyImmediately(true)
 *             .clusterIdentifier(primary.id())
 *             .engine(primary.engine())
 *             .engineVersion(primary.engineVersion())
 *             .identifier("donetsklviv")
 *             .instanceClass("db.r4.large")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:GlobalCluster
 *     properties:
 *       globalClusterIdentifier: kyivkharkiv
 *       engine: aurora-mysql
 *       engineVersion: 5.7.mysql_aurora.2.07.5
 *   primary:
 *     type: aws:rds:Cluster
 *     properties:
 *       allowMajorVersionUpgrade: true
 *       applyImmediately: true
 *       clusterIdentifier: odessadnipro
 *       databaseName: totoro
 *       engine: ${example.engine}
 *       engineVersion: ${example.engineVersion}
 *       globalClusterIdentifier: ${example.id}
 *       masterPassword: satsukimae
 *       masterUsername: maesatsuki
 *       skipFinalSnapshot: true
 *   primaryClusterInstance:
 *     type: aws:rds:ClusterInstance
 *     name: primary
 *     properties:
 *       applyImmediately: true
 *       clusterIdentifier: ${primary.id}
 *       engine: ${primary.engine}
 *       engineVersion: ${primary.engineVersion}
 *       identifier: donetsklviv
 *       instanceClass: db.r4.large
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_rds_global_cluster` using the RDS Global Cluster identifier. For example:
 * ```sh
 * $ pulumi import aws:rds/globalCluster:GlobalCluster example example
 * ```
 * Certain resource arguments, like `force_destroy`, only exist within this provider. If the argument is set in the the provider configuration on an imported resource, This provider will show a difference on the first plan after import to update the state value. This change is safe to apply immediately so the state matches the desired configuration.
 * Certain resource arguments, like `source_db_cluster_identifier`, do not have an API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 */
public class GlobalCluster internal constructor(
    override val javaResource: com.pulumi.aws.rds.GlobalCluster,
) : KotlinCustomResource(javaResource, GlobalClusterMapper) {
    /**
     * RDS Global Cluster Amazon Resource Name (ARN)
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name for an automatically created database on cluster creation.
     */
    public val databaseName: Output<String>?
        get() = javaResource.databaseName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If the Global Cluster should have deletion protection enabled. The database can't be deleted when this value is set to `true`. The default is `false`.
     */
    public val deletionProtection: Output<Boolean>?
        get() = javaResource.deletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the database engine to be used for this DB cluster. The provider will only perform drift detection if a configuration value is provided. Valid values: `aurora`, `aurora-mysql`, `aurora-postgresql`. Defaults to `aurora`. Conflicts with `source_db_cluster_identifier`.
     */
    public val engine: Output<String>
        get() = javaResource.engine().applyValue({ args0 -> args0 })

    /**
     * The life cycle type for this DB instance. This setting applies only to Aurora PostgreSQL-based global databases. Valid values are `open-source-rds-extended-support`, `open-source-rds-extended-support-disabled`. Default value is `open-source-rds-extended-support`. [Using Amazon RDS Extended Support]: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html
     */
    public val engineLifecycleSupport: Output<String>
        get() = javaResource.engineLifecycleSupport().applyValue({ args0 -> args0 })

    /**
     * Engine version of the Aurora global database. The `engine`, `engine_version`, and `instance_class` (on the `aws.rds.ClusterInstance`) must together support global databases. See [Using Amazon Aurora global databases](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-global-database.html) for more information. By upgrading the engine version, the provider will upgrade cluster members. **NOTE:** To avoid an `inconsistent final plan` error while upgrading, use the `lifecycle` `ignore_changes` for `engine_version` meta argument on the associated `aws.rds.Cluster` resource as shown above in Upgrading Engine Versions example.
     */
    public val engineVersion: Output<String>
        get() = javaResource.engineVersion().applyValue({ args0 -> args0 })

    public val engineVersionActual: Output<String>
        get() = javaResource.engineVersionActual().applyValue({ args0 -> args0 })

    /**
     * Enable to remove DB Cluster members from Global Cluster on destroy. Required with `source_db_cluster_identifier`.
     */
    public val forceDestroy: Output<Boolean>?
        get() = javaResource.forceDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Global cluster identifier.
     */
    public val globalClusterIdentifier: Output<String>
        get() = javaResource.globalClusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * Set of objects containing Global Cluster members.
     */
    public val globalClusterMembers: Output<List<GlobalClusterGlobalClusterMember>>
        get() = javaResource.globalClusterMembers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * AWS Region-unique, immutable identifier for the global database cluster. This identifier is found in AWS CloudTrail log entries whenever the AWS KMS key for the DB cluster is accessed
     */
    public val globalClusterResourceId: Output<String>
        get() = javaResource.globalClusterResourceId().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) to use as the primary DB Cluster of the Global Cluster on creation. The provider cannot perform drift detection of this value.
     */
    public val sourceDbClusterIdentifier: Output<String>
        get() = javaResource.sourceDbClusterIdentifier().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the DB cluster is encrypted. The default is `false` unless `source_db_cluster_identifier` is specified and encrypted. The provider will only perform drift detection if a configuration value is provided.
     */
    public val storageEncrypted: Output<Boolean>
        get() = javaResource.storageEncrypted().applyValue({ args0 -> args0 })
}

public object GlobalClusterMapper : ResourceMapper<GlobalCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.GlobalCluster::class == javaResource::class

    override fun map(javaResource: Resource): GlobalCluster = GlobalCluster(
        javaResource as
            com.pulumi.aws.rds.GlobalCluster,
    )
}

/**
 * @see [GlobalCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GlobalCluster].
 */
public suspend fun globalCluster(
    name: String,
    block: suspend GlobalClusterResourceBuilder.() -> Unit,
): GlobalCluster {
    val builder = GlobalClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GlobalCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun globalCluster(name: String): GlobalCluster {
    val builder = GlobalClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
