@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.InstanceAutomatedBackupsReplicationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Manage cross-region replication of automated backups to a different AWS Region. Documentation for cross-region automated backup replication can be found at:
 * * [Replicating automated backups to another AWS Region](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_ReplicateBackups.html)
 * > **Note:** This resource has to be created in the destination region.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.rds.InstanceAutomatedBackupsReplication("default", {
 *     sourceDbInstanceArn: "arn:aws:rds:us-west-2:123456789012:db:mydatabase",
 *     retentionPeriod: 14,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.rds.InstanceAutomatedBackupsReplication("default",
 *     source_db_instance_arn="arn:aws:rds:us-west-2:123456789012:db:mydatabase",
 *     retention_period=14)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Rds.InstanceAutomatedBackupsReplication("default", new()
 *     {
 *         SourceDbInstanceArn = "arn:aws:rds:us-west-2:123456789012:db:mydatabase",
 *         RetentionPeriod = 14,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewInstanceAutomatedBackupsReplication(ctx, "default", &rds.InstanceAutomatedBackupsReplicationArgs{
 * 			SourceDbInstanceArn: pulumi.String("arn:aws:rds:us-west-2:123456789012:db:mydatabase"),
 * 			RetentionPeriod:     pulumi.Int(14),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.InstanceAutomatedBackupsReplication;
 * import com.pulumi.aws.rds.InstanceAutomatedBackupsReplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new InstanceAutomatedBackupsReplication("default", InstanceAutomatedBackupsReplicationArgs.builder()
 *             .sourceDbInstanceArn("arn:aws:rds:us-west-2:123456789012:db:mydatabase")
 *             .retentionPeriod(14)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:rds:InstanceAutomatedBackupsReplication
 *     properties:
 *       sourceDbInstanceArn: arn:aws:rds:us-west-2:123456789012:db:mydatabase
 *       retentionPeriod: 14
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Encrypting the automated backup with KMS
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.rds.InstanceAutomatedBackupsReplication("default", {
 *     sourceDbInstanceArn: "arn:aws:rds:us-west-2:123456789012:db:mydatabase",
 *     kmsKeyId: "arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.rds.InstanceAutomatedBackupsReplication("default",
 *     source_db_instance_arn="arn:aws:rds:us-west-2:123456789012:db:mydatabase",
 *     kms_key_id="arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Rds.InstanceAutomatedBackupsReplication("default", new()
 *     {
 *         SourceDbInstanceArn = "arn:aws:rds:us-west-2:123456789012:db:mydatabase",
 *         KmsKeyId = "arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewInstanceAutomatedBackupsReplication(ctx, "default", &rds.InstanceAutomatedBackupsReplicationArgs{
 * 			SourceDbInstanceArn: pulumi.String("arn:aws:rds:us-west-2:123456789012:db:mydatabase"),
 * 			KmsKeyId:            pulumi.String("arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.InstanceAutomatedBackupsReplication;
 * import com.pulumi.aws.rds.InstanceAutomatedBackupsReplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new InstanceAutomatedBackupsReplication("default", InstanceAutomatedBackupsReplicationArgs.builder()
 *             .sourceDbInstanceArn("arn:aws:rds:us-west-2:123456789012:db:mydatabase")
 *             .kmsKeyId("arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:rds:InstanceAutomatedBackupsReplication
 *     properties:
 *       sourceDbInstanceArn: arn:aws:rds:us-west-2:123456789012:db:mydatabase
 *       kmsKeyId: arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Example including a RDS DB instance
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.rds.Instance("default", {
 *     allocatedStorage: 10,
 *     identifier: "mydb",
 *     engine: "postgres",
 *     engineVersion: "13.4",
 *     instanceClass: aws.rds.InstanceType.T3_Micro,
 *     dbName: "mydb",
 *     username: "masterusername",
 *     password: "mustbeeightcharacters",
 *     backupRetentionPeriod: 7,
 *     storageEncrypted: true,
 *     skipFinalSnapshot: true,
 * });
 * const defaultKey = new aws.kms.Key("default", {description: "Encryption key for automated backups"});
 * const defaultInstanceAutomatedBackupsReplication = new aws.rds.InstanceAutomatedBackupsReplication("default", {
 *     sourceDbInstanceArn: _default.arn,
 *     kmsKeyId: defaultKey.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.rds.Instance("default",
 *     allocated_storage=10,
 *     identifier="mydb",
 *     engine="postgres",
 *     engine_version="13.4",
 *     instance_class=aws.rds.InstanceType.T3_MICRO,
 *     db_name="mydb",
 *     username="masterusername",
 *     password="mustbeeightcharacters",
 *     backup_retention_period=7,
 *     storage_encrypted=True,
 *     skip_final_snapshot=True)
 * default_key = aws.kms.Key("default", description="Encryption key for automated backups")
 * default_instance_automated_backups_replication = aws.rds.InstanceAutomatedBackupsReplication("default",
 *     source_db_instance_arn=default.arn,
 *     kms_key_id=default_key.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Rds.Instance("default", new()
 *     {
 *         AllocatedStorage = 10,
 *         Identifier = "mydb",
 *         Engine = "postgres",
 *         EngineVersion = "13.4",
 *         InstanceClass = Aws.Rds.InstanceType.T3_Micro,
 *         DbName = "mydb",
 *         Username = "masterusername",
 *         Password = "mustbeeightcharacters",
 *         BackupRetentionPeriod = 7,
 *         StorageEncrypted = true,
 *         SkipFinalSnapshot = true,
 *     });
 *     var defaultKey = new Aws.Kms.Key("default", new()
 *     {
 *         Description = "Encryption key for automated backups",
 *     });
 *     var defaultInstanceAutomatedBackupsReplication = new Aws.Rds.InstanceAutomatedBackupsReplication("default", new()
 *     {
 *         SourceDbInstanceArn = @default.Arn,
 *         KmsKeyId = defaultKey.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewInstance(ctx, "default", &rds.InstanceArgs{
 * 			AllocatedStorage:      pulumi.Int(10),
 * 			Identifier:            pulumi.String("mydb"),
 * 			Engine:                pulumi.String("postgres"),
 * 			EngineVersion:         pulumi.String("13.4"),
 * 			InstanceClass:         pulumi.String(rds.InstanceType_T3_Micro),
 * 			DbName:                pulumi.String("mydb"),
 * 			Username:              pulumi.String("masterusername"),
 * 			Password:              pulumi.String("mustbeeightcharacters"),
 * 			BackupRetentionPeriod: pulumi.Int(7),
 * 			StorageEncrypted:      pulumi.Bool(true),
 * 			SkipFinalSnapshot:     pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultKey, err := kms.NewKey(ctx, "default", &kms.KeyArgs{
 * 			Description: pulumi.String("Encryption key for automated backups"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewInstanceAutomatedBackupsReplication(ctx, "default", &rds.InstanceAutomatedBackupsReplicationArgs{
 * 			SourceDbInstanceArn: _default.Arn,
 * 			KmsKeyId:            defaultKey.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.rds.InstanceAutomatedBackupsReplication;
 * import com.pulumi.aws.rds.InstanceAutomatedBackupsReplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Instance("default", InstanceArgs.builder()
 *             .allocatedStorage(10)
 *             .identifier("mydb")
 *             .engine("postgres")
 *             .engineVersion("13.4")
 *             .instanceClass("db.t3.micro")
 *             .dbName("mydb")
 *             .username("masterusername")
 *             .password("mustbeeightcharacters")
 *             .backupRetentionPeriod(7)
 *             .storageEncrypted(true)
 *             .skipFinalSnapshot(true)
 *             .build());
 *         var defaultKey = new Key("defaultKey", KeyArgs.builder()
 *             .description("Encryption key for automated backups")
 *             .build());
 *         var defaultInstanceAutomatedBackupsReplication = new InstanceAutomatedBackupsReplication("defaultInstanceAutomatedBackupsReplication", InstanceAutomatedBackupsReplicationArgs.builder()
 *             .sourceDbInstanceArn(default_.arn())
 *             .kmsKeyId(defaultKey.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:rds:Instance
 *     properties:
 *       allocatedStorage: 10
 *       identifier: mydb
 *       engine: postgres
 *       engineVersion: '13.4'
 *       instanceClass: db.t3.micro
 *       dbName: mydb
 *       username: masterusername
 *       password: mustbeeightcharacters
 *       backupRetentionPeriod: 7
 *       storageEncrypted: true
 *       skipFinalSnapshot: true
 *   defaultKey:
 *     type: aws:kms:Key
 *     name: default
 *     properties:
 *       description: Encryption key for automated backups
 *   defaultInstanceAutomatedBackupsReplication:
 *     type: aws:rds:InstanceAutomatedBackupsReplication
 *     name: default
 *     properties:
 *       sourceDbInstanceArn: ${default.arn}
 *       kmsKeyId: ${defaultKey.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import RDS instance automated backups replication using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:rds/instanceAutomatedBackupsReplication:InstanceAutomatedBackupsReplication default arn:aws:rds:us-east-1:123456789012:auto-backup:ab-faaa2mgdj1vmp4xflr7yhsrmtbtob7ltrzzz2my
 * ```
 * @property kmsKeyId The AWS KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination AWS Region, for example, `arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE`.
 * @property preSignedUrl A URL that contains a [Signature Version 4](https://docs&#46;aws&#46;amazon&#46;com/general/latest/gr/signature-version-4&#46;html) signed request for the [`StartDBInstanceAutomatedBackupsReplication`](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartDBInstanceAutomatedBackupsReplication.html) action to be called in the AWS Region of the source DB instance.
 * @property retentionPeriod The retention period for the replicated automated backups, defaults to `7`.
 * @property sourceDbInstanceArn The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example, `arn:aws:rds:us-west-2:123456789012:db:mydatabase`.
 */
public data class InstanceAutomatedBackupsReplicationArgs(
    public val kmsKeyId: Output<String>? = null,
    public val preSignedUrl: Output<String>? = null,
    public val retentionPeriod: Output<Int>? = null,
    public val sourceDbInstanceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.InstanceAutomatedBackupsReplicationArgs> {
    override fun toJava(): com.pulumi.aws.rds.InstanceAutomatedBackupsReplicationArgs =
        com.pulumi.aws.rds.InstanceAutomatedBackupsReplicationArgs.builder()
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .preSignedUrl(preSignedUrl?.applyValue({ args0 -> args0 }))
            .retentionPeriod(retentionPeriod?.applyValue({ args0 -> args0 }))
            .sourceDbInstanceArn(sourceDbInstanceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceAutomatedBackupsReplicationArgs].
 */
@PulumiTagMarker
public class InstanceAutomatedBackupsReplicationArgsBuilder internal constructor() {
    private var kmsKeyId: Output<String>? = null

    private var preSignedUrl: Output<String>? = null

    private var retentionPeriod: Output<Int>? = null

    private var sourceDbInstanceArn: Output<String>? = null

    /**
     * @param value The AWS KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination AWS Region, for example, `arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE`.
     */
    @JvmName("hipemhfaldkhjrah")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value A URL that contains a [Signature Version 4](https://docs&#46;aws&#46;amazon&#46;com/general/latest/gr/signature-version-4&#46;html) signed request for the [`StartDBInstanceAutomatedBackupsReplication`](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartDBInstanceAutomatedBackupsReplication.html) action to be called in the AWS Region of the source DB instance.
     */
    @JvmName("qyjhnqcdkegyojgk")
    public suspend fun preSignedUrl(`value`: Output<String>) {
        this.preSignedUrl = value
    }

    /**
     * @param value The retention period for the replicated automated backups, defaults to `7`.
     */
    @JvmName("wicmiuscauxmtcye")
    public suspend fun retentionPeriod(`value`: Output<Int>) {
        this.retentionPeriod = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example, `arn:aws:rds:us-west-2:123456789012:db:mydatabase`.
     */
    @JvmName("xxpclennpcmffhqu")
    public suspend fun sourceDbInstanceArn(`value`: Output<String>) {
        this.sourceDbInstanceArn = value
    }

    /**
     * @param value The AWS KMS key identifier for encryption of the replicated automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination AWS Region, for example, `arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE`.
     */
    @JvmName("nufxftutclxhyrri")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value A URL that contains a [Signature Version 4](https://docs&#46;aws&#46;amazon&#46;com/general/latest/gr/signature-version-4&#46;html) signed request for the [`StartDBInstanceAutomatedBackupsReplication`](https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_StartDBInstanceAutomatedBackupsReplication.html) action to be called in the AWS Region of the source DB instance.
     */
    @JvmName("hemjfliyaaxekuch")
    public suspend fun preSignedUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preSignedUrl = mapped
    }

    /**
     * @param value The retention period for the replicated automated backups, defaults to `7`.
     */
    @JvmName("micwqpscfxuunihy")
    public suspend fun retentionPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionPeriod = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example, `arn:aws:rds:us-west-2:123456789012:db:mydatabase`.
     */
    @JvmName("slfuyunwvruagssx")
    public suspend fun sourceDbInstanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDbInstanceArn = mapped
    }

    internal fun build(): InstanceAutomatedBackupsReplicationArgs =
        InstanceAutomatedBackupsReplicationArgs(
            kmsKeyId = kmsKeyId,
            preSignedUrl = preSignedUrl,
            retentionPeriod = retentionPeriod,
            sourceDbInstanceArn = sourceDbInstanceArn,
        )
}
