@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.kotlin.outputs.IntegrationTimeouts
import com.pulumi.aws.rds.kotlin.outputs.IntegrationTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Integration].
 */
@PulumiTagMarker
public class IntegrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: IntegrationArgs = IntegrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend IntegrationArgsBuilder.() -> Unit) {
        val builder = IntegrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Integration {
        val builtJavaResource = com.pulumi.aws.rds.Integration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Integration(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS RDS (Relational Database) zero-ETL integration. You can refer to the [User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/zero-etl.setting-up.html).
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.redshiftserverless.Namespace("example", {namespaceName: "redshift-example"});
 * const exampleWorkgroup = new aws.redshiftserverless.Workgroup("example", {
 *     namespaceName: example.namespaceName,
 *     workgroupName: "example-workspace",
 *     baseCapacity: 8,
 *     publiclyAccessible: false,
 *     subnetIds: [
 *         example1.id,
 *         example2.id,
 *         example3.id,
 *     ],
 *     configParameters: [{
 *         parameterKey: "enable_case_sensitive_identifier",
 *         parameterValue: "true",
 *     }],
 * });
 * const exampleIntegration = new aws.rds.Integration("example", {
 *     integrationName: "example",
 *     sourceArn: exampleAwsRdsCluster.arn,
 *     targetArn: example.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.redshiftserverless.Namespace("example", namespace_name="redshift-example")
 * example_workgroup = aws.redshiftserverless.Workgroup("example",
 *     namespace_name=example.namespace_name,
 *     workgroup_name="example-workspace",
 *     base_capacity=8,
 *     publicly_accessible=False,
 *     subnet_ids=[
 *         example1["id"],
 *         example2["id"],
 *         example3["id"],
 *     ],
 *     config_parameters=[{
 *         "parameter_key": "enable_case_sensitive_identifier",
 *         "parameter_value": "true",
 *     }])
 * example_integration = aws.rds.Integration("example",
 *     integration_name="example",
 *     source_arn=example_aws_rds_cluster["arn"],
 *     target_arn=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.RedshiftServerless.Namespace("example", new()
 *     {
 *         NamespaceName = "redshift-example",
 *     });
 *     var exampleWorkgroup = new Aws.RedshiftServerless.Workgroup("example", new()
 *     {
 *         NamespaceName = example.NamespaceName,
 *         WorkgroupName = "example-workspace",
 *         BaseCapacity = 8,
 *         PubliclyAccessible = false,
 *         SubnetIds = new[]
 *         {
 *             example1.Id,
 *             example2.Id,
 *             example3.Id,
 *         },
 *         ConfigParameters = new[]
 *         {
 *             new Aws.RedshiftServerless.Inputs.WorkgroupConfigParameterArgs
 *             {
 *                 ParameterKey = "enable_case_sensitive_identifier",
 *                 ParameterValue = "true",
 *             },
 *         },
 *     });
 *     var exampleIntegration = new Aws.Rds.Integration("example", new()
 *     {
 *         IntegrationName = "example",
 *         SourceArn = exampleAwsRdsCluster.Arn,
 *         TargetArn = example.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/redshiftserverless"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := redshiftserverless.NewNamespace(ctx, "example", &redshiftserverless.NamespaceArgs{
 * 			NamespaceName: pulumi.String("redshift-example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = redshiftserverless.NewWorkgroup(ctx, "example", &redshiftserverless.WorkgroupArgs{
 * 			NamespaceName:      example.NamespaceName,
 * 			WorkgroupName:      pulumi.String("example-workspace"),
 * 			BaseCapacity:       pulumi.Int(8),
 * 			PubliclyAccessible: pulumi.Bool(false),
 * 			SubnetIds: pulumi.StringArray{
 * 				example1.Id,
 * 				example2.Id,
 * 				example3.Id,
 * 			},
 * 			ConfigParameters: redshiftserverless.WorkgroupConfigParameterArray{
 * 				&redshiftserverless.WorkgroupConfigParameterArgs{
 * 					ParameterKey:   pulumi.String("enable_case_sensitive_identifier"),
 * 					ParameterValue: pulumi.String("true"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewIntegration(ctx, "example", &rds.IntegrationArgs{
 * 			IntegrationName: pulumi.String("example"),
 * 			SourceArn:       pulumi.Any(exampleAwsRdsCluster.Arn),
 * 			TargetArn:       example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.redshiftserverless.Namespace;
 * import com.pulumi.aws.redshiftserverless.NamespaceArgs;
 * import com.pulumi.aws.redshiftserverless.Workgroup;
 * import com.pulumi.aws.redshiftserverless.WorkgroupArgs;
 * import com.pulumi.aws.redshiftserverless.inputs.WorkgroupConfigParameterArgs;
 * import com.pulumi.aws.rds.Integration;
 * import com.pulumi.aws.rds.IntegrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Namespace("example", NamespaceArgs.builder()
 *             .namespaceName("redshift-example")
 *             .build());
 *         var exampleWorkgroup = new Workgroup("exampleWorkgroup", WorkgroupArgs.builder()
 *             .namespaceName(example.namespaceName())
 *             .workgroupName("example-workspace")
 *             .baseCapacity(8)
 *             .publiclyAccessible(false)
 *             .subnetIds(
 *                 example1.id(),
 *                 example2.id(),
 *                 example3.id())
 *             .configParameters(WorkgroupConfigParameterArgs.builder()
 *                 .parameterKey("enable_case_sensitive_identifier")
 *                 .parameterValue("true")
 *                 .build())
 *             .build());
 *         var exampleIntegration = new Integration("exampleIntegration", IntegrationArgs.builder()
 *             .integrationName("example")
 *             .sourceArn(exampleAwsRdsCluster.arn())
 *             .targetArn(example.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:redshiftserverless:Namespace
 *     properties:
 *       namespaceName: redshift-example
 *   exampleWorkgroup:
 *     type: aws:redshiftserverless:Workgroup
 *     name: example
 *     properties:
 *       namespaceName: ${example.namespaceName}
 *       workgroupName: example-workspace
 *       baseCapacity: 8
 *       publiclyAccessible: false
 *       subnetIds:
 *         - ${example1.id}
 *         - ${example2.id}
 *         - ${example3.id}
 *       configParameters:
 *         - parameterKey: enable_case_sensitive_identifier
 *           parameterValue: 'true'
 *   exampleIntegration:
 *     type: aws:rds:Integration
 *     name: example
 *     properties:
 *       integrationName: example
 *       sourceArn: ${exampleAwsRdsCluster.arn}
 *       targetArn: ${example.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Use own KMS key
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const keyPolicy = current.then(current => aws.iam.getPolicyDocument({
 *     statements: [
 *         {
 *             actions: ["kms:*"],
 *             resources: ["*"],
 *             principals: [{
 *                 type: "AWS",
 *                 identifiers: [`arn:aws:iam::${current&#46;accountId}:root`],
 *             }],
 *         },
 *         {
 *             actions: ["kms:CreateGrant"],
 *             resources: ["*"],
 *             principals: [{
 *                 type: "Service",
 *                 identifiers: ["redshift&#46;amazonaws&#46;com"],
 *             }],
 *         },
 *     ],
 * }));
 * const example = new aws.kms.Key("example", {
 *     deletionWindowInDays: 10,
 *     policy: keyPolicy.then(keyPolicy => keyPolicy.json),
 * });
 * const exampleIntegration = new aws.rds.Integration("example", {
 *     integrationName: "example",
 *     sourceArn: exampleAwsRdsCluster.arn,
 *     targetArn: exampleAwsRedshiftserverlessNamespace.arn,
 *     kmsKeyId: example.arn,
 *     additionalEncryptionContext: {
 *         example: "test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * key_policy = aws.iam.get_policy_document(statements=[
 *     {
 *         "actions": ["kms:*"],
 *         "resources": ["*"],
 *         "principals": [{
 *             "type": "AWS",
 *             "identifiers": [f"arn:aws:iam::{current&#46;account_id}:root"],
 *         }],
 *     },
 *     {
 *         "actions": ["kms:CreateGrant"],
 *         "resources": ["*"],
 *         "principals": [{
 *             "type": "Service",
 *             "identifiers": ["redshift&#46;amazonaws&#46;com"],
 *         }],
 *     },
 * ])
 * example = aws.kms.Key("example",
 *     deletion_window_in_days=10,
 *     policy=key_policy.json)
 * example_integration = aws.rds.Integration("example",
 *     integration_name="example",
 *     source_arn=example_aws_rds_cluster["arn"],
 *     target_arn=example_aws_redshiftserverless_namespace["arn"],
 *     kms_key_id=example.arn,
 *     additional_encryption_context={
 *         "example": "test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var keyPolicy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "kms:*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             $"arn:aws:iam::{current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId)}:root",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "kms:CreateGrant",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "redshift.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         DeletionWindowInDays = 10,
 *         Policy = keyPolicy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleIntegration = new Aws.Rds.Integration("example", new()
 *     {
 *         IntegrationName = "example",
 *         SourceArn = exampleAwsRdsCluster.Arn,
 *         TargetArn = exampleAwsRedshiftserverlessNamespace.Arn,
 *         KmsKeyId = example.Arn,
 *         AdditionalEncryptionContext =
 *         {
 *             { "example", "test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		keyPolicy, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Actions: []string{
 * 						"kms:*",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "AWS",
 * 							Identifiers: []string{
 * 								fmt.Sprintf("arn:aws:iam::%v:root", current.AccountId),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				{
 * 					Actions: []string{
 * 						"kms:CreateGrant",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "Service",
 * 							Identifiers: []string{
 * 								"redshift.amazonaws.com",
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			DeletionWindowInDays: pulumi.Int(10),
 * 			Policy:               pulumi.String(keyPolicy.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewIntegration(ctx, "example", &rds.IntegrationArgs{
 * 			IntegrationName: pulumi.String("example"),
 * 			SourceArn:       pulumi.Any(exampleAwsRdsCluster.Arn),
 * 			TargetArn:       pulumi.Any(exampleAwsRedshiftserverlessNamespace.Arn),
 * 			KmsKeyId:        example.Arn,
 * 			AdditionalEncryptionContext: pulumi.StringMap{
 * 				"example": pulumi.String("test"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.rds.Integration;
 * import com.pulumi.aws.rds.IntegrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var keyPolicy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .actions("kms:*")
 *                     .resources("*")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("AWS")
 *                         .identifiers(String.format("arn:aws:iam::%s:root", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                         .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .actions("kms:CreateGrant")
 *                     .resources("*")
 *                     .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                         .type("Service")
 *                         .identifiers("redshift.amazonaws.com")
 *                         .build())
 *                     .build())
 *             .build());
 *         var example = new Key("example", KeyArgs.builder()
 *             .deletionWindowInDays(10)
 *             .policy(keyPolicy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleIntegration = new Integration("exampleIntegration", IntegrationArgs.builder()
 *             .integrationName("example")
 *             .sourceArn(exampleAwsRdsCluster.arn())
 *             .targetArn(exampleAwsRedshiftserverlessNamespace.arn())
 *             .kmsKeyId(example.arn())
 *             .additionalEncryptionContext(Map.of("example", "test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       deletionWindowInDays: 10
 *       policy: ${keyPolicy.json}
 *   exampleIntegration:
 *     type: aws:rds:Integration
 *     name: example
 *     properties:
 *       integrationName: example
 *       sourceArn: ${exampleAwsRdsCluster.arn}
 *       targetArn: ${exampleAwsRedshiftserverlessNamespace.arn}
 *       kmsKeyId: ${example.arn}
 *       additionalEncryptionContext:
 *         example: test
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   keyPolicy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - actions:
 *               - kms:*
 *             resources:
 *               - '*'
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - arn:aws:iam::${current.accountId}:root
 *           - actions:
 *               - kms:CreateGrant
 *             resources:
 *               - '*'
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - redshift.amazonaws.com
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import RDS (Relational Database) Integration using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:rds/integration:Integration example arn:aws:rds:us-west-2:123456789012:integration:abcdefgh-0000-1111-2222-123456789012
 * ```
 */
public class Integration internal constructor(
    override val javaResource: com.pulumi.aws.rds.Integration,
) : KotlinCustomResource(javaResource, IntegrationMapper) {
    /**
     * Set of non-secret key–value pairs that contains additional contextual information about the data. For more information, see the [User Guide](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context). You can only include this parameter if you specify the `kms_key_id` parameter.
     */
    public val additionalEncryptionContext: Output<Map<String, String>>?
        get() = javaResource.additionalEncryptionContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * ARN of the Integration.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the integration.
     */
    public val integrationName: Output<String>
        get() = javaResource.integrationName().applyValue({ args0 -> args0 })

    /**
     * KMS key identifier for the key to use to encrypt the integration. If you don't specify an encryption key, RDS uses a default AWS owned key. If you use the default AWS owned key, you should ignore `kms_key_id` parameter by using `lifecycle` parameter to avoid unintended change after the first creation.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * ARN of the database to use as the source for replication.
     */
    public val sourceArn: Output<String>
        get() = javaResource.sourceArn().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * ARN of the Redshift data warehouse to use as the target for replication.
     * The following arguments are optional:
     */
    public val targetArn: Output<String>
        get() = javaResource.targetArn().applyValue({ args0 -> args0 })

    public val timeouts: Output<IntegrationTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object IntegrationMapper : ResourceMapper<Integration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.Integration::class == javaResource::class

    override fun map(javaResource: Resource): Integration = Integration(
        javaResource as
            com.pulumi.aws.rds.Integration,
    )
}

/**
 * @see [Integration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Integration].
 */
public suspend fun integration(name: String, block: suspend IntegrationResourceBuilder.() -> Unit): Integration {
    val builder = IntegrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Integration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun integration(name: String): Integration {
    val builder = IntegrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
