@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.OptionGroupArgs.builder
import com.pulumi.aws.rds.kotlin.inputs.OptionGroupOptionArgs
import com.pulumi.aws.rds.kotlin.inputs.OptionGroupOptionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an RDS DB option group resource. Documentation of the available options for various RDS engines can be found at:
 * * [MariaDB Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.MariaDB.Options.html)
 * * [Microsoft SQL Server Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.SQLServer.Options.html)
 * * [MySQL Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.MySQL.Options.html)
 * * [Oracle Options](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Appendix.Oracle.Options.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.OptionGroup("example", {
 *     name: "option-group-test",
 *     optionGroupDescription: "Option Group",
 *     engineName: "sqlserver-ee",
 *     majorEngineVersion: "11.00",
 *     options: [
 *         {
 *             optionName: "Timezone",
 *             optionSettings: [{
 *                 name: "TIME_ZONE",
 *                 value: "UTC",
 *             }],
 *         },
 *         {
 *             optionName: "SQLSERVER_BACKUP_RESTORE",
 *             optionSettings: [{
 *                 name: "IAM_ROLE_ARN",
 *                 value: exampleAwsIamRole.arn,
 *             }],
 *         },
 *         {
 *             optionName: "TDE",
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.OptionGroup("example",
 *     name="option-group-test",
 *     option_group_description="Option Group",
 *     engine_name="sqlserver-ee",
 *     major_engine_version="11.00",
 *     options=[
 *         {
 *             "option_name": "Timezone",
 *             "option_settings": [{
 *                 "name": "TIME_ZONE",
 *                 "value": "UTC",
 *             }],
 *         },
 *         {
 *             "option_name": "SQLSERVER_BACKUP_RESTORE",
 *             "option_settings": [{
 *                 "name": "IAM_ROLE_ARN",
 *                 "value": example_aws_iam_role["arn"],
 *             }],
 *         },
 *         {
 *             "option_name": "TDE",
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.OptionGroup("example", new()
 *     {
 *         Name = "option-group-test",
 *         OptionGroupDescription = "Option Group",
 *         EngineName = "sqlserver-ee",
 *         MajorEngineVersion = "11.00",
 *         Options = new[]
 *         {
 *             new Aws.Rds.Inputs.OptionGroupOptionArgs
 *             {
 *                 OptionName = "Timezone",
 *                 OptionSettings = new[]
 *                 {
 *                     new Aws.Rds.Inputs.OptionGroupOptionOptionSettingArgs
 *                     {
 *                         Name = "TIME_ZONE",
 *                         Value = "UTC",
 *                     },
 *                 },
 *             },
 *             new Aws.Rds.Inputs.OptionGroupOptionArgs
 *             {
 *                 OptionName = "SQLSERVER_BACKUP_RESTORE",
 *                 OptionSettings = new[]
 *                 {
 *                     new Aws.Rds.Inputs.OptionGroupOptionOptionSettingArgs
 *                     {
 *                         Name = "IAM_ROLE_ARN",
 *                         Value = exampleAwsIamRole.Arn,
 *                     },
 *                 },
 *             },
 *             new Aws.Rds.Inputs.OptionGroupOptionArgs
 *             {
 *                 OptionName = "TDE",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewOptionGroup(ctx, "example", &rds.OptionGroupArgs{
 * 			Name:                   pulumi.String("option-group-test"),
 * 			OptionGroupDescription: pulumi.String("Option Group"),
 * 			EngineName:             pulumi.String("sqlserver-ee"),
 * 			MajorEngineVersion:     pulumi.String("11.00"),
 * 			Options: rds.OptionGroupOptionArray{
 * 				&rds.OptionGroupOptionArgs{
 * 					OptionName: pulumi.String("Timezone"),
 * 					OptionSettings: rds.OptionGroupOptionOptionSettingArray{
 * 						&rds.OptionGroupOptionOptionSettingArgs{
 * 							Name:  pulumi.String("TIME_ZONE"),
 * 							Value: pulumi.String("UTC"),
 * 						},
 * 					},
 * 				},
 * 				&rds.OptionGroupOptionArgs{
 * 					OptionName: pulumi.String("SQLSERVER_BACKUP_RESTORE"),
 * 					OptionSettings: rds.OptionGroupOptionOptionSettingArray{
 * 						&rds.OptionGroupOptionOptionSettingArgs{
 * 							Name:  pulumi.String("IAM_ROLE_ARN"),
 * 							Value: pulumi.Any(exampleAwsIamRole.Arn),
 * 						},
 * 					},
 * 				},
 * 				&rds.OptionGroupOptionArgs{
 * 					OptionName: pulumi.String("TDE"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.OptionGroup;
 * import com.pulumi.aws.rds.OptionGroupArgs;
 * import com.pulumi.aws.rds.inputs.OptionGroupOptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OptionGroup("example", OptionGroupArgs.builder()
 *             .name("option-group-test")
 *             .optionGroupDescription("Option Group")
 *             .engineName("sqlserver-ee")
 *             .majorEngineVersion("11.00")
 *             .options(
 *                 OptionGroupOptionArgs.builder()
 *                     .optionName("Timezone")
 *                     .optionSettings(OptionGroupOptionOptionSettingArgs.builder()
 *                         .name("TIME_ZONE")
 *                         .value("UTC")
 *                         .build())
 *                     .build(),
 *                 OptionGroupOptionArgs.builder()
 *                     .optionName("SQLSERVER_BACKUP_RESTORE")
 *                     .optionSettings(OptionGroupOptionOptionSettingArgs.builder()
 *                         .name("IAM_ROLE_ARN")
 *                         .value(exampleAwsIamRole.arn())
 *                         .build())
 *                     .build(),
 *                 OptionGroupOptionArgs.builder()
 *                     .optionName("TDE")
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:OptionGroup
 *     properties:
 *       name: option-group-test
 *       optionGroupDescription: Option Group
 *       engineName: sqlserver-ee
 *       majorEngineVersion: '11.00'
 *       options:
 *         - optionName: Timezone
 *           optionSettings:
 *             - name: TIME_ZONE
 *               value: UTC
 *         - optionName: SQLSERVER_BACKUP_RESTORE
 *           optionSettings:
 *             - name: IAM_ROLE_ARN
 *               value: ${exampleAwsIamRole.arn}
 *         - optionName: TDE
 * ```
 * <!--End PulumiCodeChooser -->
 * > **Note:** Any modifications to the `aws.rds.OptionGroup` are set to happen immediately as we default to applying immediately.
 * > **WARNING:** You can perform a destroy on a `aws.rds.OptionGroup`, as long as it is not associated with any Amazon RDS resource. An option group can be associated with a DB instance, a manual DB snapshot, or an automated DB snapshot.
 * If you try to delete an option group that is associated with an Amazon RDS resource, an error similar to the following is returned:
 * > An error occurred (InvalidOptionGroupStateFault) when calling the DeleteOptionGroup operation: The option group 'optionGroupName' cannot be deleted because it is in use.
 * More information about this can be found [here](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithOptionGroups.html#USER_WorkingWithOptionGroups.Delete).
 * ## Import
 * Using `pulumi import`, import DB option groups using the `name`. For example:
 * ```sh
 * $ pulumi import aws:rds/optionGroup:OptionGroup example mysql-option-group
 * ```
 * @property engineName Specifies the name of the engine that this option group should be associated with.
 * @property majorEngineVersion Specifies the major version of the engine that this option group should be associated with.
 * @property name Name of the option group. If omitted, the provider will assign a random, unique name. Must be lowercase, to match as it is stored in AWS.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`. Must be lowercase, to match as it is stored in AWS.
 * @property optionGroupDescription Description of the option group.
 * @property options The options to apply. See `option` Block below for more details.
 * @property skipDestroy Set to true if you do not wish the option group to be deleted at destroy time, and instead just remove the option group from the Pulumi state.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class OptionGroupArgs(
    public val engineName: Output<String>? = null,
    public val majorEngineVersion: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val optionGroupDescription: Output<String>? = null,
    public val options: Output<List<OptionGroupOptionArgs>>? = null,
    public val skipDestroy: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.OptionGroupArgs> {
    override fun toJava(): com.pulumi.aws.rds.OptionGroupArgs =
        com.pulumi.aws.rds.OptionGroupArgs.builder()
            .engineName(engineName?.applyValue({ args0 -> args0 }))
            .majorEngineVersion(majorEngineVersion?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .optionGroupDescription(optionGroupDescription?.applyValue({ args0 -> args0 }))
            .options(
                options?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [OptionGroupArgs].
 */
@PulumiTagMarker
public class OptionGroupArgsBuilder internal constructor() {
    private var engineName: Output<String>? = null

    private var majorEngineVersion: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var optionGroupDescription: Output<String>? = null

    private var options: Output<List<OptionGroupOptionArgs>>? = null

    private var skipDestroy: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Specifies the name of the engine that this option group should be associated with.
     */
    @JvmName("drifnculwkfoepkd")
    public suspend fun engineName(`value`: Output<String>) {
        this.engineName = value
    }

    /**
     * @param value Specifies the major version of the engine that this option group should be associated with.
     */
    @JvmName("qpvgnbcyaifijxsg")
    public suspend fun majorEngineVersion(`value`: Output<String>) {
        this.majorEngineVersion = value
    }

    /**
     * @param value Name of the option group. If omitted, the provider will assign a random, unique name. Must be lowercase, to match as it is stored in AWS.
     */
    @JvmName("skvbuiogfpdfckyv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`. Must be lowercase, to match as it is stored in AWS.
     */
    @JvmName("yiwkehciefvbehjj")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value Description of the option group.
     */
    @JvmName("npuioropljhlaaih")
    public suspend fun optionGroupDescription(`value`: Output<String>) {
        this.optionGroupDescription = value
    }

    /**
     * @param value The options to apply. See `option` Block below for more details.
     */
    @JvmName("stheugomuqmfelwy")
    public suspend fun options(`value`: Output<List<OptionGroupOptionArgs>>) {
        this.options = value
    }

    @JvmName("nbjdnpxogdjifrna")
    public suspend fun options(vararg values: Output<OptionGroupOptionArgs>) {
        this.options = Output.all(values.asList())
    }

    /**
     * @param values The options to apply. See `option` Block below for more details.
     */
    @JvmName("xnrugqrasotcspvy")
    public suspend fun options(values: List<Output<OptionGroupOptionArgs>>) {
        this.options = Output.all(values)
    }

    /**
     * @param value Set to true if you do not wish the option group to be deleted at destroy time, and instead just remove the option group from the Pulumi state.
     */
    @JvmName("aheapjufasweebmk")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("adpaivfoisorstqq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies the name of the engine that this option group should be associated with.
     */
    @JvmName("imltdwohkhjnudwv")
    public suspend fun engineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineName = mapped
    }

    /**
     * @param value Specifies the major version of the engine that this option group should be associated with.
     */
    @JvmName("sxgjfcwtfcluoguf")
    public suspend fun majorEngineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.majorEngineVersion = mapped
    }

    /**
     * @param value Name of the option group. If omitted, the provider will assign a random, unique name. Must be lowercase, to match as it is stored in AWS.
     */
    @JvmName("gpordkbbwntjqfnm")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`. Must be lowercase, to match as it is stored in AWS.
     */
    @JvmName("bxnvmgwbfqexhdad")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value Description of the option group.
     */
    @JvmName("itktrmeiuqctprba")
    public suspend fun optionGroupDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optionGroupDescription = mapped
    }

    /**
     * @param value The options to apply. See `option` Block below for more details.
     */
    @JvmName("tjpaafhltylugved")
    public suspend fun options(`value`: List<OptionGroupOptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param argument The options to apply. See `option` Block below for more details.
     */
    @JvmName("tumdgfgavmbdrrsp")
    public suspend fun options(argument: List<suspend OptionGroupOptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OptionGroupOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param argument The options to apply. See `option` Block below for more details.
     */
    @JvmName("ogoauxykdcmayuem")
    public suspend fun options(vararg argument: suspend OptionGroupOptionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OptionGroupOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param argument The options to apply. See `option` Block below for more details.
     */
    @JvmName("srnffgkyfrlmaxoe")
    public suspend fun options(argument: suspend OptionGroupOptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(OptionGroupOptionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.options = mapped
    }

    /**
     * @param values The options to apply. See `option` Block below for more details.
     */
    @JvmName("ksceodngtrgvdkpk")
    public suspend fun options(vararg values: OptionGroupOptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param value Set to true if you do not wish the option group to be deleted at destroy time, and instead just remove the option group from the Pulumi state.
     */
    @JvmName("jxejoadcngblxuid")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nksogtwvmycciqey")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ydheyxlffubnwupq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): OptionGroupArgs = OptionGroupArgs(
        engineName = engineName,
        majorEngineVersion = majorEngineVersion,
        name = name,
        namePrefix = namePrefix,
        optionGroupDescription = optionGroupDescription,
        options = options,
        skipDestroy = skipDestroy,
        tags = tags,
    )
}
