@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.ProxyArgs.builder
import com.pulumi.aws.rds.kotlin.inputs.ProxyAuthArgs
import com.pulumi.aws.rds.kotlin.inputs.ProxyAuthArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an RDS DB proxy resource. For additional information, see the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.Proxy("example", {
 *     name: "example",
 *     debugLogging: false,
 *     engineFamily: "MYSQL",
 *     idleClientTimeout: 1800,
 *     requireTls: true,
 *     roleArn: exampleAwsIamRole.arn,
 *     vpcSecurityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *     vpcSubnetIds: [exampleAwsSubnet&#46;id],
 *     auths: [{
 *         authScheme: "SECRETS",
 *         description: "example",
 *         iamAuth: "DISABLED",
 *         secretArn: exampleAwsSecretsmanagerSecret.arn,
 *     }],
 *     tags: {
 *         Name: "example",
 *         Key: "value",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.Proxy("example",
 *     name="example",
 *     debug_logging=False,
 *     engine_family="MYSQL",
 *     idle_client_timeout=1800,
 *     require_tls=True,
 *     role_arn=example_aws_iam_role["arn"],
 *     vpc_security_group_ids=[example_aws_security_group["id"]],
 *     vpc_subnet_ids=[example_aws_subnet["id"]],
 *     auths=[{
 *         "auth_scheme": "SECRETS",
 *         "description": "example",
 *         "iam_auth": "DISABLED",
 *         "secret_arn": example_aws_secretsmanager_secret["arn"],
 *     }],
 *     tags={
 *         "Name": "example",
 *         "Key": "value",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.Proxy("example", new()
 *     {
 *         Name = "example",
 *         DebugLogging = false,
 *         EngineFamily = "MYSQL",
 *         IdleClientTimeout = 1800,
 *         RequireTls = true,
 *         RoleArn = exampleAwsIamRole.Arn,
 *         VpcSecurityGroupIds = new[]
 *         {
 *             exampleAwsSecurityGroup.Id,
 *         },
 *         VpcSubnetIds = new[]
 *         {
 *             exampleAwsSubnet.Id,
 *         },
 *         Auths = new[]
 *         {
 *             new Aws.Rds.Inputs.ProxyAuthArgs
 *             {
 *                 AuthScheme = "SECRETS",
 *                 Description = "example",
 *                 IamAuth = "DISABLED",
 *                 SecretArn = exampleAwsSecretsmanagerSecret.Arn,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "example" },
 *             { "Key", "value" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := rds.NewProxy(ctx, "example", &rds.ProxyArgs{
 * 			Name:              pulumi.String("example"),
 * 			DebugLogging:      pulumi.Bool(false),
 * 			EngineFamily:      pulumi.String("MYSQL"),
 * 			IdleClientTimeout: pulumi.Int(1800),
 * 			RequireTls:        pulumi.Bool(true),
 * 			RoleArn:           pulumi.Any(exampleAwsIamRole.Arn),
 * 			VpcSecurityGroupIds: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Id,
 * 			},
 * 			VpcSubnetIds: pulumi.StringArray{
 * 				exampleAwsSubnet.Id,
 * 			},
 * 			Auths: rds.ProxyAuthArray{
 * 				&rds.ProxyAuthArgs{
 * 					AuthScheme:  pulumi.String("SECRETS"),
 * 					Description: pulumi.String("example"),
 * 					IamAuth:     pulumi.String("DISABLED"),
 * 					SecretArn:   pulumi.Any(exampleAwsSecretsmanagerSecret.Arn),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 				"Key":  pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Proxy;
 * import com.pulumi.aws.rds.ProxyArgs;
 * import com.pulumi.aws.rds.inputs.ProxyAuthArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Proxy("example", ProxyArgs.builder()
 *             .name("example")
 *             .debugLogging(false)
 *             .engineFamily("MYSQL")
 *             .idleClientTimeout(1800)
 *             .requireTls(true)
 *             .roleArn(exampleAwsIamRole.arn())
 *             .vpcSecurityGroupIds(exampleAwsSecurityGroup.id())
 *             .vpcSubnetIds(exampleAwsSubnet.id())
 *             .auths(ProxyAuthArgs.builder()
 *                 .authScheme("SECRETS")
 *                 .description("example")
 *                 .iamAuth("DISABLED")
 *                 .secretArn(exampleAwsSecretsmanagerSecret.arn())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "example"),
 *                 Map.entry("Key", "value")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:Proxy
 *     properties:
 *       name: example
 *       debugLogging: false
 *       engineFamily: MYSQL
 *       idleClientTimeout: 1800
 *       requireTls: true
 *       roleArn: ${exampleAwsIamRole.arn}
 *       vpcSecurityGroupIds:
 *         - ${exampleAwsSecurityGroup.id}
 *       vpcSubnetIds:
 *         - ${exampleAwsSubnet.id}
 *       auths:
 *         - authScheme: SECRETS
 *           description: example
 *           iamAuth: DISABLED
 *           secretArn: ${exampleAwsSecretsmanagerSecret.arn}
 *       tags:
 *         Name: example
 *         Key: value
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DB proxies using the `name`. For example:
 * ```sh
 * $ pulumi import aws:rds/proxy:Proxy example example
 * ```
 * @property auths Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
 * @property debugLogging Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.
 * @property engineFamily The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for MariaDB, and RDS for MySQL databases, specify `MYSQL`. For Aurora PostgreSQL and RDS for PostgreSQL databases, specify `POSTGRESQL`. For RDS for Microsoft SQL Server, specify `SQLSERVER`. Valid values are `MYSQL`, `POSTGRESQL`, and `SQLSERVER`.
 * @property idleClientTimeout The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.
 * @property name The identifier for the proxy. This name must be unique for all proxies owned by your AWS account in the specified AWS Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
 * @property requireTls A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy.
 * @property roleArn The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in AWS Secrets Manager.
 * @property tags A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcSecurityGroupIds One or more VPC security group IDs to associate with the new proxy.
 * @property vpcSubnetIds One or more VPC subnet IDs to associate with the new proxy.
 */
public data class ProxyArgs(
    public val auths: Output<List<ProxyAuthArgs>>? = null,
    public val debugLogging: Output<Boolean>? = null,
    public val engineFamily: Output<String>? = null,
    public val idleClientTimeout: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val requireTls: Output<Boolean>? = null,
    public val roleArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
    public val vpcSubnetIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.ProxyArgs> {
    override fun toJava(): com.pulumi.aws.rds.ProxyArgs = com.pulumi.aws.rds.ProxyArgs.builder()
        .auths(auths?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
        .debugLogging(debugLogging?.applyValue({ args0 -> args0 }))
        .engineFamily(engineFamily?.applyValue({ args0 -> args0 }))
        .idleClientTimeout(idleClientTimeout?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 }))
        .requireTls(requireTls?.applyValue({ args0 -> args0 }))
        .roleArn(roleArn?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .vpcSecurityGroupIds(vpcSecurityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .vpcSubnetIds(vpcSubnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ProxyArgs].
 */
@PulumiTagMarker
public class ProxyArgsBuilder internal constructor() {
    private var auths: Output<List<ProxyAuthArgs>>? = null

    private var debugLogging: Output<Boolean>? = null

    private var engineFamily: Output<String>? = null

    private var idleClientTimeout: Output<Int>? = null

    private var name: Output<String>? = null

    private var requireTls: Output<Boolean>? = null

    private var roleArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    private var vpcSubnetIds: Output<List<String>>? = null

    /**
     * @param value Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
     */
    @JvmName("etxksqfawauxximq")
    public suspend fun auths(`value`: Output<List<ProxyAuthArgs>>) {
        this.auths = value
    }

    @JvmName("puitobxoahbjxcwy")
    public suspend fun auths(vararg values: Output<ProxyAuthArgs>) {
        this.auths = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
     */
    @JvmName("wlgsbteplxwjujhg")
    public suspend fun auths(values: List<Output<ProxyAuthArgs>>) {
        this.auths = Output.all(values)
    }

    /**
     * @param value Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.
     */
    @JvmName("xpfiqyjdgjehshvm")
    public suspend fun debugLogging(`value`: Output<Boolean>) {
        this.debugLogging = value
    }

    /**
     * @param value The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for MariaDB, and RDS for MySQL databases, specify `MYSQL`. For Aurora PostgreSQL and RDS for PostgreSQL databases, specify `POSTGRESQL`. For RDS for Microsoft SQL Server, specify `SQLSERVER`. Valid values are `MYSQL`, `POSTGRESQL`, and `SQLSERVER`.
     */
    @JvmName("yoqrgabtwlejdcml")
    public suspend fun engineFamily(`value`: Output<String>) {
        this.engineFamily = value
    }

    /**
     * @param value The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.
     */
    @JvmName("ntqovkrybgsynhnh")
    public suspend fun idleClientTimeout(`value`: Output<Int>) {
        this.idleClientTimeout = value
    }

    /**
     * @param value The identifier for the proxy. This name must be unique for all proxies owned by your AWS account in the specified AWS Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     */
    @JvmName("ocwwofukjlxdchld")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy.
     */
    @JvmName("pedpphmnipylstli")
    public suspend fun requireTls(`value`: Output<Boolean>) {
        this.requireTls = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in AWS Secrets Manager.
     */
    @JvmName("jdmhtacpmirqvarv")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fhbjhugrywalpesk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value One or more VPC security group IDs to associate with the new proxy.
     */
    @JvmName("qcdjddxgqqcibctf")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("xhtsrwyomgynqemi")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values One or more VPC security group IDs to associate with the new proxy.
     */
    @JvmName("ocdxhsqqeljrhcwf")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value One or more VPC subnet IDs to associate with the new proxy.
     */
    @JvmName("ddgaensansthfsnj")
    public suspend fun vpcSubnetIds(`value`: Output<List<String>>) {
        this.vpcSubnetIds = value
    }

    @JvmName("dtwmhexwdrfjplga")
    public suspend fun vpcSubnetIds(vararg values: Output<String>) {
        this.vpcSubnetIds = Output.all(values.asList())
    }

    /**
     * @param values One or more VPC subnet IDs to associate with the new proxy.
     */
    @JvmName("gfosnkqjgnviuprj")
    public suspend fun vpcSubnetIds(values: List<Output<String>>) {
        this.vpcSubnetIds = Output.all(values)
    }

    /**
     * @param value Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
     */
    @JvmName("ynkgftjwpmvuaees")
    public suspend fun auths(`value`: List<ProxyAuthArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auths = mapped
    }

    /**
     * @param argument Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
     */
    @JvmName("robvrptnfgydilsp")
    public suspend fun auths(argument: List<suspend ProxyAuthArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ProxyAuthArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.auths = mapped
    }

    /**
     * @param argument Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
     */
    @JvmName("bjswrxincblbetjq")
    public suspend fun auths(vararg argument: suspend ProxyAuthArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ProxyAuthArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.auths = mapped
    }

    /**
     * @param argument Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
     */
    @JvmName("sxklxyhifhofiwxa")
    public suspend fun auths(argument: suspend ProxyAuthArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ProxyAuthArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.auths = mapped
    }

    /**
     * @param values Configuration block(s) with authorization mechanisms to connect to the associated instances or clusters. Described below.
     */
    @JvmName("fynivnhdqhvogcuk")
    public suspend fun auths(vararg values: ProxyAuthArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.auths = mapped
    }

    /**
     * @param value Whether the proxy includes detailed information about SQL statements in its logs. This information helps you to debug issues involving SQL behavior or the performance and scalability of the proxy connections. The debug information includes the text of SQL statements that you submit through the proxy. Thus, only enable this setting when needed for debugging, and only when you have security measures in place to safeguard any sensitive information that appears in the logs.
     */
    @JvmName("ywjksxlounxrjulb")
    public suspend fun debugLogging(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.debugLogging = mapped
    }

    /**
     * @param value The kinds of databases that the proxy can connect to. This value determines which database network protocol the proxy recognizes when it interprets network traffic to and from the database. For Aurora MySQL, RDS for MariaDB, and RDS for MySQL databases, specify `MYSQL`. For Aurora PostgreSQL and RDS for PostgreSQL databases, specify `POSTGRESQL`. For RDS for Microsoft SQL Server, specify `SQLSERVER`. Valid values are `MYSQL`, `POSTGRESQL`, and `SQLSERVER`.
     */
    @JvmName("yomngrsxlmrpbxqk")
    public suspend fun engineFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.engineFamily = mapped
    }

    /**
     * @param value The number of seconds that a connection to the proxy can be inactive before the proxy disconnects it. You can set this value higher or lower than the connection timeout limit for the associated database.
     */
    @JvmName("mubpjvbitvmevhot")
    public suspend fun idleClientTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.idleClientTimeout = mapped
    }

    /**
     * @param value The identifier for the proxy. This name must be unique for all proxies owned by your AWS account in the specified AWS Region. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     */
    @JvmName("bpjwlilhnvyejkqo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A Boolean parameter that specifies whether Transport Layer Security (TLS) encryption is required for connections to the proxy. By enabling this setting, you can enforce encrypted TLS connections to the proxy.
     */
    @JvmName("xkpvsfsrlixrmabg")
    public suspend fun requireTls(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireTls = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access secrets in AWS Secrets Manager.
     */
    @JvmName("tucswowwgvjmliar")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("blhoavbcwfauvcec")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vijdgrychixirqop")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value One or more VPC security group IDs to associate with the new proxy.
     */
    @JvmName("shgvlnhybtxqwofr")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values One or more VPC security group IDs to associate with the new proxy.
     */
    @JvmName("txvdrosbobebfcxd")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param value One or more VPC subnet IDs to associate with the new proxy.
     */
    @JvmName("fiuwdrlncklyhpcc")
    public suspend fun vpcSubnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSubnetIds = mapped
    }

    /**
     * @param values One or more VPC subnet IDs to associate with the new proxy.
     */
    @JvmName("osnatdotlabnvaaw")
    public suspend fun vpcSubnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSubnetIds = mapped
    }

    internal fun build(): ProxyArgs = ProxyArgs(
        auths = auths,
        debugLogging = debugLogging,
        engineFamily = engineFamily,
        idleClientTimeout = idleClientTimeout,
        name = name,
        requireTls = requireTls,
        roleArn = roleArn,
        tags = tags,
        vpcSecurityGroupIds = vpcSecurityGroupIds,
        vpcSubnetIds = vpcSubnetIds,
    )
}
