@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.kotlin.outputs.ProxyDefaultTargetGroupConnectionPoolConfig
import com.pulumi.aws.rds.kotlin.outputs.ProxyDefaultTargetGroupConnectionPoolConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ProxyDefaultTargetGroup].
 */
@PulumiTagMarker
public class ProxyDefaultTargetGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProxyDefaultTargetGroupArgs = ProxyDefaultTargetGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProxyDefaultTargetGroupArgsBuilder.() -> Unit) {
        val builder = ProxyDefaultTargetGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProxyDefaultTargetGroup {
        val builtJavaResource = com.pulumi.aws.rds.ProxyDefaultTargetGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProxyDefaultTargetGroup(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an RDS DB proxy default target group resource.
 * The `aws.rds.ProxyDefaultTargetGroup` behaves differently from normal resources, in that the provider does not _create_ or _destroy_ this resource, since it implicitly exists as part of an RDS DB Proxy. On the provider resource creation it is automatically imported and on resource destruction, the provider performs no actions in RDS.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.Proxy("example", {
 *     name: "example",
 *     debugLogging: false,
 *     engineFamily: "MYSQL",
 *     idleClientTimeout: 1800,
 *     requireTls: true,
 *     roleArn: exampleAwsIamRole.arn,
 *     vpcSecurityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *     vpcSubnetIds: [exampleAwsSubnet&#46;id],
 *     auths: [{
 *         authScheme: "SECRETS",
 *         description: "example",
 *         iamAuth: "DISABLED",
 *         secretArn: exampleAwsSecretsmanagerSecret.arn,
 *     }],
 *     tags: {
 *         Name: "example",
 *         Key: "value",
 *     },
 * });
 * const exampleProxyDefaultTargetGroup = new aws.rds.ProxyDefaultTargetGroup("example", {
 *     dbProxyName: example.name,
 *     connectionPoolConfig: {
 *         connectionBorrowTimeout: 120,
 *         initQuery: "SET x=1, y=2",
 *         maxConnectionsPercent: 100,
 *         maxIdleConnectionsPercent: 50,
 *         sessionPinningFilters: ["EXCLUDE_VARIABLE_SETS"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.Proxy("example",
 *     name="example",
 *     debug_logging=False,
 *     engine_family="MYSQL",
 *     idle_client_timeout=1800,
 *     require_tls=True,
 *     role_arn=example_aws_iam_role["arn"],
 *     vpc_security_group_ids=[example_aws_security_group["id"]],
 *     vpc_subnet_ids=[example_aws_subnet["id"]],
 *     auths=[{
 *         "auth_scheme": "SECRETS",
 *         "description": "example",
 *         "iam_auth": "DISABLED",
 *         "secret_arn": example_aws_secretsmanager_secret["arn"],
 *     }],
 *     tags={
 *         "Name": "example",
 *         "Key": "value",
 *     })
 * example_proxy_default_target_group = aws.rds.ProxyDefaultTargetGroup("example",
 *     db_proxy_name=example.name,
 *     connection_pool_config={
 *         "connection_borrow_timeout": 120,
 *         "init_query": "SET x=1, y=2",
 *         "max_connections_percent": 100,
 *         "max_idle_connections_percent": 50,
 *         "session_pinning_filters": ["EXCLUDE_VARIABLE_SETS"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.Proxy("example", new()
 *     {
 *         Name = "example",
 *         DebugLogging = false,
 *         EngineFamily = "MYSQL",
 *         IdleClientTimeout = 1800,
 *         RequireTls = true,
 *         RoleArn = exampleAwsIamRole.Arn,
 *         VpcSecurityGroupIds = new[]
 *         {
 *             exampleAwsSecurityGroup.Id,
 *         },
 *         VpcSubnetIds = new[]
 *         {
 *             exampleAwsSubnet.Id,
 *         },
 *         Auths = new[]
 *         {
 *             new Aws.Rds.Inputs.ProxyAuthArgs
 *             {
 *                 AuthScheme = "SECRETS",
 *                 Description = "example",
 *                 IamAuth = "DISABLED",
 *                 SecretArn = exampleAwsSecretsmanagerSecret.Arn,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "example" },
 *             { "Key", "value" },
 *         },
 *     });
 *     var exampleProxyDefaultTargetGroup = new Aws.Rds.ProxyDefaultTargetGroup("example", new()
 *     {
 *         DbProxyName = example.Name,
 *         ConnectionPoolConfig = new Aws.Rds.Inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgs
 *         {
 *             ConnectionBorrowTimeout = 120,
 *             InitQuery = "SET x=1, y=2",
 *             MaxConnectionsPercent = 100,
 *             MaxIdleConnectionsPercent = 50,
 *             SessionPinningFilters = new[]
 *             {
 *                 "EXCLUDE_VARIABLE_SETS",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := rds.NewProxy(ctx, "example", &rds.ProxyArgs{
 * 			Name:              pulumi.String("example"),
 * 			DebugLogging:      pulumi.Bool(false),
 * 			EngineFamily:      pulumi.String("MYSQL"),
 * 			IdleClientTimeout: pulumi.Int(1800),
 * 			RequireTls:        pulumi.Bool(true),
 * 			RoleArn:           pulumi.Any(exampleAwsIamRole.Arn),
 * 			VpcSecurityGroupIds: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Id,
 * 			},
 * 			VpcSubnetIds: pulumi.StringArray{
 * 				exampleAwsSubnet.Id,
 * 			},
 * 			Auths: rds.ProxyAuthArray{
 * 				&rds.ProxyAuthArgs{
 * 					AuthScheme:  pulumi.String("SECRETS"),
 * 					Description: pulumi.String("example"),
 * 					IamAuth:     pulumi.String("DISABLED"),
 * 					SecretArn:   pulumi.Any(exampleAwsSecretsmanagerSecret.Arn),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 				"Key":  pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewProxyDefaultTargetGroup(ctx, "example", &rds.ProxyDefaultTargetGroupArgs{
 * 			DbProxyName: example.Name,
 * 			ConnectionPoolConfig: &rds.ProxyDefaultTargetGroupConnectionPoolConfigArgs{
 * 				ConnectionBorrowTimeout:   pulumi.Int(120),
 * 				InitQuery:                 pulumi.String("SET x=1, y=2"),
 * 				MaxConnectionsPercent:     pulumi.Int(100),
 * 				MaxIdleConnectionsPercent: pulumi.Int(50),
 * 				SessionPinningFilters: pulumi.StringArray{
 * 					pulumi.String("EXCLUDE_VARIABLE_SETS"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Proxy;
 * import com.pulumi.aws.rds.ProxyArgs;
 * import com.pulumi.aws.rds.inputs.ProxyAuthArgs;
 * import com.pulumi.aws.rds.ProxyDefaultTargetGroup;
 * import com.pulumi.aws.rds.ProxyDefaultTargetGroupArgs;
 * import com.pulumi.aws.rds.inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Proxy("example", ProxyArgs.builder()
 *             .name("example")
 *             .debugLogging(false)
 *             .engineFamily("MYSQL")
 *             .idleClientTimeout(1800)
 *             .requireTls(true)
 *             .roleArn(exampleAwsIamRole.arn())
 *             .vpcSecurityGroupIds(exampleAwsSecurityGroup.id())
 *             .vpcSubnetIds(exampleAwsSubnet.id())
 *             .auths(ProxyAuthArgs.builder()
 *                 .authScheme("SECRETS")
 *                 .description("example")
 *                 .iamAuth("DISABLED")
 *                 .secretArn(exampleAwsSecretsmanagerSecret.arn())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "example"),
 *                 Map.entry("Key", "value")
 *             ))
 *             .build());
 *         var exampleProxyDefaultTargetGroup = new ProxyDefaultTargetGroup("exampleProxyDefaultTargetGroup", ProxyDefaultTargetGroupArgs.builder()
 *             .dbProxyName(example.name())
 *             .connectionPoolConfig(ProxyDefaultTargetGroupConnectionPoolConfigArgs.builder()
 *                 .connectionBorrowTimeout(120)
 *                 .initQuery("SET x=1, y=2")
 *                 .maxConnectionsPercent(100)
 *                 .maxIdleConnectionsPercent(50)
 *                 .sessionPinningFilters("EXCLUDE_VARIABLE_SETS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:Proxy
 *     properties:
 *       name: example
 *       debugLogging: false
 *       engineFamily: MYSQL
 *       idleClientTimeout: 1800
 *       requireTls: true
 *       roleArn: ${exampleAwsIamRole.arn}
 *       vpcSecurityGroupIds:
 *         - ${exampleAwsSecurityGroup.id}
 *       vpcSubnetIds:
 *         - ${exampleAwsSubnet.id}
 *       auths:
 *         - authScheme: SECRETS
 *           description: example
 *           iamAuth: DISABLED
 *           secretArn: ${exampleAwsSecretsmanagerSecret.arn}
 *       tags:
 *         Name: example
 *         Key: value
 *   exampleProxyDefaultTargetGroup:
 *     type: aws:rds:ProxyDefaultTargetGroup
 *     name: example
 *     properties:
 *       dbProxyName: ${example.name}
 *       connectionPoolConfig:
 *         connectionBorrowTimeout: 120
 *         initQuery: SET x=1, y=2
 *         maxConnectionsPercent: 100
 *         maxIdleConnectionsPercent: 50
 *         sessionPinningFilters:
 *           - EXCLUDE_VARIABLE_SETS
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DB proxy default target groups using the `db_proxy_name`. For example:
 * ```sh
 * $ pulumi import aws:rds/proxyDefaultTargetGroup:ProxyDefaultTargetGroup example example
 * ```
 */
public class ProxyDefaultTargetGroup internal constructor(
    override val javaResource: com.pulumi.aws.rds.ProxyDefaultTargetGroup,
) : KotlinCustomResource(javaResource, ProxyDefaultTargetGroupMapper) {
    /**
     * The Amazon Resource Name (ARN) representing the target group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The settings that determine the size and behavior of the connection pool for the target group.
     */
    public val connectionPoolConfig: Output<ProxyDefaultTargetGroupConnectionPoolConfig>
        get() = javaResource.connectionPoolConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * Name of the RDS DB Proxy.
     */
    public val dbProxyName: Output<String>
        get() = javaResource.dbProxyName().applyValue({ args0 -> args0 })

    /**
     * The name of the default target group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object ProxyDefaultTargetGroupMapper : ResourceMapper<ProxyDefaultTargetGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.ProxyDefaultTargetGroup::class == javaResource::class

    override fun map(javaResource: Resource): ProxyDefaultTargetGroup =
        ProxyDefaultTargetGroup(javaResource as com.pulumi.aws.rds.ProxyDefaultTargetGroup)
}

/**
 * @see [ProxyDefaultTargetGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProxyDefaultTargetGroup].
 */
public suspend fun proxyDefaultTargetGroup(
    name: String,
    block: suspend ProxyDefaultTargetGroupResourceBuilder.() -> Unit,
): ProxyDefaultTargetGroup {
    val builder = ProxyDefaultTargetGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProxyDefaultTargetGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun proxyDefaultTargetGroup(name: String): ProxyDefaultTargetGroup {
    val builder = ProxyDefaultTargetGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
