@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.ProxyDefaultTargetGroupArgs.builder
import com.pulumi.aws.rds.kotlin.inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgs
import com.pulumi.aws.rds.kotlin.inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an RDS DB proxy default target group resource.
 * The `aws.rds.ProxyDefaultTargetGroup` behaves differently from normal resources, in that the provider does not _create_ or _destroy_ this resource, since it implicitly exists as part of an RDS DB Proxy. On the provider resource creation it is automatically imported and on resource destruction, the provider performs no actions in RDS.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.Proxy("example", {
 *     name: "example",
 *     debugLogging: false,
 *     engineFamily: "MYSQL",
 *     idleClientTimeout: 1800,
 *     requireTls: true,
 *     roleArn: exampleAwsIamRole.arn,
 *     vpcSecurityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *     vpcSubnetIds: [exampleAwsSubnet&#46;id],
 *     auths: [{
 *         authScheme: "SECRETS",
 *         description: "example",
 *         iamAuth: "DISABLED",
 *         secretArn: exampleAwsSecretsmanagerSecret.arn,
 *     }],
 *     tags: {
 *         Name: "example",
 *         Key: "value",
 *     },
 * });
 * const exampleProxyDefaultTargetGroup = new aws.rds.ProxyDefaultTargetGroup("example", {
 *     dbProxyName: example.name,
 *     connectionPoolConfig: {
 *         connectionBorrowTimeout: 120,
 *         initQuery: "SET x=1, y=2",
 *         maxConnectionsPercent: 100,
 *         maxIdleConnectionsPercent: 50,
 *         sessionPinningFilters: ["EXCLUDE_VARIABLE_SETS"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.Proxy("example",
 *     name="example",
 *     debug_logging=False,
 *     engine_family="MYSQL",
 *     idle_client_timeout=1800,
 *     require_tls=True,
 *     role_arn=example_aws_iam_role["arn"],
 *     vpc_security_group_ids=[example_aws_security_group["id"]],
 *     vpc_subnet_ids=[example_aws_subnet["id"]],
 *     auths=[{
 *         "auth_scheme": "SECRETS",
 *         "description": "example",
 *         "iam_auth": "DISABLED",
 *         "secret_arn": example_aws_secretsmanager_secret["arn"],
 *     }],
 *     tags={
 *         "Name": "example",
 *         "Key": "value",
 *     })
 * example_proxy_default_target_group = aws.rds.ProxyDefaultTargetGroup("example",
 *     db_proxy_name=example.name,
 *     connection_pool_config={
 *         "connection_borrow_timeout": 120,
 *         "init_query": "SET x=1, y=2",
 *         "max_connections_percent": 100,
 *         "max_idle_connections_percent": 50,
 *         "session_pinning_filters": ["EXCLUDE_VARIABLE_SETS"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.Proxy("example", new()
 *     {
 *         Name = "example",
 *         DebugLogging = false,
 *         EngineFamily = "MYSQL",
 *         IdleClientTimeout = 1800,
 *         RequireTls = true,
 *         RoleArn = exampleAwsIamRole.Arn,
 *         VpcSecurityGroupIds = new[]
 *         {
 *             exampleAwsSecurityGroup.Id,
 *         },
 *         VpcSubnetIds = new[]
 *         {
 *             exampleAwsSubnet.Id,
 *         },
 *         Auths = new[]
 *         {
 *             new Aws.Rds.Inputs.ProxyAuthArgs
 *             {
 *                 AuthScheme = "SECRETS",
 *                 Description = "example",
 *                 IamAuth = "DISABLED",
 *                 SecretArn = exampleAwsSecretsmanagerSecret.Arn,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "example" },
 *             { "Key", "value" },
 *         },
 *     });
 *     var exampleProxyDefaultTargetGroup = new Aws.Rds.ProxyDefaultTargetGroup("example", new()
 *     {
 *         DbProxyName = example.Name,
 *         ConnectionPoolConfig = new Aws.Rds.Inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgs
 *         {
 *             ConnectionBorrowTimeout = 120,
 *             InitQuery = "SET x=1, y=2",
 *             MaxConnectionsPercent = 100,
 *             MaxIdleConnectionsPercent = 50,
 *             SessionPinningFilters = new[]
 *             {
 *                 "EXCLUDE_VARIABLE_SETS",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := rds.NewProxy(ctx, "example", &rds.ProxyArgs{
 * 			Name:              pulumi.String("example"),
 * 			DebugLogging:      pulumi.Bool(false),
 * 			EngineFamily:      pulumi.String("MYSQL"),
 * 			IdleClientTimeout: pulumi.Int(1800),
 * 			RequireTls:        pulumi.Bool(true),
 * 			RoleArn:           pulumi.Any(exampleAwsIamRole.Arn),
 * 			VpcSecurityGroupIds: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Id,
 * 			},
 * 			VpcSubnetIds: pulumi.StringArray{
 * 				exampleAwsSubnet.Id,
 * 			},
 * 			Auths: rds.ProxyAuthArray{
 * 				&rds.ProxyAuthArgs{
 * 					AuthScheme:  pulumi.String("SECRETS"),
 * 					Description: pulumi.String("example"),
 * 					IamAuth:     pulumi.String("DISABLED"),
 * 					SecretArn:   pulumi.Any(exampleAwsSecretsmanagerSecret.Arn),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 				"Key":  pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewProxyDefaultTargetGroup(ctx, "example", &rds.ProxyDefaultTargetGroupArgs{
 * 			DbProxyName: example.Name,
 * 			ConnectionPoolConfig: &rds.ProxyDefaultTargetGroupConnectionPoolConfigArgs{
 * 				ConnectionBorrowTimeout:   pulumi.Int(120),
 * 				InitQuery:                 pulumi.String("SET x=1, y=2"),
 * 				MaxConnectionsPercent:     pulumi.Int(100),
 * 				MaxIdleConnectionsPercent: pulumi.Int(50),
 * 				SessionPinningFilters: pulumi.StringArray{
 * 					pulumi.String("EXCLUDE_VARIABLE_SETS"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Proxy;
 * import com.pulumi.aws.rds.ProxyArgs;
 * import com.pulumi.aws.rds.inputs.ProxyAuthArgs;
 * import com.pulumi.aws.rds.ProxyDefaultTargetGroup;
 * import com.pulumi.aws.rds.ProxyDefaultTargetGroupArgs;
 * import com.pulumi.aws.rds.inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Proxy("example", ProxyArgs.builder()
 *             .name("example")
 *             .debugLogging(false)
 *             .engineFamily("MYSQL")
 *             .idleClientTimeout(1800)
 *             .requireTls(true)
 *             .roleArn(exampleAwsIamRole.arn())
 *             .vpcSecurityGroupIds(exampleAwsSecurityGroup.id())
 *             .vpcSubnetIds(exampleAwsSubnet.id())
 *             .auths(ProxyAuthArgs.builder()
 *                 .authScheme("SECRETS")
 *                 .description("example")
 *                 .iamAuth("DISABLED")
 *                 .secretArn(exampleAwsSecretsmanagerSecret.arn())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "example"),
 *                 Map.entry("Key", "value")
 *             ))
 *             .build());
 *         var exampleProxyDefaultTargetGroup = new ProxyDefaultTargetGroup("exampleProxyDefaultTargetGroup", ProxyDefaultTargetGroupArgs.builder()
 *             .dbProxyName(example.name())
 *             .connectionPoolConfig(ProxyDefaultTargetGroupConnectionPoolConfigArgs.builder()
 *                 .connectionBorrowTimeout(120)
 *                 .initQuery("SET x=1, y=2")
 *                 .maxConnectionsPercent(100)
 *                 .maxIdleConnectionsPercent(50)
 *                 .sessionPinningFilters("EXCLUDE_VARIABLE_SETS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:Proxy
 *     properties:
 *       name: example
 *       debugLogging: false
 *       engineFamily: MYSQL
 *       idleClientTimeout: 1800
 *       requireTls: true
 *       roleArn: ${exampleAwsIamRole.arn}
 *       vpcSecurityGroupIds:
 *         - ${exampleAwsSecurityGroup.id}
 *       vpcSubnetIds:
 *         - ${exampleAwsSubnet.id}
 *       auths:
 *         - authScheme: SECRETS
 *           description: example
 *           iamAuth: DISABLED
 *           secretArn: ${exampleAwsSecretsmanagerSecret.arn}
 *       tags:
 *         Name: example
 *         Key: value
 *   exampleProxyDefaultTargetGroup:
 *     type: aws:rds:ProxyDefaultTargetGroup
 *     name: example
 *     properties:
 *       dbProxyName: ${example.name}
 *       connectionPoolConfig:
 *         connectionBorrowTimeout: 120
 *         initQuery: SET x=1, y=2
 *         maxConnectionsPercent: 100
 *         maxIdleConnectionsPercent: 50
 *         sessionPinningFilters:
 *           - EXCLUDE_VARIABLE_SETS
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DB proxy default target groups using the `db_proxy_name`. For example:
 * ```sh
 * $ pulumi import aws:rds/proxyDefaultTargetGroup:ProxyDefaultTargetGroup example example
 * ```
 * @property connectionPoolConfig The settings that determine the size and behavior of the connection pool for the target group.
 * @property dbProxyName Name of the RDS DB Proxy.
 */
public data class ProxyDefaultTargetGroupArgs(
    public val connectionPoolConfig: Output<ProxyDefaultTargetGroupConnectionPoolConfigArgs>? = null,
    public val dbProxyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.ProxyDefaultTargetGroupArgs> {
    override fun toJava(): com.pulumi.aws.rds.ProxyDefaultTargetGroupArgs =
        com.pulumi.aws.rds.ProxyDefaultTargetGroupArgs.builder()
            .connectionPoolConfig(
                connectionPoolConfig?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dbProxyName(dbProxyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProxyDefaultTargetGroupArgs].
 */
@PulumiTagMarker
public class ProxyDefaultTargetGroupArgsBuilder internal constructor() {
    private var connectionPoolConfig: Output<ProxyDefaultTargetGroupConnectionPoolConfigArgs>? = null

    private var dbProxyName: Output<String>? = null

    /**
     * @param value The settings that determine the size and behavior of the connection pool for the target group.
     */
    @JvmName("jnqebjqhhiulkpmm")
    public suspend fun connectionPoolConfig(`value`: Output<ProxyDefaultTargetGroupConnectionPoolConfigArgs>) {
        this.connectionPoolConfig = value
    }

    /**
     * @param value Name of the RDS DB Proxy.
     */
    @JvmName("xrqsnbxybdgejcmk")
    public suspend fun dbProxyName(`value`: Output<String>) {
        this.dbProxyName = value
    }

    /**
     * @param value The settings that determine the size and behavior of the connection pool for the target group.
     */
    @JvmName("jobyfbbumvetpbfy")
    public suspend fun connectionPoolConfig(`value`: ProxyDefaultTargetGroupConnectionPoolConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionPoolConfig = mapped
    }

    /**
     * @param argument The settings that determine the size and behavior of the connection pool for the target group.
     */
    @JvmName("sjngjfmaxqtapvls")
    public suspend fun connectionPoolConfig(argument: suspend ProxyDefaultTargetGroupConnectionPoolConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ProxyDefaultTargetGroupConnectionPoolConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.connectionPoolConfig = mapped
    }

    /**
     * @param value Name of the RDS DB Proxy.
     */
    @JvmName("sgvmhbyqalpdwcix")
    public suspend fun dbProxyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbProxyName = mapped
    }

    internal fun build(): ProxyDefaultTargetGroupArgs = ProxyDefaultTargetGroupArgs(
        connectionPoolConfig = connectionPoolConfig,
        dbProxyName = dbProxyName,
    )
}
