@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [ProxyEndpoint].
 */
@PulumiTagMarker
public class ProxyEndpointResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProxyEndpointArgs = ProxyEndpointArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProxyEndpointArgsBuilder.() -> Unit) {
        val builder = ProxyEndpointArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ProxyEndpoint {
        val builtJavaResource = com.pulumi.aws.rds.ProxyEndpoint(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ProxyEndpoint(builtJavaResource)
    }
}

/**
 * Provides an RDS DB proxy endpoint resource. For additional information, see the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy-endpoints.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.ProxyEndpoint("example", {
 *     dbProxyName: test.name,
 *     dbProxyEndpointName: "example",
 *     vpcSubnetIds: testAwsSubnet.map(__item => __item.id),
 *     targetRole: "READ_ONLY",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.ProxyEndpoint("example",
 *     db_proxy_name=test["name"],
 *     db_proxy_endpoint_name="example",
 *     vpc_subnet_ids=[__item["id"] for __item in test_aws_subnet],
 *     target_role="READ_ONLY")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.ProxyEndpoint("example", new()
 *     {
 *         DbProxyName = test.Name,
 *         DbProxyEndpointName = "example",
 *         VpcSubnetIds = testAwsSubnet.Select(__item => __item.Id).ToList(),
 *         TargetRole = "READ_ONLY",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range testAwsSubnet {
 * splat0 = append(splat0, val0.Id)
 * }
 * _, err := rds.NewProxyEndpoint(ctx, "example", &rds.ProxyEndpointArgs{
 * DbProxyName: pulumi.Any(test.Name),
 * DbProxyEndpointName: pulumi.String("example"),
 * VpcSubnetIds: toPulumiArray(splat0),
 * TargetRole: pulumi.String("READ_ONLY"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.ProxyEndpoint;
 * import com.pulumi.aws.rds.ProxyEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProxyEndpoint("example", ProxyEndpointArgs.builder()
 *             .dbProxyName(test.name())
 *             .dbProxyEndpointName("example")
 *             .vpcSubnetIds(testAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *             .targetRole("READ_ONLY")
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DB proxy endpoints using the `DB-PROXY-NAME/DB-PROXY-ENDPOINT-NAME`. For example:
 * ```sh
 * $ pulumi import aws:rds/proxyEndpoint:ProxyEndpoint example example/example
 * ```
 */
public class ProxyEndpoint internal constructor(
    override val javaResource: com.pulumi.aws.rds.ProxyEndpoint,
) : KotlinCustomResource(javaResource, ProxyEndpointMapper) {
    /**
     * The Amazon Resource Name (ARN) for the proxy endpoint.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The identifier for the proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     */
    public val dbProxyEndpointName: Output<String>
        get() = javaResource.dbProxyEndpointName().applyValue({ args0 -> args0 })

    /**
     * The name of the DB proxy associated with the DB proxy endpoint that you create.
     */
    public val dbProxyName: Output<String>
        get() = javaResource.dbProxyName().applyValue({ args0 -> args0 })

    /**
     * The endpoint that you can use to connect to the proxy. You include the endpoint value in the connection string for a database client application.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * Indicates whether this endpoint is the default endpoint for the associated DB proxy.
     */
    public val isDefault: Output<Boolean>
        get() = javaResource.isDefault().applyValue({ args0 -> args0 })

    /**
     * A mapping of tags to assign to the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is `READ_WRITE`. Valid values are `READ_WRITE` and `READ_ONLY`.
     */
    public val targetRole: Output<String>?
        get() = javaResource.targetRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The VPC ID of the DB proxy endpoint.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * One or more VPC security group IDs to associate with the new proxy.
     */
    public val vpcSecurityGroupIds: Output<List<String>>
        get() = javaResource.vpcSecurityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * One or more VPC subnet IDs to associate with the new proxy.
     */
    public val vpcSubnetIds: Output<List<String>>
        get() = javaResource.vpcSubnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object ProxyEndpointMapper : ResourceMapper<ProxyEndpoint> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.rds.ProxyEndpoint::class == javaResource::class

    override fun map(javaResource: Resource): ProxyEndpoint = ProxyEndpoint(
        javaResource as
            com.pulumi.aws.rds.ProxyEndpoint,
    )
}

/**
 * @see [ProxyEndpoint].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ProxyEndpoint].
 */
public suspend fun proxyEndpoint(
    name: String,
    block: suspend ProxyEndpointResourceBuilder.() -> Unit,
): ProxyEndpoint {
    val builder = ProxyEndpointResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ProxyEndpoint].
 * @param name The _unique_ name of the resulting resource.
 */
public fun proxyEndpoint(name: String): ProxyEndpoint {
    val builder = ProxyEndpointResourceBuilder()
    builder.name(name)
    return builder.build()
}
