@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.ProxyEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an RDS DB proxy endpoint resource. For additional information, see the [RDS User Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-proxy-endpoints.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.ProxyEndpoint("example", {
 *     dbProxyName: test.name,
 *     dbProxyEndpointName: "example",
 *     vpcSubnetIds: testAwsSubnet.map(__item => __item.id),
 *     targetRole: "READ_ONLY",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.ProxyEndpoint("example",
 *     db_proxy_name=test["name"],
 *     db_proxy_endpoint_name="example",
 *     vpc_subnet_ids=[__item["id"] for __item in test_aws_subnet],
 *     target_role="READ_ONLY")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.ProxyEndpoint("example", new()
 *     {
 *         DbProxyName = test.Name,
 *         DbProxyEndpointName = "example",
 *         VpcSubnetIds = testAwsSubnet.Select(__item => __item.Id).ToList(),
 *         TargetRole = "READ_ONLY",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range testAwsSubnet {
 * splat0 = append(splat0, val0.Id)
 * }
 * _, err := rds.NewProxyEndpoint(ctx, "example", &rds.ProxyEndpointArgs{
 * DbProxyName: pulumi.Any(test.Name),
 * DbProxyEndpointName: pulumi.String("example"),
 * VpcSubnetIds: toPulumiArray(splat0),
 * TargetRole: pulumi.String("READ_ONLY"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.ProxyEndpoint;
 * import com.pulumi.aws.rds.ProxyEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ProxyEndpoint("example", ProxyEndpointArgs.builder()
 *             .dbProxyName(test.name())
 *             .dbProxyEndpointName("example")
 *             .vpcSubnetIds(testAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *             .targetRole("READ_ONLY")
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DB proxy endpoints using the `DB-PROXY-NAME/DB-PROXY-ENDPOINT-NAME`. For example:
 * ```sh
 * $ pulumi import aws:rds/proxyEndpoint:ProxyEndpoint example example/example
 * ```
 * @property dbProxyEndpointName The identifier for the proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
 * @property dbProxyName The name of the DB proxy associated with the DB proxy endpoint that you create.
 * @property tags A mapping of tags to assign to the resource.
 * @property targetRole Indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is `READ_WRITE`. Valid values are `READ_WRITE` and `READ_ONLY`.
 * @property vpcSecurityGroupIds One or more VPC security group IDs to associate with the new proxy.
 * @property vpcSubnetIds One or more VPC subnet IDs to associate with the new proxy.
 */
public data class ProxyEndpointArgs(
    public val dbProxyEndpointName: Output<String>? = null,
    public val dbProxyName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetRole: Output<String>? = null,
    public val vpcSecurityGroupIds: Output<List<String>>? = null,
    public val vpcSubnetIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.ProxyEndpointArgs> {
    override fun toJava(): com.pulumi.aws.rds.ProxyEndpointArgs =
        com.pulumi.aws.rds.ProxyEndpointArgs.builder()
            .dbProxyEndpointName(dbProxyEndpointName?.applyValue({ args0 -> args0 }))
            .dbProxyName(dbProxyName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetRole(targetRole?.applyValue({ args0 -> args0 }))
            .vpcSecurityGroupIds(vpcSecurityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcSubnetIds(vpcSubnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ProxyEndpointArgs].
 */
@PulumiTagMarker
public class ProxyEndpointArgsBuilder internal constructor() {
    private var dbProxyEndpointName: Output<String>? = null

    private var dbProxyName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetRole: Output<String>? = null

    private var vpcSecurityGroupIds: Output<List<String>>? = null

    private var vpcSubnetIds: Output<List<String>>? = null

    /**
     * @param value The identifier for the proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     */
    @JvmName("ogswmemeogvbghgd")
    public suspend fun dbProxyEndpointName(`value`: Output<String>) {
        this.dbProxyEndpointName = value
    }

    /**
     * @param value The name of the DB proxy associated with the DB proxy endpoint that you create.
     */
    @JvmName("mpfmotbwquauxrdk")
    public suspend fun dbProxyName(`value`: Output<String>) {
        this.dbProxyName = value
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("bnwxdrjgiwvgptjr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is `READ_WRITE`. Valid values are `READ_WRITE` and `READ_ONLY`.
     */
    @JvmName("jqepjnrwqdlqkwqk")
    public suspend fun targetRole(`value`: Output<String>) {
        this.targetRole = value
    }

    /**
     * @param value One or more VPC security group IDs to associate with the new proxy.
     */
    @JvmName("cfrfmjklgrrupwfl")
    public suspend fun vpcSecurityGroupIds(`value`: Output<List<String>>) {
        this.vpcSecurityGroupIds = value
    }

    @JvmName("ncjrtgancoxshhas")
    public suspend fun vpcSecurityGroupIds(vararg values: Output<String>) {
        this.vpcSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values One or more VPC security group IDs to associate with the new proxy.
     */
    @JvmName("kfftqvuqwwhqliot")
    public suspend fun vpcSecurityGroupIds(values: List<Output<String>>) {
        this.vpcSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value One or more VPC subnet IDs to associate with the new proxy.
     */
    @JvmName("ulouoxwampasoryb")
    public suspend fun vpcSubnetIds(`value`: Output<List<String>>) {
        this.vpcSubnetIds = value
    }

    @JvmName("aanjtpohyxpkqcnd")
    public suspend fun vpcSubnetIds(vararg values: Output<String>) {
        this.vpcSubnetIds = Output.all(values.asList())
    }

    /**
     * @param values One or more VPC subnet IDs to associate with the new proxy.
     */
    @JvmName("ygxpbhyyobupxssm")
    public suspend fun vpcSubnetIds(values: List<Output<String>>) {
        this.vpcSubnetIds = Output.all(values)
    }

    /**
     * @param value The identifier for the proxy endpoint. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen or contain two consecutive hyphens.
     */
    @JvmName("twrwaarapbavwbob")
    public suspend fun dbProxyEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbProxyEndpointName = mapped
    }

    /**
     * @param value The name of the DB proxy associated with the DB proxy endpoint that you create.
     */
    @JvmName("uufhynylyywjxcyw")
    public suspend fun dbProxyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbProxyName = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("kbaspyaexehsjqkh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("ujmdjhswrslvdbjf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Indicates whether the DB proxy endpoint can be used for read/write or read-only operations. The default is `READ_WRITE`. Valid values are `READ_WRITE` and `READ_ONLY`.
     */
    @JvmName("lucqvpoglsidqnmd")
    public suspend fun targetRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetRole = mapped
    }

    /**
     * @param value One or more VPC security group IDs to associate with the new proxy.
     */
    @JvmName("kjstbirbrprnugjh")
    public suspend fun vpcSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param values One or more VPC security group IDs to associate with the new proxy.
     */
    @JvmName("cevpqucqdyvyejgs")
    public suspend fun vpcSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSecurityGroupIds = mapped
    }

    /**
     * @param value One or more VPC subnet IDs to associate with the new proxy.
     */
    @JvmName("pijuqluwxaerptbk")
    public suspend fun vpcSubnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcSubnetIds = mapped
    }

    /**
     * @param values One or more VPC subnet IDs to associate with the new proxy.
     */
    @JvmName("qqskxpfugssjnlwc")
    public suspend fun vpcSubnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vpcSubnetIds = mapped
    }

    internal fun build(): ProxyEndpointArgs = ProxyEndpointArgs(
        dbProxyEndpointName = dbProxyEndpointName,
        dbProxyName = dbProxyName,
        tags = tags,
        targetRole = targetRole,
        vpcSecurityGroupIds = vpcSecurityGroupIds,
        vpcSubnetIds = vpcSubnetIds,
    )
}
