@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.ProxyTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an RDS DB proxy target resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.Proxy("example", {
 *     name: "example",
 *     debugLogging: false,
 *     engineFamily: "MYSQL",
 *     idleClientTimeout: 1800,
 *     requireTls: true,
 *     roleArn: exampleAwsIamRole.arn,
 *     vpcSecurityGroupIds: [exampleAwsSecurityGroup&#46;id],
 *     vpcSubnetIds: [exampleAwsSubnet&#46;id],
 *     auths: [{
 *         authScheme: "SECRETS",
 *         description: "example",
 *         iamAuth: "DISABLED",
 *         secretArn: exampleAwsSecretsmanagerSecret.arn,
 *     }],
 *     tags: {
 *         Name: "example",
 *         Key: "value",
 *     },
 * });
 * const exampleProxyDefaultTargetGroup = new aws.rds.ProxyDefaultTargetGroup("example", {
 *     dbProxyName: example.name,
 *     connectionPoolConfig: {
 *         connectionBorrowTimeout: 120,
 *         initQuery: "SET x=1, y=2",
 *         maxConnectionsPercent: 100,
 *         maxIdleConnectionsPercent: 50,
 *         sessionPinningFilters: ["EXCLUDE_VARIABLE_SETS"],
 *     },
 * });
 * const exampleProxyTarget = new aws.rds.ProxyTarget("example", {
 *     dbInstanceIdentifier: exampleAwsDbInstance.identifier,
 *     dbProxyName: example.name,
 *     targetGroupName: exampleProxyDefaultTargetGroup.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.Proxy("example",
 *     name="example",
 *     debug_logging=False,
 *     engine_family="MYSQL",
 *     idle_client_timeout=1800,
 *     require_tls=True,
 *     role_arn=example_aws_iam_role["arn"],
 *     vpc_security_group_ids=[example_aws_security_group["id"]],
 *     vpc_subnet_ids=[example_aws_subnet["id"]],
 *     auths=[{
 *         "auth_scheme": "SECRETS",
 *         "description": "example",
 *         "iam_auth": "DISABLED",
 *         "secret_arn": example_aws_secretsmanager_secret["arn"],
 *     }],
 *     tags={
 *         "Name": "example",
 *         "Key": "value",
 *     })
 * example_proxy_default_target_group = aws.rds.ProxyDefaultTargetGroup("example",
 *     db_proxy_name=example.name,
 *     connection_pool_config={
 *         "connection_borrow_timeout": 120,
 *         "init_query": "SET x=1, y=2",
 *         "max_connections_percent": 100,
 *         "max_idle_connections_percent": 50,
 *         "session_pinning_filters": ["EXCLUDE_VARIABLE_SETS"],
 *     })
 * example_proxy_target = aws.rds.ProxyTarget("example",
 *     db_instance_identifier=example_aws_db_instance["identifier"],
 *     db_proxy_name=example.name,
 *     target_group_name=example_proxy_default_target_group.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.Proxy("example", new()
 *     {
 *         Name = "example",
 *         DebugLogging = false,
 *         EngineFamily = "MYSQL",
 *         IdleClientTimeout = 1800,
 *         RequireTls = true,
 *         RoleArn = exampleAwsIamRole.Arn,
 *         VpcSecurityGroupIds = new[]
 *         {
 *             exampleAwsSecurityGroup.Id,
 *         },
 *         VpcSubnetIds = new[]
 *         {
 *             exampleAwsSubnet.Id,
 *         },
 *         Auths = new[]
 *         {
 *             new Aws.Rds.Inputs.ProxyAuthArgs
 *             {
 *                 AuthScheme = "SECRETS",
 *                 Description = "example",
 *                 IamAuth = "DISABLED",
 *                 SecretArn = exampleAwsSecretsmanagerSecret.Arn,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "example" },
 *             { "Key", "value" },
 *         },
 *     });
 *     var exampleProxyDefaultTargetGroup = new Aws.Rds.ProxyDefaultTargetGroup("example", new()
 *     {
 *         DbProxyName = example.Name,
 *         ConnectionPoolConfig = new Aws.Rds.Inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgs
 *         {
 *             ConnectionBorrowTimeout = 120,
 *             InitQuery = "SET x=1, y=2",
 *             MaxConnectionsPercent = 100,
 *             MaxIdleConnectionsPercent = 50,
 *             SessionPinningFilters = new[]
 *             {
 *                 "EXCLUDE_VARIABLE_SETS",
 *             },
 *         },
 *     });
 *     var exampleProxyTarget = new Aws.Rds.ProxyTarget("example", new()
 *     {
 *         DbInstanceIdentifier = exampleAwsDbInstance.Identifier,
 *         DbProxyName = example.Name,
 *         TargetGroupName = exampleProxyDefaultTargetGroup.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := rds.NewProxy(ctx, "example", &rds.ProxyArgs{
 * 			Name:              pulumi.String("example"),
 * 			DebugLogging:      pulumi.Bool(false),
 * 			EngineFamily:      pulumi.String("MYSQL"),
 * 			IdleClientTimeout: pulumi.Int(1800),
 * 			RequireTls:        pulumi.Bool(true),
 * 			RoleArn:           pulumi.Any(exampleAwsIamRole.Arn),
 * 			VpcSecurityGroupIds: pulumi.StringArray{
 * 				exampleAwsSecurityGroup.Id,
 * 			},
 * 			VpcSubnetIds: pulumi.StringArray{
 * 				exampleAwsSubnet.Id,
 * 			},
 * 			Auths: rds.ProxyAuthArray{
 * 				&rds.ProxyAuthArgs{
 * 					AuthScheme:  pulumi.String("SECRETS"),
 * 					Description: pulumi.String("example"),
 * 					IamAuth:     pulumi.String("DISABLED"),
 * 					SecretArn:   pulumi.Any(exampleAwsSecretsmanagerSecret.Arn),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example"),
 * 				"Key":  pulumi.String("value"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleProxyDefaultTargetGroup, err := rds.NewProxyDefaultTargetGroup(ctx, "example", &rds.ProxyDefaultTargetGroupArgs{
 * 			DbProxyName: example.Name,
 * 			ConnectionPoolConfig: &rds.ProxyDefaultTargetGroupConnectionPoolConfigArgs{
 * 				ConnectionBorrowTimeout:   pulumi.Int(120),
 * 				InitQuery:                 pulumi.String("SET x=1, y=2"),
 * 				MaxConnectionsPercent:     pulumi.Int(100),
 * 				MaxIdleConnectionsPercent: pulumi.Int(50),
 * 				SessionPinningFilters: pulumi.StringArray{
 * 					pulumi.String("EXCLUDE_VARIABLE_SETS"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewProxyTarget(ctx, "example", &rds.ProxyTargetArgs{
 * 			DbInstanceIdentifier: pulumi.Any(exampleAwsDbInstance.Identifier),
 * 			DbProxyName:          example.Name,
 * 			TargetGroupName:      exampleProxyDefaultTargetGroup.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Proxy;
 * import com.pulumi.aws.rds.ProxyArgs;
 * import com.pulumi.aws.rds.inputs.ProxyAuthArgs;
 * import com.pulumi.aws.rds.ProxyDefaultTargetGroup;
 * import com.pulumi.aws.rds.ProxyDefaultTargetGroupArgs;
 * import com.pulumi.aws.rds.inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgs;
 * import com.pulumi.aws.rds.ProxyTarget;
 * import com.pulumi.aws.rds.ProxyTargetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Proxy("example", ProxyArgs.builder()
 *             .name("example")
 *             .debugLogging(false)
 *             .engineFamily("MYSQL")
 *             .idleClientTimeout(1800)
 *             .requireTls(true)
 *             .roleArn(exampleAwsIamRole.arn())
 *             .vpcSecurityGroupIds(exampleAwsSecurityGroup.id())
 *             .vpcSubnetIds(exampleAwsSubnet.id())
 *             .auths(ProxyAuthArgs.builder()
 *                 .authScheme("SECRETS")
 *                 .description("example")
 *                 .iamAuth("DISABLED")
 *                 .secretArn(exampleAwsSecretsmanagerSecret.arn())
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("Name", "example"),
 *                 Map.entry("Key", "value")
 *             ))
 *             .build());
 *         var exampleProxyDefaultTargetGroup = new ProxyDefaultTargetGroup("exampleProxyDefaultTargetGroup", ProxyDefaultTargetGroupArgs.builder()
 *             .dbProxyName(example.name())
 *             .connectionPoolConfig(ProxyDefaultTargetGroupConnectionPoolConfigArgs.builder()
 *                 .connectionBorrowTimeout(120)
 *                 .initQuery("SET x=1, y=2")
 *                 .maxConnectionsPercent(100)
 *                 .maxIdleConnectionsPercent(50)
 *                 .sessionPinningFilters("EXCLUDE_VARIABLE_SETS")
 *                 .build())
 *             .build());
 *         var exampleProxyTarget = new ProxyTarget("exampleProxyTarget", ProxyTargetArgs.builder()
 *             .dbInstanceIdentifier(exampleAwsDbInstance.identifier())
 *             .dbProxyName(example.name())
 *             .targetGroupName(exampleProxyDefaultTargetGroup.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:Proxy
 *     properties:
 *       name: example
 *       debugLogging: false
 *       engineFamily: MYSQL
 *       idleClientTimeout: 1800
 *       requireTls: true
 *       roleArn: ${exampleAwsIamRole.arn}
 *       vpcSecurityGroupIds:
 *         - ${exampleAwsSecurityGroup.id}
 *       vpcSubnetIds:
 *         - ${exampleAwsSubnet.id}
 *       auths:
 *         - authScheme: SECRETS
 *           description: example
 *           iamAuth: DISABLED
 *           secretArn: ${exampleAwsSecretsmanagerSecret.arn}
 *       tags:
 *         Name: example
 *         Key: value
 *   exampleProxyDefaultTargetGroup:
 *     type: aws:rds:ProxyDefaultTargetGroup
 *     name: example
 *     properties:
 *       dbProxyName: ${example.name}
 *       connectionPoolConfig:
 *         connectionBorrowTimeout: 120
 *         initQuery: SET x=1, y=2
 *         maxConnectionsPercent: 100
 *         maxIdleConnectionsPercent: 50
 *         sessionPinningFilters:
 *           - EXCLUDE_VARIABLE_SETS
 *   exampleProxyTarget:
 *     type: aws:rds:ProxyTarget
 *     name: example
 *     properties:
 *       dbInstanceIdentifier: ${exampleAwsDbInstance.identifier}
 *       dbProxyName: ${example.name}
 *       targetGroupName: ${exampleProxyDefaultTargetGroup.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Provisioned Clusters:
 * __Using `pulumi import` to import__ RDS DB Proxy Targets using the `db_proxy_name`, `target_group_name`, target type (such as `RDS_INSTANCE` or `TRACKED_CLUSTER`), and resource identifier separated by forward slashes (`/`). For example:
 * Instances:
 * ```sh
 * $ pulumi import aws:rds/proxyTarget:ProxyTarget example example-proxy/default/RDS_INSTANCE/example-instance
 * ```
 * Provisioned Clusters:
 * ```sh
 * $ pulumi import aws:rds/proxyTarget:ProxyTarget example example-proxy/default/TRACKED_CLUSTER/example-cluster
 * ```
 * @property dbClusterIdentifier DB cluster identifier.
 * **NOTE:** Either `db_instance_identifier` or `db_cluster_identifier` should be specified and both should not be specified together
 * @property dbInstanceIdentifier DB instance identifier.
 * @property dbProxyName The name of the DB proxy.
 * @property targetGroupName The name of the target group.
 */
public data class ProxyTargetArgs(
    public val dbClusterIdentifier: Output<String>? = null,
    public val dbInstanceIdentifier: Output<String>? = null,
    public val dbProxyName: Output<String>? = null,
    public val targetGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.ProxyTargetArgs> {
    override fun toJava(): com.pulumi.aws.rds.ProxyTargetArgs =
        com.pulumi.aws.rds.ProxyTargetArgs.builder()
            .dbClusterIdentifier(dbClusterIdentifier?.applyValue({ args0 -> args0 }))
            .dbInstanceIdentifier(dbInstanceIdentifier?.applyValue({ args0 -> args0 }))
            .dbProxyName(dbProxyName?.applyValue({ args0 -> args0 }))
            .targetGroupName(targetGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProxyTargetArgs].
 */
@PulumiTagMarker
public class ProxyTargetArgsBuilder internal constructor() {
    private var dbClusterIdentifier: Output<String>? = null

    private var dbInstanceIdentifier: Output<String>? = null

    private var dbProxyName: Output<String>? = null

    private var targetGroupName: Output<String>? = null

    /**
     * @param value DB cluster identifier.
     * **NOTE:** Either `db_instance_identifier` or `db_cluster_identifier` should be specified and both should not be specified together
     */
    @JvmName("yvjjbdiyywclheot")
    public suspend fun dbClusterIdentifier(`value`: Output<String>) {
        this.dbClusterIdentifier = value
    }

    /**
     * @param value DB instance identifier.
     */
    @JvmName("iyxngfrlbjvpxigs")
    public suspend fun dbInstanceIdentifier(`value`: Output<String>) {
        this.dbInstanceIdentifier = value
    }

    /**
     * @param value The name of the DB proxy.
     */
    @JvmName("ommfsobvwkgiwlpj")
    public suspend fun dbProxyName(`value`: Output<String>) {
        this.dbProxyName = value
    }

    /**
     * @param value The name of the target group.
     */
    @JvmName("agnnkhlugghowxav")
    public suspend fun targetGroupName(`value`: Output<String>) {
        this.targetGroupName = value
    }

    /**
     * @param value DB cluster identifier.
     * **NOTE:** Either `db_instance_identifier` or `db_cluster_identifier` should be specified and both should not be specified together
     */
    @JvmName("wogadqxmyqcufpyw")
    public suspend fun dbClusterIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbClusterIdentifier = mapped
    }

    /**
     * @param value DB instance identifier.
     */
    @JvmName("meyrktuidyoclnux")
    public suspend fun dbInstanceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceIdentifier = mapped
    }

    /**
     * @param value The name of the DB proxy.
     */
    @JvmName("jiptxeupkgncsrni")
    public suspend fun dbProxyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbProxyName = mapped
    }

    /**
     * @param value The name of the target group.
     */
    @JvmName("dwlmaihurkmokyss")
    public suspend fun targetGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupName = mapped
    }

    internal fun build(): ProxyTargetArgs = ProxyTargetArgs(
        dbClusterIdentifier = dbClusterIdentifier,
        dbInstanceIdentifier = dbInstanceIdentifier,
        dbProxyName = dbProxyName,
        targetGroupName = targetGroupName,
    )
}
