@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.RdsFunctions.getCertificatePlain
import com.pulumi.aws.rds.RdsFunctions.getClusterParameterGroupPlain
import com.pulumi.aws.rds.RdsFunctions.getClusterPlain
import com.pulumi.aws.rds.RdsFunctions.getClusterSnapshotPlain
import com.pulumi.aws.rds.RdsFunctions.getClustersPlain
import com.pulumi.aws.rds.RdsFunctions.getEngineVersionPlain
import com.pulumi.aws.rds.RdsFunctions.getEventCategoriesPlain
import com.pulumi.aws.rds.RdsFunctions.getInstancePlain
import com.pulumi.aws.rds.RdsFunctions.getInstancesPlain
import com.pulumi.aws.rds.RdsFunctions.getOrderableDbInstancePlain
import com.pulumi.aws.rds.RdsFunctions.getParameterGroupPlain
import com.pulumi.aws.rds.RdsFunctions.getProxyPlain
import com.pulumi.aws.rds.RdsFunctions.getReservedInstanceOfferingPlain
import com.pulumi.aws.rds.RdsFunctions.getSnapshotPlain
import com.pulumi.aws.rds.RdsFunctions.getSubnetGroupPlain
import com.pulumi.aws.rds.kotlin.inputs.GetCertificatePlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetCertificatePlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetClusterParameterGroupPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetClusterParameterGroupPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetClusterSnapshotPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetClusterSnapshotPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetClustersFilter
import com.pulumi.aws.rds.kotlin.inputs.GetClustersPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetClustersPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetEngineVersionFilter
import com.pulumi.aws.rds.kotlin.inputs.GetEngineVersionPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetEngineVersionPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetEventCategoriesPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetEventCategoriesPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetInstancePlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetInstancePlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetInstancesFilter
import com.pulumi.aws.rds.kotlin.inputs.GetInstancesPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetInstancesPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetOrderableDbInstancePlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetOrderableDbInstancePlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetParameterGroupPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetParameterGroupPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetProxyPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetProxyPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetReservedInstanceOfferingPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetReservedInstanceOfferingPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetSnapshotPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetSnapshotPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.inputs.GetSubnetGroupPlainArgs
import com.pulumi.aws.rds.kotlin.inputs.GetSubnetGroupPlainArgsBuilder
import com.pulumi.aws.rds.kotlin.outputs.GetCertificateResult
import com.pulumi.aws.rds.kotlin.outputs.GetClusterParameterGroupResult
import com.pulumi.aws.rds.kotlin.outputs.GetClusterResult
import com.pulumi.aws.rds.kotlin.outputs.GetClusterSnapshotResult
import com.pulumi.aws.rds.kotlin.outputs.GetClustersResult
import com.pulumi.aws.rds.kotlin.outputs.GetEngineVersionResult
import com.pulumi.aws.rds.kotlin.outputs.GetEventCategoriesResult
import com.pulumi.aws.rds.kotlin.outputs.GetInstanceResult
import com.pulumi.aws.rds.kotlin.outputs.GetInstancesResult
import com.pulumi.aws.rds.kotlin.outputs.GetOrderableDbInstanceResult
import com.pulumi.aws.rds.kotlin.outputs.GetParameterGroupResult
import com.pulumi.aws.rds.kotlin.outputs.GetProxyResult
import com.pulumi.aws.rds.kotlin.outputs.GetReservedInstanceOfferingResult
import com.pulumi.aws.rds.kotlin.outputs.GetSnapshotResult
import com.pulumi.aws.rds.kotlin.outputs.GetSubnetGroupResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.rds.kotlin.outputs.GetCertificateResult.Companion.toKotlin as getCertificateResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetClusterParameterGroupResult.Companion.toKotlin as getClusterParameterGroupResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetClusterSnapshotResult.Companion.toKotlin as getClusterSnapshotResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetClustersResult.Companion.toKotlin as getClustersResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetEngineVersionResult.Companion.toKotlin as getEngineVersionResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetEventCategoriesResult.Companion.toKotlin as getEventCategoriesResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetInstanceResult.Companion.toKotlin as getInstanceResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetOrderableDbInstanceResult.Companion.toKotlin as getOrderableDbInstanceResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetParameterGroupResult.Companion.toKotlin as getParameterGroupResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetProxyResult.Companion.toKotlin as getProxyResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetReservedInstanceOfferingResult.Companion.toKotlin as getReservedInstanceOfferingResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetSnapshotResult.Companion.toKotlin as getSnapshotResultToKotlin
import com.pulumi.aws.rds.kotlin.outputs.GetSubnetGroupResult.Companion.toKotlin as getSubnetGroupResultToKotlin

public object RdsFunctions {
    /**
     * Information about an RDS Certificate.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.rds.getCertificate({
     *     latestValidTill: true,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.rds.get_certificate(latest_valid_till=True)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Rds.GetCertificate.Invoke(new()
     *     {
     *         LatestValidTill = true,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.LookupCertificate(ctx, &rds.LookupCertificateArgs{
     * 			LatestValidTill: pulumi.BoolRef(true),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetCertificateArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RdsFunctions.getCertificate(GetCertificateArgs.builder()
     *             .latestValidTill(true)
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:rds:getCertificate
     *       Arguments:
     *         latestValidTill: true
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCertificate.
     * @return A collection of values returned by getCertificate.
     */
    public suspend fun getCertificate(argument: GetCertificatePlainArgs): GetCertificateResult =
        getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())

    /**
     * @see [getCertificate].
     * @param id Certificate identifier. For example, `rds-ca-2019`.
     * @param latestValidTill When enabled, returns the certificate with the latest `ValidTill`.
     * @return A collection of values returned by getCertificate.
     */
    public suspend fun getCertificate(id: String? = null, latestValidTill: Boolean? = null): GetCertificateResult {
        val argument = GetCertificatePlainArgs(
            id = id,
            latestValidTill = latestValidTill,
        )
        return getCertificateResultToKotlin(getCertificatePlain(argument.toJava()).await())
    }

    /**
     * @see [getCertificate].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetCertificatePlainArgs].
     * @return A collection of values returned by getCertificate.
     */
    public suspend fun getCertificate(argument: suspend GetCertificatePlainArgsBuilder.() -> Unit): GetCertificateResult {
        val builder = GetCertificatePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCertificateResultToKotlin(getCertificatePlain(builtArgument.toJava()).await())
    }

    /**
     * Provides information about an RDS cluster.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const clusterName = aws.rds.getCluster({
     *     clusterIdentifier: "clusterName",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * cluster_name = aws.rds.get_cluster(cluster_identifier="clusterName")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var clusterName = Aws.Rds.GetCluster.Invoke(new()
     *     {
     *         ClusterIdentifier = "clusterName",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.LookupCluster(ctx, &rds.LookupClusterArgs{
     * 			ClusterIdentifier: "clusterName",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var clusterName = RdsFunctions.getCluster(GetClusterArgs.builder()
     *             .clusterIdentifier("clusterName")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   clusterName:
     *     fn::invoke:
     *       Function: aws:rds:getCluster
     *       Arguments:
     *         clusterIdentifier: clusterName
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCluster.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterIdentifier Cluster identifier of the RDS cluster.
     * @param tags A map of tags assigned to the resource.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(clusterIdentifier: String, tags: Map<String, String>? = null): GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterIdentifier = clusterIdentifier,
            tags = tags,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit): GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about an RDS cluster parameter group.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.rds.getClusterParameterGroup({
     *     name: "default.postgres15",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.rds.get_cluster_parameter_group(name="default.postgres15")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Rds.GetClusterParameterGroup.Invoke(new()
     *     {
     *         Name = "default.postgres15",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.LookupClusterParameterGroup(ctx, &rds.LookupClusterParameterGroupArgs{
     * 			Name: "default.postgres15",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetClusterParameterGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = RdsFunctions.getClusterParameterGroup(GetClusterParameterGroupArgs.builder()
     *             .name("default.postgres15")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:rds:getClusterParameterGroup
     *       Arguments:
     *         name: default.postgres15
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getClusterParameterGroup.
     * @return A collection of values returned by getClusterParameterGroup.
     */
    public suspend fun getClusterParameterGroup(argument: GetClusterParameterGroupPlainArgs): GetClusterParameterGroupResult =
        getClusterParameterGroupResultToKotlin(getClusterParameterGroupPlain(argument.toJava()).await())

    /**
     * @see [getClusterParameterGroup].
     * @param name DB cluster parameter group name.
     * @return A collection of values returned by getClusterParameterGroup.
     */
    public suspend fun getClusterParameterGroup(name: String): GetClusterParameterGroupResult {
        val argument = GetClusterParameterGroupPlainArgs(
            name = name,
        )
        return getClusterParameterGroupResultToKotlin(getClusterParameterGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusterParameterGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetClusterParameterGroupPlainArgs].
     * @return A collection of values returned by getClusterParameterGroup.
     */
    public suspend fun getClusterParameterGroup(argument: suspend GetClusterParameterGroupPlainArgsBuilder.() -> Unit): GetClusterParameterGroupResult {
        val builder = GetClusterParameterGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterParameterGroupResultToKotlin(getClusterParameterGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about a DB Cluster Snapshot for use when provisioning DB clusters.
     * > **NOTE:** This data source does not apply to snapshots created on DB Instances.
     * See the `aws.rds.Snapshot` data source for DB Instance snapshots.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const developmentFinalSnapshot = aws.rds.getClusterSnapshot({
     *     dbClusterIdentifier: "development_cluster",
     *     mostRecent: true,
     * });
     * // Use the last snapshot of the dev database before it was destroyed to create
     * // a new dev database.
     * const aurora = new aws.rds.Cluster("aurora", {
     *     clusterIdentifier: "development_cluster",
     *     snapshotIdentifier: developmentFinalSnapshot.then(developmentFinalSnapshot => developmentFinalSnapshot.id),
     *     dbSubnetGroupName: "my_db_subnet_group",
     * });
     * const auroraClusterInstance = new aws.rds.ClusterInstance("aurora", {
     *     clusterIdentifier: aurora.id,
     *     instanceClass: aws.rds.InstanceType.T2_Small,
     *     dbSubnetGroupName: "my_db_subnet_group",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * development_final_snapshot = aws.rds.get_cluster_snapshot(db_cluster_identifier="development_cluster",
     *     most_recent=True)
     * # Use the last snapshot of the dev database before it was destroyed to create
     * # a new dev database.
     * aurora = aws.rds.Cluster("aurora",
     *     cluster_identifier="development_cluster",
     *     snapshot_identifier=development_final_snapshot.id,
     *     db_subnet_group_name="my_db_subnet_group")
     * aurora_cluster_instance = aws.rds.ClusterInstance("aurora",
     *     cluster_identifier=aurora.id,
     *     instance_class=aws.rds.InstanceType.T2_SMALL,
     *     db_subnet_group_name="my_db_subnet_group")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var developmentFinalSnapshot = Aws.Rds.GetClusterSnapshot.Invoke(new()
     *     {
     *         DbClusterIdentifier = "development_cluster",
     *         MostRecent = true,
     *     });
     *     // Use the last snapshot of the dev database before it was destroyed to create
     *     // a new dev database.
     *     var aurora = new Aws.Rds.Cluster("aurora", new()
     *     {
     *         ClusterIdentifier = "development_cluster",
     *         SnapshotIdentifier = developmentFinalSnapshot.Apply(getClusterSnapshotResult => getClusterSnapshotResult.Id),
     *         DbSubnetGroupName = "my_db_subnet_group",
     *     });
     *     var auroraClusterInstance = new Aws.Rds.ClusterInstance("aurora", new()
     *     {
     *         ClusterIdentifier = aurora.Id,
     *         InstanceClass = Aws.Rds.InstanceType.T2_Small,
     *         DbSubnetGroupName = "my_db_subnet_group",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		developmentFinalSnapshot, err := rds.LookupClusterSnapshot(ctx, &rds.LookupClusterSnapshotArgs{
     * 			DbClusterIdentifier: pulumi.StringRef("development_cluster"),
     * 			MostRecent:          pulumi.BoolRef(true),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		// Use the last snapshot of the dev database before it was destroyed to create
     * 		// a new dev database.
     * 		aurora, err := rds.NewCluster(ctx, "aurora", &rds.ClusterArgs{
     * 			ClusterIdentifier:  pulumi.String("development_cluster"),
     * 			SnapshotIdentifier: pulumi.String(developmentFinalSnapshot.Id),
     * 			DbSubnetGroupName:  pulumi.String("my_db_subnet_group"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = rds.NewClusterInstance(ctx, "aurora", &rds.ClusterInstanceArgs{
     * 			ClusterIdentifier: aurora.ID(),
     * 			InstanceClass:     pulumi.String(rds.InstanceType_T2_Small),
     * 			DbSubnetGroupName: pulumi.String("my_db_subnet_group"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetClusterSnapshotArgs;
     * import com.pulumi.aws.rds.Cluster;
     * import com.pulumi.aws.rds.ClusterArgs;
     * import com.pulumi.aws.rds.ClusterInstance;
     * import com.pulumi.aws.rds.ClusterInstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var developmentFinalSnapshot = RdsFunctions.getClusterSnapshot(GetClusterSnapshotArgs.builder()
     *             .dbClusterIdentifier("development_cluster")
     *             .mostRecent(true)
     *             .build());
     *         // Use the last snapshot of the dev database before it was destroyed to create
     *         // a new dev database.
     *         var aurora = new Cluster("aurora", ClusterArgs.builder()
     *             .clusterIdentifier("development_cluster")
     *             .snapshotIdentifier(developmentFinalSnapshot.applyValue(getClusterSnapshotResult -> getClusterSnapshotResult.id()))
     *             .dbSubnetGroupName("my_db_subnet_group")
     *             .build());
     *         var auroraClusterInstance = new ClusterInstance("auroraClusterInstance", ClusterInstanceArgs.builder()
     *             .clusterIdentifier(aurora.id())
     *             .instanceClass("db.t2.small")
     *             .dbSubnetGroupName("my_db_subnet_group")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   # Use the last snapshot of the dev database before it was destroyed to create
     *   # a new dev database.
     *   aurora:
     *     type: aws:rds:Cluster
     *     properties:
     *       clusterIdentifier: development_cluster
     *       snapshotIdentifier: ${developmentFinalSnapshot.id}
     *       dbSubnetGroupName: my_db_subnet_group
     *   auroraClusterInstance:
     *     type: aws:rds:ClusterInstance
     *     name: aurora
     *     properties:
     *       clusterIdentifier: ${aurora.id}
     *       instanceClass: db.t2.small
     *       dbSubnetGroupName: my_db_subnet_group
     * variables:
     *   developmentFinalSnapshot:
     *     fn::invoke:
     *       Function: aws:rds:getClusterSnapshot
     *       Arguments:
     *         dbClusterIdentifier: development_cluster
     *         mostRecent: true
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getClusterSnapshot.
     * @return A collection of values returned by getClusterSnapshot.
     */
    public suspend fun getClusterSnapshot(argument: GetClusterSnapshotPlainArgs): GetClusterSnapshotResult =
        getClusterSnapshotResultToKotlin(getClusterSnapshotPlain(argument.toJava()).await())

    /**
     * @see [getClusterSnapshot].
     * @param dbClusterIdentifier Returns the list of snapshots created by the specific db_cluster
     * @param dbClusterSnapshotIdentifier Returns information on a specific snapshot_id.
     * @param includePublic Set this value to true to include manual DB Cluster Snapshots that are public and can be
     * copied or restored by any AWS account, otherwise set this value to false. The default is `false`.
     * @param includeShared Set this value to true to include shared manual DB Cluster Snapshots from other
     * AWS accounts that this AWS account has been given permission to copy or restore, otherwise set this value to false.
     * The default is `false`.
     * @param mostRecent If more than one result is returned, use the most recent Snapshot.
     * @param snapshotType Type of snapshots to be returned. If you don't specify a SnapshotType
     * value, then both automated and manual DB cluster snapshots are returned. Shared and public DB Cluster Snapshots are not
     * included in the returned results by default. Possible values are, `automated`, `manual`, `shared`, `public` and `awsbackup`.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired DB cluster snapshot.
     * @return A collection of values returned by getClusterSnapshot.
     */
    public suspend fun getClusterSnapshot(
        dbClusterIdentifier: String? = null,
        dbClusterSnapshotIdentifier: String? = null,
        includePublic: Boolean? = null,
        includeShared: Boolean? = null,
        mostRecent: Boolean? = null,
        snapshotType: String? = null,
        tags: Map<String, String>? = null,
    ): GetClusterSnapshotResult {
        val argument = GetClusterSnapshotPlainArgs(
            dbClusterIdentifier = dbClusterIdentifier,
            dbClusterSnapshotIdentifier = dbClusterSnapshotIdentifier,
            includePublic = includePublic,
            includeShared = includeShared,
            mostRecent = mostRecent,
            snapshotType = snapshotType,
            tags = tags,
        )
        return getClusterSnapshotResultToKotlin(getClusterSnapshotPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusterSnapshot].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetClusterSnapshotPlainArgs].
     * @return A collection of values returned by getClusterSnapshot.
     */
    public suspend fun getClusterSnapshot(argument: suspend GetClusterSnapshotPlainArgsBuilder.() -> Unit): GetClusterSnapshotResult {
        val builder = GetClusterSnapshotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterSnapshotResultToKotlin(getClusterSnapshotPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS RDS (Relational Database) Clusters.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.rds.getClusters({
     *     filters: [{
     *         name: "engine",
     *         values: ["aurora-postgresql"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.rds.get_clusters(filters=[{
     *     "name": "engine",
     *     "values": ["aurora-postgresql"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Rds.GetClusters.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Rds.Inputs.GetClustersFilterInputArgs
     *             {
     *                 Name = "engine",
     *                 Values = new[]
     *                 {
     *                     "aurora-postgresql",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.GetClusters(ctx, &rds.GetClustersArgs{
     * 			Filters: []rds.GetClustersFilter{
     * 				{
     * 					Name: "engine",
     * 					Values: []string{
     * 						"aurora-postgresql",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetClustersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RdsFunctions.getClusters(GetClustersArgs.builder()
     *             .filters(GetClustersFilterArgs.builder()
     *                 .name("engine")
     *                 .values("aurora-postgresql")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:rds:getClusters
     *       Arguments:
     *         filters:
     *           - name: engine
     *             values:
     *               - aurora-postgresql
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getClusters.
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: GetClustersPlainArgs): GetClustersResult =
        getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())

    /**
     * @see [getClusters].
     * @param filters Configuration block(s) for filtering. Detailed below.
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(filters: List<GetClustersFilter>? = null): GetClustersResult {
        val argument = GetClustersPlainArgs(
            filters = filters,
        )
        return getClustersResultToKotlin(getClustersPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusters].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetClustersPlainArgs].
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(argument: suspend GetClustersPlainArgsBuilder.() -> Unit): GetClustersResult {
        val builder = GetClustersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClustersResultToKotlin(getClustersPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about an RDS engine version.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.rds.getEngineVersion({
     *     engine: "mysql",
     *     preferredVersions: [
     *         "8.0.27",
     *         "8.0.26",
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.rds.get_engine_version(engine="mysql",
     *     preferred_versions=[
     *         "8.0.27",
     *         "8.0.26",
     *     ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Rds.GetEngineVersion.Invoke(new()
     *     {
     *         Engine = "mysql",
     *         PreferredVersions = new[]
     *         {
     *             "8.0.27",
     *             "8.0.26",
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.GetEngineVersion(ctx, &rds.GetEngineVersionArgs{
     * 			Engine: "mysql",
     * 			PreferredVersions: []string{
     * 				"8.0.27",
     * 				"8.0.26",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetEngineVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = RdsFunctions.getEngineVersion(GetEngineVersionArgs.builder()
     *             .engine("mysql")
     *             .preferredVersions(
     *                 "8.0.27",
     *                 "8.0.26")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:rds:getEngineVersion
     *       Arguments:
     *         engine: mysql
     *         preferredVersions:
     *           - 8.0.27
     *           - 8.0.26
     * ```
     * <!--End PulumiCodeChooser -->
     * ### With `filter`
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.rds.getEngineVersion({
     *     engine: "aurora-postgresql",
     *     version: "10.14",
     *     includeAll: true,
     *     filters: [{
     *         name: "engine-mode",
     *         values: ["serverless"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.rds.get_engine_version(engine="aurora-postgresql",
     *     version="10.14",
     *     include_all=True,
     *     filters=[{
     *         "name": "engine-mode",
     *         "values": ["serverless"],
     *     }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Rds.GetEngineVersion.Invoke(new()
     *     {
     *         Engine = "aurora-postgresql",
     *         Version = "10.14",
     *         IncludeAll = true,
     *         Filters = new[]
     *         {
     *             new Aws.Rds.Inputs.GetEngineVersionFilterInputArgs
     *             {
     *                 Name = "engine-mode",
     *                 Values = new[]
     *                 {
     *                     "serverless",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.GetEngineVersion(ctx, &rds.GetEngineVersionArgs{
     * 			Engine:     "aurora-postgresql",
     * 			Version:    pulumi.StringRef("10.14"),
     * 			IncludeAll: pulumi.BoolRef(true),
     * 			Filters: []rds.GetEngineVersionFilter{
     * 				{
     * 					Name: "engine-mode",
     * 					Values: []string{
     * 						"serverless",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetEngineVersionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = RdsFunctions.getEngineVersion(GetEngineVersionArgs.builder()
     *             .engine("aurora-postgresql")
     *             .version("10.14")
     *             .includeAll(true)
     *             .filters(GetEngineVersionFilterArgs.builder()
     *                 .name("engine-mode")
     *                 .values("serverless")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:rds:getEngineVersion
     *       Arguments:
     *         engine: aurora-postgresql
     *         version: '10.14'
     *         includeAll: true
     *         filters:
     *           - name: engine-mode
     *             values:
     *               - serverless
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEngineVersion.
     * @return A collection of values returned by getEngineVersion.
     */
    public suspend fun getEngineVersion(argument: GetEngineVersionPlainArgs): GetEngineVersionResult =
        getEngineVersionResultToKotlin(getEngineVersionPlain(argument.toJava()).await())

    /**
     * @see [getEngineVersion].
     * @param defaultOnly Whether the engine version must be an AWS-defined default version. Some engines have multiple default versions, such as for each major version. Using `default_only` may help avoid `multiple RDS engine versions` errors. See also `latest`.
     * @param engine Database engine. Engine values include `aurora`, `aurora-mysql`, `aurora-postgresql`, `docdb`, `mariadb`, `mysql`, `neptune`, `oracle-ee`, `oracle-se`, `oracle-se1`, `oracle-se2`, `postgres`, `sqlserver-ee`, `sqlserver-ex`, `sqlserver-se`, and `sqlserver-web`.
     * The following arguments are optional:
     * @param filters One or more name/value pairs to use in filtering versions. There are several valid keys; for a full reference, check out [describe-db-engine-versions in the AWS CLI reference](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/describe-db-engine-versions.html).
     * @param hasMajorTarget Whether the engine version must have one or more major upgrade targets. Not including `has_major_target` or setting it to `false` doesn't imply that there's no corresponding major upgrade target for the engine version.
     * @param hasMinorTarget Whether the engine version must have one or more minor upgrade targets. Not including `has_minor_target` or setting it to `false` doesn't imply that there's no corresponding minor upgrade target for the engine version.
     * @param includeAll Whether the engine version `status` can either be `deprecated` or `available`. When not set or set to `false`, the engine version `status` will always be `available`.
     * @param latest Whether the engine version is the most recent version matching the other criteria. This is different from `default_only` in important ways: "default" relies on AWS-defined defaults, the latest version isn't always the default, and AWS might have multiple default versions for an engine. As a result, `default_only` might not prevent errors from `multiple RDS engine versions`, while `latest` will. (`latest` can be used with `default_only`.) **Note:** The data source uses a best-effort approach at selecting the latest version. Due to the complexity of version identifiers across engines and incomplete version date information provided by AWS, using `latest` may not always result in the engine version being the actual latest version.
     * @param parameterGroupFamily Name of a specific database parameter group family. Examples of parameter group families are `mysql8.0`, `mariadb10.4`, and `postgres12`.
     * @param preferredMajorTargets Ordered list of preferred major version upgrade targets. The engine version will be the first match in the list unless the `latest` parameter is set to `true`. The engine version will be the default version if you don't include any criteria, such as `preferred_major_targets`.
     * @param preferredUpgradeTargets Ordered list of preferred version upgrade targets. The engine version will be the first match in this list unless the `latest` parameter is set to `true`. The engine version will be the default version if you don't include any criteria, such as `preferred_upgrade_targets`.
     * @param preferredVersions Ordered list of preferred versions. The engine version will be the first match in this list unless the `latest` parameter is set to `true`. The engine version will be the default version if you don't include any criteria, such as `preferred_versions`.
     * @param version
     * @return A collection of values returned by getEngineVersion.
     */
    public suspend fun getEngineVersion(
        defaultOnly: Boolean? = null,
        engine: String,
        filters: List<GetEngineVersionFilter>? = null,
        hasMajorTarget: Boolean? = null,
        hasMinorTarget: Boolean? = null,
        includeAll: Boolean? = null,
        latest: Boolean? = null,
        parameterGroupFamily: String? = null,
        preferredMajorTargets: List<String>? = null,
        preferredUpgradeTargets: List<String>? = null,
        preferredVersions: List<String>? = null,
        version: String? = null,
    ): GetEngineVersionResult {
        val argument = GetEngineVersionPlainArgs(
            defaultOnly = defaultOnly,
            engine = engine,
            filters = filters,
            hasMajorTarget = hasMajorTarget,
            hasMinorTarget = hasMinorTarget,
            includeAll = includeAll,
            latest = latest,
            parameterGroupFamily = parameterGroupFamily,
            preferredMajorTargets = preferredMajorTargets,
            preferredUpgradeTargets = preferredUpgradeTargets,
            preferredVersions = preferredVersions,
            version = version,
        )
        return getEngineVersionResultToKotlin(getEngineVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getEngineVersion].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetEngineVersionPlainArgs].
     * @return A collection of values returned by getEngineVersion.
     */
    public suspend fun getEngineVersion(argument: suspend GetEngineVersionPlainArgsBuilder.() -> Unit): GetEngineVersionResult {
        val builder = GetEngineVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEngineVersionResultToKotlin(getEngineVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * ## Example Usage
     * List the event categories of all the RDS resources.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * export = async () => {
     *     const example = await aws.rds.getEventCategories({});
     *     return {
     *         example: example.eventCategories,
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.rds.get_event_categories()
     * pulumi.export("example", example.event_categories)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Rds.GetEventCategories.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["example"] = example.Apply(getEventCategoriesResult => getEventCategoriesResult.EventCategories),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := rds.GetEventCategories(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("example", example.EventCategories)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetEventCategoriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RdsFunctions.getEventCategories();
     *         ctx.export("example", example.applyValue(getEventCategoriesResult -> getEventCategoriesResult.eventCategories()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:rds:getEventCategories
     *       Arguments: {}
     * outputs:
     *   example: ${example.eventCategories}
     * ```
     * <!--End PulumiCodeChooser -->
     * List the event categories specific to the RDS resource `db-snapshot`.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * export = async () => {
     *     const example = await aws.rds.getEventCategories({
     *         sourceType: "db-snapshot",
     *     });
     *     return {
     *         example: example.eventCategories,
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.rds.get_event_categories(source_type="db-snapshot")
     * pulumi.export("example", example.event_categories)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Rds.GetEventCategories.Invoke(new()
     *     {
     *         SourceType = "db-snapshot",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["example"] = example.Apply(getEventCategoriesResult => getEventCategoriesResult.EventCategories),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := rds.GetEventCategories(ctx, &rds.GetEventCategoriesArgs{
     * 			SourceType: pulumi.StringRef("db-snapshot"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("example", example.EventCategories)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetEventCategoriesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RdsFunctions.getEventCategories(GetEventCategoriesArgs.builder()
     *             .sourceType("db-snapshot")
     *             .build());
     *         ctx.export("example", example.applyValue(getEventCategoriesResult -> getEventCategoriesResult.eventCategories()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:rds:getEventCategories
     *       Arguments:
     *         sourceType: db-snapshot
     * outputs:
     *   example: ${example.eventCategories}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getEventCategories.
     * @return A collection of values returned by getEventCategories.
     */
    public suspend fun getEventCategories(argument: GetEventCategoriesPlainArgs): GetEventCategoriesResult =
        getEventCategoriesResultToKotlin(getEventCategoriesPlain(argument.toJava()).await())

    /**
     * @see [getEventCategories].
     * @param sourceType Type of source that will be generating the events. Valid options are db-instance, db-security-group, db-parameter-group, db-snapshot, db-cluster or db-cluster-snapshot.
     * @return A collection of values returned by getEventCategories.
     */
    public suspend fun getEventCategories(sourceType: String? = null): GetEventCategoriesResult {
        val argument = GetEventCategoriesPlainArgs(
            sourceType = sourceType,
        )
        return getEventCategoriesResultToKotlin(getEventCategoriesPlain(argument.toJava()).await())
    }

    /**
     * @see [getEventCategories].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetEventCategoriesPlainArgs].
     * @return A collection of values returned by getEventCategories.
     */
    public suspend fun getEventCategories(argument: suspend GetEventCategoriesPlainArgsBuilder.() -> Unit): GetEventCategoriesResult {
        val builder = GetEventCategoriesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getEventCategoriesResultToKotlin(getEventCategoriesPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about an RDS instance
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const database = aws.rds.getInstance({
     *     dbInstanceIdentifier: "my-test-database",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * database = aws.rds.get_instance(db_instance_identifier="my-test-database")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var database = Aws.Rds.GetInstance.Invoke(new()
     *     {
     *         DbInstanceIdentifier = "my-test-database",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.LookupInstance(ctx, &rds.LookupInstanceArgs{
     * 			DbInstanceIdentifier: pulumi.StringRef("my-test-database"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetInstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var database = RdsFunctions.getInstance(GetInstanceArgs.builder()
     *             .dbInstanceIdentifier("my-test-database")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   database:
     *     fn::invoke:
     *       Function: aws:rds:getInstance
     *       Arguments:
     *         dbInstanceIdentifier: my-test-database
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstance.
     * @return A collection of values returned by getInstance.
     */
    public suspend fun getInstance(argument: GetInstancePlainArgs): GetInstanceResult =
        getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())

    /**
     * @see [getInstance].
     * @param dbInstanceIdentifier Name of the RDS instance.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired instance.
     * @return A collection of values returned by getInstance.
     */
    public suspend fun getInstance(
        dbInstanceIdentifier: String? = null,
        tags: Map<String, String>? =
            null,
    ): GetInstanceResult {
        val argument = GetInstancePlainArgs(
            dbInstanceIdentifier = dbInstanceIdentifier,
            tags = tags,
        )
        return getInstanceResultToKotlin(getInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getInstance].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetInstancePlainArgs].
     * @return A collection of values returned by getInstance.
     */
    public suspend fun getInstance(argument: suspend GetInstancePlainArgsBuilder.() -> Unit): GetInstanceResult {
        val builder = GetInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstanceResultToKotlin(getInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for listing RDS Database Instances.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.rds.getInstances({
     *     filters: [{
     *         name: "db-instance-id",
     *         values: ["my-database-id"],
     *     }],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.rds.get_instances(filters=[{
     *     "name": "db-instance-id",
     *     "values": ["my-database-id"],
     * }])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Rds.GetInstances.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.Rds.Inputs.GetInstancesFilterInputArgs
     *             {
     *                 Name = "db-instance-id",
     *                 Values = new[]
     *                 {
     *                     "my-database-id",
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.GetInstances(ctx, &rds.GetInstancesArgs{
     * 			Filters: []rds.GetInstancesFilter{
     * 				{
     * 					Name: "db-instance-id",
     * 					Values: []string{
     * 						"my-database-id",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RdsFunctions.getInstances(GetInstancesArgs.builder()
     *             .filters(GetInstancesFilterArgs.builder()
     *                 .name("db-instance-id")
     *                 .values("my-database-id")
     *                 .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:rds:getInstances
     *       Arguments:
     *         filters:
     *           - name: db-instance-id
     *             values:
     *               - my-database-id
     * ```
     * <!--End PulumiCodeChooser -->
     * ### Using tags
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.rds.getInstances({
     *     tags: {
     *         Env: "test",
     *     },
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.rds.get_instances(tags={
     *     "Env": "test",
     * })
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Rds.GetInstances.Invoke(new()
     *     {
     *         Tags =
     *         {
     *             { "Env", "test" },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.GetInstances(ctx, &rds.GetInstancesArgs{
     * 			Tags: map[string]interface{}{
     * 				"Env": "test",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetInstancesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = RdsFunctions.getInstances(GetInstancesArgs.builder()
     *             .tags(Map.of("Env", "test"))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:rds:getInstances
     *       Arguments:
     *         tags:
     *           Env: test
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getInstances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: GetInstancesPlainArgs): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())

    /**
     * @see [getInstances].
     * @param filters Configuration block(s) used to filter instances with AWS supported attributes, such as `engine`, `db-cluster-id` or `db-instance-id` for example. Detailed below.
     * @param tags Map of tags, each pair of which must exactly match a pair on the desired instances.
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(
        filters: List<GetInstancesFilter>? = null,
        tags: Map<String, String>? = null,
    ): GetInstancesResult {
        val argument = GetInstancesPlainArgs(
            filters = filters,
            tags = tags,
        )
        return getInstancesResultToKotlin(getInstancesPlain(argument.toJava()).await())
    }

    /**
     * @see [getInstances].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetInstancesPlainArgs].
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(argument: suspend GetInstancesPlainArgsBuilder.() -> Unit): GetInstancesResult {
        val builder = GetInstancesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getInstancesResultToKotlin(getInstancesPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about RDS orderable DB instances and valid parameter combinations.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.rds.getOrderableDbInstance({
     *     engine: "mysql",
     *     engineVersion: "5.7.22",
     *     licenseModel: "general-public-license",
     *     storageType: "standard",
     *     preferredInstanceClasses: [
     *         "db.r6.xlarge",
     *         "db.m4.large",
     *         "db.t3.small",
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.rds.get_orderable_db_instance(engine="mysql",
     *     engine_version="5.7.22",
     *     license_model="general-public-license",
     *     storage_type="standard",
     *     preferred_instance_classes=[
     *         "db.r6.xlarge",
     *         "db.m4.large",
     *         "db.t3.small",
     *     ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Rds.GetOrderableDbInstance.Invoke(new()
     *     {
     *         Engine = "mysql",
     *         EngineVersion = "5.7.22",
     *         LicenseModel = "general-public-license",
     *         StorageType = "standard",
     *         PreferredInstanceClasses = new[]
     *         {
     *             "db.r6.xlarge",
     *             "db.m4.large",
     *             "db.t3.small",
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.GetOrderableDbInstance(ctx, &rds.GetOrderableDbInstanceArgs{
     * 			Engine:        "mysql",
     * 			EngineVersion: pulumi.StringRef("5.7.22"),
     * 			LicenseModel:  pulumi.StringRef("general-public-license"),
     * 			StorageType:   pulumi.StringRef("standard"),
     * 			PreferredInstanceClasses: []string{
     * 				"db.r6.xlarge",
     * 				"db.m4.large",
     * 				"db.t3.small",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetOrderableDbInstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = RdsFunctions.getOrderableDbInstance(GetOrderableDbInstanceArgs.builder()
     *             .engine("mysql")
     *             .engineVersion("5.7.22")
     *             .licenseModel("general-public-license")
     *             .storageType("standard")
     *             .preferredInstanceClasses(
     *                 "db.r6.xlarge",
     *                 "db.m4.large",
     *                 "db.t3.small")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:rds:getOrderableDbInstance
     *       Arguments:
     *         engine: mysql
     *         engineVersion: 5.7.22
     *         licenseModel: general-public-license
     *         storageType: standard
     *         preferredInstanceClasses:
     *           - db.r6.xlarge
     *           - db.m4.large
     *           - db.t3.small
     * ```
     * <!--End PulumiCodeChooser -->
     * Valid parameter combinations can also be found with `preferred_engine_versions` and/or `preferred_instance_classes`.
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.rds.getOrderableDbInstance({
     *     engine: "mysql",
     *     licenseModel: "general-public-license",
     *     preferredEngineVersions: [
     *         "5.6.35",
     *         "5.6.41",
     *         "5.6.44",
     *     ],
     *     preferredInstanceClasses: [
     *         "db.t2.small",
     *         "db.t3.medium",
     *         "db.t3.large",
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.rds.get_orderable_db_instance(engine="mysql",
     *     license_model="general-public-license",
     *     preferred_engine_versions=[
     *         "5.6.35",
     *         "5.6.41",
     *         "5.6.44",
     *     ],
     *     preferred_instance_classes=[
     *         "db.t2.small",
     *         "db.t3.medium",
     *         "db.t3.large",
     *     ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Rds.GetOrderableDbInstance.Invoke(new()
     *     {
     *         Engine = "mysql",
     *         LicenseModel = "general-public-license",
     *         PreferredEngineVersions = new[]
     *         {
     *             "5.6.35",
     *             "5.6.41",
     *             "5.6.44",
     *         },
     *         PreferredInstanceClasses = new[]
     *         {
     *             "db.t2.small",
     *             "db.t3.medium",
     *             "db.t3.large",
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.GetOrderableDbInstance(ctx, &rds.GetOrderableDbInstanceArgs{
     * 			Engine:       "mysql",
     * 			LicenseModel: pulumi.StringRef("general-public-license"),
     * 			PreferredEngineVersions: []string{
     * 				"5.6.35",
     * 				"5.6.41",
     * 				"5.6.44",
     * 			},
     * 			PreferredInstanceClasses: []string{
     * 				"db.t2.small",
     * 				"db.t3.medium",
     * 				"db.t3.large",
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetOrderableDbInstanceArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = RdsFunctions.getOrderableDbInstance(GetOrderableDbInstanceArgs.builder()
     *             .engine("mysql")
     *             .licenseModel("general-public-license")
     *             .preferredEngineVersions(
     *                 "5.6.35",
     *                 "5.6.41",
     *                 "5.6.44")
     *             .preferredInstanceClasses(
     *                 "db.t2.small",
     *                 "db.t3.medium",
     *                 "db.t3.large")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:rds:getOrderableDbInstance
     *       Arguments:
     *         engine: mysql
     *         licenseModel: general-public-license
     *         preferredEngineVersions:
     *           - 5.6.35
     *           - 5.6.41
     *           - 5.6.44
     *         preferredInstanceClasses:
     *           - db.t2.small
     *           - db.t3.medium
     *           - db.t3.large
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getOrderableDbInstance.
     * @return A collection of values returned by getOrderableDbInstance.
     */
    public suspend fun getOrderableDbInstance(argument: GetOrderableDbInstancePlainArgs): GetOrderableDbInstanceResult =
        getOrderableDbInstanceResultToKotlin(getOrderableDbInstancePlain(argument.toJava()).await())

    /**
     * @see [getOrderableDbInstance].
     * @param availabilityZoneGroup Availability zone group.
     * @param engine DB engine. Engine values include `aurora`, `aurora-mysql`, `aurora-postgresql`, `docdb`, `mariadb`, `mysql`, `neptune`, `oracle-ee`, `oracle-se`, `oracle-se1`, `oracle-se2`, `postgres`, `sqlserver-ee`, `sqlserver-ex`, `sqlserver-se`, and `sqlserver-web`.
     * @param engineLatestVersion When set to `true`, the data source attempts to return the most recent version matching the other criteria you provide. You must use `engine_latest_version` with `preferred_instance_classes` and/or `preferred_engine_versions`. Using `engine_latest_version` will avoid `multiple RDS DB Instance Classes` errors. If you use `engine_latest_version` with `preferred_instance_classes`, the data source returns the latest version for the _first_ matching instance class (instance class priority). **Note:** The data source uses a best-effort approach at selecting the latest version but due to the complexity of version identifiers across engines, using `engine_latest_version` may _not_ return the latest version in every situation.
     * @param engineVersion Version of the DB engine. If none is provided, the data source tries to use the AWS-defined default version that matches any other criteria.
     * @param instanceClass DB instance class. Examples of classes are `db.m3.2xlarge`, `db.t2.small`, and `db.m3.medium`.
     * @param licenseModel License model. Examples of license models are `general-public-license`, `bring-your-own-license`, and `amazon-license`.
     * @param preferredEngineVersions Ordered list of preferred RDS DB instance engine versions. When `engine_latest_version` is not set, the data source will return the first match in this list that matches any other criteria. If the data source finds no preferred matches or multiple matches without `engine_latest_version`, it returns an error. **CAUTION:** We don't recommend using `preferred_engine_versions` without `preferred_instance_classes` since the data source returns an arbitrary `instance_class` based on the first one AWS returns that matches the engine version and any other criteria.
     * @param preferredInstanceClasses Ordered list of preferred RDS DB instance classes. The data source will return the first match in this list that matches any other criteria. If the data source finds no preferred matches or multiple matches without `engine_latest_version`, it returns an error. If you use `preferred_instance_classes` without `preferred_engine_versions` or `engine_latest_version`, the data source returns an arbitrary `engine_version` based on the first one AWS returns matching the instance class and any other criteria.
     * @param readReplicaCapable Whether a DB instance can have a read replica.
     * @param storageType Storage types. Examples of storage types are `standard`, `io1`, `gp2`, and `aurora`.
     * @param supportedEngineModes Use to limit results to engine modes such as `provisioned`.
     * @param supportedNetworkTypes Use to limit results to network types `IPV4` or `DUAL`.
     * @param supportsClusters Whether to limit results to instances that support clusters.
     * @param supportsEnhancedMonitoring Enable this to ensure a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
     * @param supportsGlobalDatabases Enable this to ensure a DB instance supports Aurora global databases with a specific combination of other DB engine attributes.
     * @param supportsIamDatabaseAuthentication Enable this to ensure a DB instance supports IAM database authentication.
     * @param supportsIops Enable this to ensure a DB instance supports provisioned IOPS.
     * @param supportsKerberosAuthentication Enable this to ensure a DB instance supports Kerberos Authentication.
     * @param supportsMultiAz Whether to limit results to instances that are multi-AZ capable.
     * @param supportsPerformanceInsights Enable this to ensure a DB instance supports Performance Insights.
     * @param supportsStorageAutoscaling Enable this to ensure Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.
     * @param supportsStorageEncryption Enable this to ensure a DB instance supports encrypted storage.
     * @param vpc Boolean that indicates whether to show only VPC or non-VPC offerings.
     * @return A collection of values returned by getOrderableDbInstance.
     */
    public suspend fun getOrderableDbInstance(
        availabilityZoneGroup: String? = null,
        engine: String,
        engineLatestVersion: Boolean? = null,
        engineVersion: String? = null,
        instanceClass: String? = null,
        licenseModel: String? = null,
        preferredEngineVersions: List<String>? = null,
        preferredInstanceClasses: List<String>? = null,
        readReplicaCapable: Boolean? = null,
        storageType: String? = null,
        supportedEngineModes: List<String>? = null,
        supportedNetworkTypes: List<String>? = null,
        supportsClusters: Boolean? = null,
        supportsEnhancedMonitoring: Boolean? = null,
        supportsGlobalDatabases: Boolean? = null,
        supportsIamDatabaseAuthentication: Boolean? = null,
        supportsIops: Boolean? = null,
        supportsKerberosAuthentication: Boolean? = null,
        supportsMultiAz: Boolean? = null,
        supportsPerformanceInsights: Boolean? = null,
        supportsStorageAutoscaling: Boolean? = null,
        supportsStorageEncryption: Boolean? = null,
        vpc: Boolean? = null,
    ): GetOrderableDbInstanceResult {
        val argument = GetOrderableDbInstancePlainArgs(
            availabilityZoneGroup = availabilityZoneGroup,
            engine = engine,
            engineLatestVersion = engineLatestVersion,
            engineVersion = engineVersion,
            instanceClass = instanceClass,
            licenseModel = licenseModel,
            preferredEngineVersions = preferredEngineVersions,
            preferredInstanceClasses = preferredInstanceClasses,
            readReplicaCapable = readReplicaCapable,
            storageType = storageType,
            supportedEngineModes = supportedEngineModes,
            supportedNetworkTypes = supportedNetworkTypes,
            supportsClusters = supportsClusters,
            supportsEnhancedMonitoring = supportsEnhancedMonitoring,
            supportsGlobalDatabases = supportsGlobalDatabases,
            supportsIamDatabaseAuthentication = supportsIamDatabaseAuthentication,
            supportsIops = supportsIops,
            supportsKerberosAuthentication = supportsKerberosAuthentication,
            supportsMultiAz = supportsMultiAz,
            supportsPerformanceInsights = supportsPerformanceInsights,
            supportsStorageAutoscaling = supportsStorageAutoscaling,
            supportsStorageEncryption = supportsStorageEncryption,
            vpc = vpc,
        )
        return getOrderableDbInstanceResultToKotlin(getOrderableDbInstancePlain(argument.toJava()).await())
    }

    /**
     * @see [getOrderableDbInstance].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetOrderableDbInstancePlainArgs].
     * @return A collection of values returned by getOrderableDbInstance.
     */
    public suspend fun getOrderableDbInstance(argument: suspend GetOrderableDbInstancePlainArgsBuilder.() -> Unit): GetOrderableDbInstanceResult {
        val builder = GetOrderableDbInstancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getOrderableDbInstanceResultToKotlin(getOrderableDbInstancePlain(builtArgument.toJava()).await())
    }

    /**
     * Information about a database parameter group.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.rds.getParameterGroup({
     *     name: "default.postgres15",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.rds.get_parameter_group(name="default.postgres15")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Rds.GetParameterGroup.Invoke(new()
     *     {
     *         Name = "default.postgres15",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.LookupParameterGroup(ctx, &rds.LookupParameterGroupArgs{
     * 			Name: "default.postgres15",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetParameterGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = RdsFunctions.getParameterGroup(GetParameterGroupArgs.builder()
     *             .name("default.postgres15")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:rds:getParameterGroup
     *       Arguments:
     *         name: default.postgres15
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getParameterGroup.
     * @return A collection of values returned by getParameterGroup.
     */
    public suspend fun getParameterGroup(argument: GetParameterGroupPlainArgs): GetParameterGroupResult =
        getParameterGroupResultToKotlin(getParameterGroupPlain(argument.toJava()).await())

    /**
     * @see [getParameterGroup].
     * @param name DB parameter group name.
     * @return A collection of values returned by getParameterGroup.
     */
    public suspend fun getParameterGroup(name: String): GetParameterGroupResult {
        val argument = GetParameterGroupPlainArgs(
            name = name,
        )
        return getParameterGroupResultToKotlin(getParameterGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getParameterGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetParameterGroupPlainArgs].
     * @return A collection of values returned by getParameterGroup.
     */
    public suspend fun getParameterGroup(argument: suspend GetParameterGroupPlainArgsBuilder.() -> Unit): GetParameterGroupResult {
        val builder = GetParameterGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getParameterGroupResultToKotlin(getParameterGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about a DB Proxy.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const proxy = aws.rds.getProxy({
     *     name: "my-test-db-proxy",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * proxy = aws.rds.get_proxy(name="my-test-db-proxy")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var proxy = Aws.Rds.GetProxy.Invoke(new()
     *     {
     *         Name = "my-test-db-proxy",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.LookupProxy(ctx, &rds.LookupProxyArgs{
     * 			Name: "my-test-db-proxy",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetProxyArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var proxy = RdsFunctions.getProxy(GetProxyArgs.builder()
     *             .name("my-test-db-proxy")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   proxy:
     *     fn::invoke:
     *       Function: aws:rds:getProxy
     *       Arguments:
     *         name: my-test-db-proxy
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getProxy.
     * @return A collection of values returned by getProxy.
     */
    public suspend fun getProxy(argument: GetProxyPlainArgs): GetProxyResult =
        getProxyResultToKotlin(getProxyPlain(argument.toJava()).await())

    /**
     * @see [getProxy].
     * @param name Name of the DB proxy.
     * @return A collection of values returned by getProxy.
     */
    public suspend fun getProxy(name: String): GetProxyResult {
        val argument = GetProxyPlainArgs(
            name = name,
        )
        return getProxyResultToKotlin(getProxyPlain(argument.toJava()).await())
    }

    /**
     * @see [getProxy].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetProxyPlainArgs].
     * @return A collection of values returned by getProxy.
     */
    public suspend fun getProxy(argument: suspend GetProxyPlainArgsBuilder.() -> Unit): GetProxyResult {
        val builder = GetProxyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getProxyResultToKotlin(getProxyPlain(builtArgument.toJava()).await())
    }

    /**
     * Information about a single RDS Reserved Instance Offering.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const test = aws.rds.getReservedInstanceOffering({
     *     dbInstanceClass: "db.t2.micro",
     *     duration: 31536000,
     *     multiAz: false,
     *     offeringType: "All Upfront",
     *     productDescription: "mysql",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * test = aws.rds.get_reserved_instance_offering(db_instance_class="db.t2.micro",
     *     duration=31536000,
     *     multi_az=False,
     *     offering_type="All Upfront",
     *     product_description="mysql")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var test = Aws.Rds.GetReservedInstanceOffering.Invoke(new()
     *     {
     *         DbInstanceClass = "db.t2.micro",
     *         Duration = 31536000,
     *         MultiAz = false,
     *         OfferingType = "All Upfront",
     *         ProductDescription = "mysql",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.GetReservedInstanceOffering(ctx, &rds.GetReservedInstanceOfferingArgs{
     * 			DbInstanceClass:    "db.t2.micro",
     * 			Duration:           31536000,
     * 			MultiAz:            false,
     * 			OfferingType:       "All Upfront",
     * 			ProductDescription: "mysql",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetReservedInstanceOfferingArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var test = RdsFunctions.getReservedInstanceOffering(GetReservedInstanceOfferingArgs.builder()
     *             .dbInstanceClass("db.t2.micro")
     *             .duration(31536000)
     *             .multiAz(false)
     *             .offeringType("All Upfront")
     *             .productDescription("mysql")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   test:
     *     fn::invoke:
     *       Function: aws:rds:getReservedInstanceOffering
     *       Arguments:
     *         dbInstanceClass: db.t2.micro
     *         duration: 3.1536e+07
     *         multiAz: false
     *         offeringType: All Upfront
     *         productDescription: mysql
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getReservedInstanceOffering.
     * @return A collection of values returned by getReservedInstanceOffering.
     */
    public suspend fun getReservedInstanceOffering(argument: GetReservedInstanceOfferingPlainArgs): GetReservedInstanceOfferingResult =
        getReservedInstanceOfferingResultToKotlin(getReservedInstanceOfferingPlain(argument.toJava()).await())

    /**
     * @see [getReservedInstanceOffering].
     * @param dbInstanceClass DB instance class for the reserved DB instance.
     * @param duration Duration of the reservation in years or seconds. Valid values are `1`, `3`, `31536000`, `94608000`
     * @param multiAz Whether the reservation applies to Multi-AZ deployments.
     * @param offeringType Offering type of this reserved DB instance. Valid values are `No Upfront`, `Partial Upfront`, `All Upfront`.
     * @param productDescription Description of the reserved DB instance.
     * @return A collection of values returned by getReservedInstanceOffering.
     */
    public suspend fun getReservedInstanceOffering(
        dbInstanceClass: String,
        duration: Int,
        multiAz: Boolean,
        offeringType: String,
        productDescription: String,
    ): GetReservedInstanceOfferingResult {
        val argument = GetReservedInstanceOfferingPlainArgs(
            dbInstanceClass = dbInstanceClass,
            duration = duration,
            multiAz = multiAz,
            offeringType = offeringType,
            productDescription = productDescription,
        )
        return getReservedInstanceOfferingResultToKotlin(getReservedInstanceOfferingPlain(argument.toJava()).await())
    }

    /**
     * @see [getReservedInstanceOffering].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetReservedInstanceOfferingPlainArgs].
     * @return A collection of values returned by getReservedInstanceOffering.
     */
    public suspend fun getReservedInstanceOffering(argument: suspend GetReservedInstanceOfferingPlainArgsBuilder.() -> Unit): GetReservedInstanceOfferingResult {
        val builder = GetReservedInstanceOfferingPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getReservedInstanceOfferingResultToKotlin(getReservedInstanceOfferingPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about a DB Snapshot for use when provisioning DB instances
     * > **NOTE:** This data source does not apply to snapshots created on Aurora DB clusters.
     * See the `aws.rds.ClusterSnapshot` data source for DB Cluster snapshots.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const prod = new aws.rds.Instance("prod", {
     *     allocatedStorage: 10,
     *     engine: "mysql",
     *     engineVersion: "5.6.17",
     *     instanceClass: aws.rds.InstanceType.T2_Micro,
     *     dbName: "mydb",
     *     username: "foo",
     *     password: "bar",
     *     dbSubnetGroupName: "my_database_subnet_group",
     *     parameterGroupName: "default.mysql5.6",
     * });
     * const latestProdSnapshot = aws.rds.getSnapshotOutput({
     *     dbInstanceIdentifier: prod.identifier,
     *     mostRecent: true,
     * });
     * // Use the latest production snapshot to create a dev instance.
     * const dev = new aws.rds.Instance("dev", {
     *     instanceClass: aws.rds.InstanceType.T2_Micro,
     *     dbName: "mydbdev",
     *     snapshotIdentifier: latestProdSnapshot.apply(latestProdSnapshot => latestProdSnapshot.id),
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * prod = aws.rds.Instance("prod",
     *     allocated_storage=10,
     *     engine="mysql",
     *     engine_version="5.6.17",
     *     instance_class=aws.rds.InstanceType.T2_MICRO,
     *     db_name="mydb",
     *     username="foo",
     *     password="bar",
     *     db_subnet_group_name="my_database_subnet_group",
     *     parameter_group_name="default.mysql5.6")
     * latest_prod_snapshot = aws.rds.get_snapshot_output(db_instance_identifier=prod.identifier,
     *     most_recent=True)
     * # Use the latest production snapshot to create a dev instance.
     * dev = aws.rds.Instance("dev",
     *     instance_class=aws.rds.InstanceType.T2_MICRO,
     *     db_name="mydbdev",
     *     snapshot_identifier=latest_prod_snapshot.id)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var prod = new Aws.Rds.Instance("prod", new()
     *     {
     *         AllocatedStorage = 10,
     *         Engine = "mysql",
     *         EngineVersion = "5.6.17",
     *         InstanceClass = Aws.Rds.InstanceType.T2_Micro,
     *         DbName = "mydb",
     *         Username = "foo",
     *         Password = "bar",
     *         DbSubnetGroupName = "my_database_subnet_group",
     *         ParameterGroupName = "default.mysql5.6",
     *     });
     *     var latestProdSnapshot = Aws.Rds.GetSnapshot.Invoke(new()
     *     {
     *         DbInstanceIdentifier = prod.Identifier,
     *         MostRecent = true,
     *     });
     *     // Use the latest production snapshot to create a dev instance.
     *     var dev = new Aws.Rds.Instance("dev", new()
     *     {
     *         InstanceClass = Aws.Rds.InstanceType.T2_Micro,
     *         DbName = "mydbdev",
     *         SnapshotIdentifier = latestProdSnapshot.Apply(getSnapshotResult => getSnapshotResult.Id),
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		prod, err := rds.NewInstance(ctx, "prod", &rds.InstanceArgs{
     * 			AllocatedStorage:   pulumi.Int(10),
     * 			Engine:             pulumi.String("mysql"),
     * 			EngineVersion:      pulumi.String("5.6.17"),
     * 			InstanceClass:      pulumi.String(rds.InstanceType_T2_Micro),
     * 			DbName:             pulumi.String("mydb"),
     * 			Username:           pulumi.String("foo"),
     * 			Password:           pulumi.String("bar"),
     * 			DbSubnetGroupName:  pulumi.String("my_database_subnet_group"),
     * 			ParameterGroupName: pulumi.String("default.mysql5.6"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		latestProdSnapshot := rds.LookupSnapshotOutput(ctx, rds.GetSnapshotOutputArgs{
     * 			DbInstanceIdentifier: prod.Identifier,
     * 			MostRecent:           pulumi.Bool(true),
     * 		}, nil)
     * 		// Use the latest production snapshot to create a dev instance.
     * 		_, err = rds.NewInstance(ctx, "dev", &rds.InstanceArgs{
     * 			InstanceClass: pulumi.String(rds.InstanceType_T2_Micro),
     * 			DbName:        pulumi.String("mydbdev"),
     * 			SnapshotIdentifier: pulumi.String(latestProdSnapshot.ApplyT(func(latestProdSnapshot rds.GetSnapshotResult) (*string, error) {
     * 				return &latestProdSnapshot.Id, nil
     * 			}).(pulumi.StringPtrOutput)),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.Instance;
     * import com.pulumi.aws.rds.InstanceArgs;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetSnapshotArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         var prod = new Instance("prod", InstanceArgs.builder()
     *             .allocatedStorage(10)
     *             .engine("mysql")
     *             .engineVersion("5.6.17")
     *             .instanceClass("db.t2.micro")
     *             .dbName("mydb")
     *             .username("foo")
     *             .password("bar")
     *             .dbSubnetGroupName("my_database_subnet_group")
     *             .parameterGroupName("default.mysql5.6")
     *             .build());
     *         final var latestProdSnapshot = RdsFunctions.getSnapshot(GetSnapshotArgs.builder()
     *             .dbInstanceIdentifier(prod.identifier())
     *             .mostRecent(true)
     *             .build());
     *         // Use the latest production snapshot to create a dev instance.
     *         var dev = new Instance("dev", InstanceArgs.builder()
     *             .instanceClass("db.t2.micro")
     *             .dbName("mydbdev")
     *             .snapshotIdentifier(latestProdSnapshot.applyValue(getSnapshotResult -> getSnapshotResult).applyValue(latestProdSnapshot -> latestProdSnapshot.applyValue(getSnapshotResult -> getSnapshotResult.id())))
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   prod:
     *     type: aws:rds:Instance
     *     properties:
     *       allocatedStorage: 10
     *       engine: mysql
     *       engineVersion: 5.6.17
     *       instanceClass: db.t2.micro
     *       dbName: mydb
     *       username: foo
     *       password: bar
     *       dbSubnetGroupName: my_database_subnet_group
     *       parameterGroupName: default.mysql5.6
     *   # Use the latest production snapshot to create a dev instance.
     *   dev:
     *     type: aws:rds:Instance
     *     properties:
     *       instanceClass: db.t2.micro
     *       dbName: mydbdev
     *       snapshotIdentifier: ${latestProdSnapshot.id}
     * variables:
     *   latestProdSnapshot:
     *     fn::invoke:
     *       Function: aws:rds:getSnapshot
     *       Arguments:
     *         dbInstanceIdentifier: ${prod.identifier}
     *         mostRecent: true
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSnapshot.
     * @return A collection of values returned by getSnapshot.
     */
    public suspend fun getSnapshot(argument: GetSnapshotPlainArgs): GetSnapshotResult =
        getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())

    /**
     * @see [getSnapshot].
     * @param dbInstanceIdentifier Returns the list of snapshots created by the specific db_instance
     * @param dbSnapshotIdentifier Returns information on a specific snapshot_id.
     * @param includePublic Set this value to true to include manual DB snapshots that are public and can be
     * copied or restored by any AWS account, otherwise set this value to false. The default is `false`.
     * @param includeShared Set this value to true to include shared manual DB snapshots from other
     * AWS accounts that this AWS account has been given permission to copy or restore, otherwise set this value to false.
     * The default is `false`.
     * @param mostRecent If more than one result is returned, use the most
     * recent Snapshot.
     * @param snapshotType Type of snapshots to be returned. If you don't specify a SnapshotType
     * value, then both automated and manual snapshots are returned. Shared and public DB snapshots are not
     * included in the returned results by default. Possible values are, `automated`, `manual`, `shared`, `public` and `awsbackup`.
     * @param tags Mapping of tags, each pair of which must exactly match
     * a pair on the desired DB snapshot.
     * @return A collection of values returned by getSnapshot.
     */
    public suspend fun getSnapshot(
        dbInstanceIdentifier: String? = null,
        dbSnapshotIdentifier: String? = null,
        includePublic: Boolean? = null,
        includeShared: Boolean? = null,
        mostRecent: Boolean? = null,
        snapshotType: String? = null,
        tags: Map<String, String>? = null,
    ): GetSnapshotResult {
        val argument = GetSnapshotPlainArgs(
            dbInstanceIdentifier = dbInstanceIdentifier,
            dbSnapshotIdentifier = dbSnapshotIdentifier,
            includePublic = includePublic,
            includeShared = includeShared,
            mostRecent = mostRecent,
            snapshotType = snapshotType,
            tags = tags,
        )
        return getSnapshotResultToKotlin(getSnapshotPlain(argument.toJava()).await())
    }

    /**
     * @see [getSnapshot].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetSnapshotPlainArgs].
     * @return A collection of values returned by getSnapshot.
     */
    public suspend fun getSnapshot(argument: suspend GetSnapshotPlainArgsBuilder.() -> Unit): GetSnapshotResult {
        val builder = GetSnapshotPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSnapshotResultToKotlin(getSnapshotPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information about an RDS subnet group.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const database = aws.rds.getSubnetGroup({
     *     name: "my-test-database-subnet-group",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * database = aws.rds.get_subnet_group(name="my-test-database-subnet-group")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var database = Aws.Rds.GetSubnetGroup.Invoke(new()
     *     {
     *         Name = "my-test-database-subnet-group",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := rds.LookupSubnetGroup(ctx, &rds.LookupSubnetGroupArgs{
     * 			Name: "my-test-database-subnet-group",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.rds.RdsFunctions;
     * import com.pulumi.aws.rds.inputs.GetSubnetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var database = RdsFunctions.getSubnetGroup(GetSubnetGroupArgs.builder()
     *             .name("my-test-database-subnet-group")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   database:
     *     fn::invoke:
     *       Function: aws:rds:getSubnetGroup
     *       Arguments:
     *         name: my-test-database-subnet-group
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getSubnetGroup.
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(argument: GetSubnetGroupPlainArgs): GetSubnetGroupResult =
        getSubnetGroupResultToKotlin(getSubnetGroupPlain(argument.toJava()).await())

    /**
     * @see [getSubnetGroup].
     * @param name Name of the RDS database subnet group.
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(name: String): GetSubnetGroupResult {
        val argument = GetSubnetGroupPlainArgs(
            name = name,
        )
        return getSubnetGroupResultToKotlin(getSubnetGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getSubnetGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;rds&#46;kotlin&#46;inputs&#46;GetSubnetGroupPlainArgs].
     * @return A collection of values returned by getSubnetGroup.
     */
    public suspend fun getSubnetGroup(argument: suspend GetSubnetGroupPlainArgsBuilder.() -> Unit): GetSubnetGroupResult {
        val builder = GetSubnetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSubnetGroupResultToKotlin(getSubnetGroupPlain(builtArgument.toJava()).await())
    }
}
