@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.SnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an RDS database instance snapshot. For managing RDS database cluster snapshots, see the `aws.rds.ClusterSnapshot` resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const bar = new aws.rds.Instance("bar", {
 *     allocatedStorage: 10,
 *     engine: "mysql",
 *     engineVersion: "5.6.21",
 *     instanceClass: aws.rds.InstanceType.T2_Micro,
 *     dbName: "baz",
 *     password: "barbarbarbar",
 *     username: "foo",
 *     maintenanceWindow: "Fri:09:00-Fri:09:30",
 *     backupRetentionPeriod: 0,
 *     parameterGroupName: "default.mysql5.6",
 * });
 * const test = new aws.rds.Snapshot("test", {
 *     dbInstanceIdentifier: bar.identifier,
 *     dbSnapshotIdentifier: "testsnapshot1234",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * bar = aws.rds.Instance("bar",
 *     allocated_storage=10,
 *     engine="mysql",
 *     engine_version="5.6.21",
 *     instance_class=aws.rds.InstanceType.T2_MICRO,
 *     db_name="baz",
 *     password="barbarbarbar",
 *     username="foo",
 *     maintenance_window="Fri:09:00-Fri:09:30",
 *     backup_retention_period=0,
 *     parameter_group_name="default.mysql5.6")
 * test = aws.rds.Snapshot("test",
 *     db_instance_identifier=bar.identifier,
 *     db_snapshot_identifier="testsnapshot1234")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bar = new Aws.Rds.Instance("bar", new()
 *     {
 *         AllocatedStorage = 10,
 *         Engine = "mysql",
 *         EngineVersion = "5.6.21",
 *         InstanceClass = Aws.Rds.InstanceType.T2_Micro,
 *         DbName = "baz",
 *         Password = "barbarbarbar",
 *         Username = "foo",
 *         MaintenanceWindow = "Fri:09:00-Fri:09:30",
 *         BackupRetentionPeriod = 0,
 *         ParameterGroupName = "default.mysql5.6",
 *     });
 *     var test = new Aws.Rds.Snapshot("test", new()
 *     {
 *         DbInstanceIdentifier = bar.Identifier,
 *         DbSnapshotIdentifier = "testsnapshot1234",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		bar, err := rds.NewInstance(ctx, "bar", &rds.InstanceArgs{
 * 			AllocatedStorage:      pulumi.Int(10),
 * 			Engine:                pulumi.String("mysql"),
 * 			EngineVersion:         pulumi.String("5.6.21"),
 * 			InstanceClass:         pulumi.String(rds.InstanceType_T2_Micro),
 * 			DbName:                pulumi.String("baz"),
 * 			Password:              pulumi.String("barbarbarbar"),
 * 			Username:              pulumi.String("foo"),
 * 			MaintenanceWindow:     pulumi.String("Fri:09:00-Fri:09:30"),
 * 			BackupRetentionPeriod: pulumi.Int(0),
 * 			ParameterGroupName:    pulumi.String("default.mysql5.6"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewSnapshot(ctx, "test", &rds.SnapshotArgs{
 * 			DbInstanceIdentifier: bar.Identifier,
 * 			DbSnapshotIdentifier: pulumi.String("testsnapshot1234"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import com.pulumi.aws.rds.Snapshot;
 * import com.pulumi.aws.rds.SnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bar = new Instance("bar", InstanceArgs.builder()
 *             .allocatedStorage(10)
 *             .engine("mysql")
 *             .engineVersion("5.6.21")
 *             .instanceClass("db.t2.micro")
 *             .dbName("baz")
 *             .password("barbarbarbar")
 *             .username("foo")
 *             .maintenanceWindow("Fri:09:00-Fri:09:30")
 *             .backupRetentionPeriod(0)
 *             .parameterGroupName("default.mysql5.6")
 *             .build());
 *         var test = new Snapshot("test", SnapshotArgs.builder()
 *             .dbInstanceIdentifier(bar.identifier())
 *             .dbSnapshotIdentifier("testsnapshot1234")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   bar:
 *     type: aws:rds:Instance
 *     properties:
 *       allocatedStorage: 10
 *       engine: mysql
 *       engineVersion: 5.6.21
 *       instanceClass: db.t2.micro
 *       dbName: baz
 *       password: barbarbarbar
 *       username: foo
 *       maintenanceWindow: Fri:09:00-Fri:09:30
 *       backupRetentionPeriod: 0
 *       parameterGroupName: default.mysql5.6
 *   test:
 *     type: aws:rds:Snapshot
 *     properties:
 *       dbInstanceIdentifier: ${bar.identifier}
 *       dbSnapshotIdentifier: testsnapshot1234
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_db_snapshot` using the snapshot identifier. For example:
 * ```sh
 * $ pulumi import aws:rds/snapshot:Snapshot example my-snapshot
 * ```
 * @property dbInstanceIdentifier The DB Instance Identifier from which to take the snapshot.
 * @property dbSnapshotIdentifier The Identifier for the snapshot.
 * @property sharedAccounts List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class SnapshotArgs(
    public val dbInstanceIdentifier: Output<String>? = null,
    public val dbSnapshotIdentifier: Output<String>? = null,
    public val sharedAccounts: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.SnapshotArgs> {
    override fun toJava(): com.pulumi.aws.rds.SnapshotArgs = com.pulumi.aws.rds.SnapshotArgs.builder()
        .dbInstanceIdentifier(dbInstanceIdentifier?.applyValue({ args0 -> args0 }))
        .dbSnapshotIdentifier(dbSnapshotIdentifier?.applyValue({ args0 -> args0 }))
        .sharedAccounts(sharedAccounts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [SnapshotArgs].
 */
@PulumiTagMarker
public class SnapshotArgsBuilder internal constructor() {
    private var dbInstanceIdentifier: Output<String>? = null

    private var dbSnapshotIdentifier: Output<String>? = null

    private var sharedAccounts: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The DB Instance Identifier from which to take the snapshot.
     */
    @JvmName("dqpmtnupwisgaadh")
    public suspend fun dbInstanceIdentifier(`value`: Output<String>) {
        this.dbInstanceIdentifier = value
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("wppymuapjjmttalt")
    public suspend fun dbSnapshotIdentifier(`value`: Output<String>) {
        this.dbSnapshotIdentifier = value
    }

    /**
     * @param value List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("tnmtynvrvnimnkbx")
    public suspend fun sharedAccounts(`value`: Output<List<String>>) {
        this.sharedAccounts = value
    }

    @JvmName("ommacburivemjmkv")
    public suspend fun sharedAccounts(vararg values: Output<String>) {
        this.sharedAccounts = Output.all(values.asList())
    }

    /**
     * @param values List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("ijtpnifsrraejytf")
    public suspend fun sharedAccounts(values: List<Output<String>>) {
        this.sharedAccounts = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ahvxckwlgisuhvwl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The DB Instance Identifier from which to take the snapshot.
     */
    @JvmName("ehhgoigwaifhpqch")
    public suspend fun dbInstanceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbInstanceIdentifier = mapped
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("hlxqilwhvyqoqvod")
    public suspend fun dbSnapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dbSnapshotIdentifier = mapped
    }

    /**
     * @param value List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("xyhmhqysexjbedfw")
    public suspend fun sharedAccounts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccounts = mapped
    }

    /**
     * @param values List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("tjowaidmhgcbfokf")
    public suspend fun sharedAccounts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sharedAccounts = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gdgsstaqywbaiypd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mtkabiuedmfjlcxj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SnapshotArgs = SnapshotArgs(
        dbInstanceIdentifier = dbInstanceIdentifier,
        dbSnapshotIdentifier = dbSnapshotIdentifier,
        sharedAccounts = sharedAccounts,
        tags = tags,
    )
}
