@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin

import com.pulumi.aws.rds.SnapshotCopyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an RDS database instance snapshot copy. For managing RDS database cluster snapshots, see the `aws.rds.ClusterSnapshot` resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.rds.Instance("example", {
 *     allocatedStorage: 10,
 *     engine: "mysql",
 *     engineVersion: "5.6.21",
 *     instanceClass: aws.rds.InstanceType.T2_Micro,
 *     dbName: "baz",
 *     password: "barbarbarbar",
 *     username: "foo",
 *     maintenanceWindow: "Fri:09:00-Fri:09:30",
 *     backupRetentionPeriod: 0,
 *     parameterGroupName: "default.mysql5.6",
 * });
 * const exampleSnapshot = new aws.rds.Snapshot("example", {
 *     dbInstanceIdentifier: example.identifier,
 *     dbSnapshotIdentifier: "testsnapshot1234",
 * });
 * const exampleSnapshotCopy = new aws.rds.SnapshotCopy("example", {
 *     sourceDbSnapshotIdentifier: exampleSnapshot.dbSnapshotArn,
 *     targetDbSnapshotIdentifier: "testsnapshot1234-copy",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.rds.Instance("example",
 *     allocated_storage=10,
 *     engine="mysql",
 *     engine_version="5.6.21",
 *     instance_class=aws.rds.InstanceType.T2_MICRO,
 *     db_name="baz",
 *     password="barbarbarbar",
 *     username="foo",
 *     maintenance_window="Fri:09:00-Fri:09:30",
 *     backup_retention_period=0,
 *     parameter_group_name="default.mysql5.6")
 * example_snapshot = aws.rds.Snapshot("example",
 *     db_instance_identifier=example.identifier,
 *     db_snapshot_identifier="testsnapshot1234")
 * example_snapshot_copy = aws.rds.SnapshotCopy("example",
 *     source_db_snapshot_identifier=example_snapshot.db_snapshot_arn,
 *     target_db_snapshot_identifier="testsnapshot1234-copy")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Rds.Instance("example", new()
 *     {
 *         AllocatedStorage = 10,
 *         Engine = "mysql",
 *         EngineVersion = "5.6.21",
 *         InstanceClass = Aws.Rds.InstanceType.T2_Micro,
 *         DbName = "baz",
 *         Password = "barbarbarbar",
 *         Username = "foo",
 *         MaintenanceWindow = "Fri:09:00-Fri:09:30",
 *         BackupRetentionPeriod = 0,
 *         ParameterGroupName = "default.mysql5.6",
 *     });
 *     var exampleSnapshot = new Aws.Rds.Snapshot("example", new()
 *     {
 *         DbInstanceIdentifier = example.Identifier,
 *         DbSnapshotIdentifier = "testsnapshot1234",
 *     });
 *     var exampleSnapshotCopy = new Aws.Rds.SnapshotCopy("example", new()
 *     {
 *         SourceDbSnapshotIdentifier = exampleSnapshot.DbSnapshotArn,
 *         TargetDbSnapshotIdentifier = "testsnapshot1234-copy",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/rds"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := rds.NewInstance(ctx, "example", &rds.InstanceArgs{
 * 			AllocatedStorage:      pulumi.Int(10),
 * 			Engine:                pulumi.String("mysql"),
 * 			EngineVersion:         pulumi.String("5.6.21"),
 * 			InstanceClass:         pulumi.String(rds.InstanceType_T2_Micro),
 * 			DbName:                pulumi.String("baz"),
 * 			Password:              pulumi.String("barbarbarbar"),
 * 			Username:              pulumi.String("foo"),
 * 			MaintenanceWindow:     pulumi.String("Fri:09:00-Fri:09:30"),
 * 			BackupRetentionPeriod: pulumi.Int(0),
 * 			ParameterGroupName:    pulumi.String("default.mysql5.6"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleSnapshot, err := rds.NewSnapshot(ctx, "example", &rds.SnapshotArgs{
 * 			DbInstanceIdentifier: example.Identifier,
 * 			DbSnapshotIdentifier: pulumi.String("testsnapshot1234"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = rds.NewSnapshotCopy(ctx, "example", &rds.SnapshotCopyArgs{
 * 			SourceDbSnapshotIdentifier: exampleSnapshot.DbSnapshotArn,
 * 			TargetDbSnapshotIdentifier: pulumi.String("testsnapshot1234-copy"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.rds.Instance;
 * import com.pulumi.aws.rds.InstanceArgs;
 * import com.pulumi.aws.rds.Snapshot;
 * import com.pulumi.aws.rds.SnapshotArgs;
 * import com.pulumi.aws.rds.SnapshotCopy;
 * import com.pulumi.aws.rds.SnapshotCopyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Instance("example", InstanceArgs.builder()
 *             .allocatedStorage(10)
 *             .engine("mysql")
 *             .engineVersion("5.6.21")
 *             .instanceClass("db.t2.micro")
 *             .dbName("baz")
 *             .password("barbarbarbar")
 *             .username("foo")
 *             .maintenanceWindow("Fri:09:00-Fri:09:30")
 *             .backupRetentionPeriod(0)
 *             .parameterGroupName("default.mysql5.6")
 *             .build());
 *         var exampleSnapshot = new Snapshot("exampleSnapshot", SnapshotArgs.builder()
 *             .dbInstanceIdentifier(example.identifier())
 *             .dbSnapshotIdentifier("testsnapshot1234")
 *             .build());
 *         var exampleSnapshotCopy = new SnapshotCopy("exampleSnapshotCopy", SnapshotCopyArgs.builder()
 *             .sourceDbSnapshotIdentifier(exampleSnapshot.dbSnapshotArn())
 *             .targetDbSnapshotIdentifier("testsnapshot1234-copy")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:rds:Instance
 *     properties:
 *       allocatedStorage: 10
 *       engine: mysql
 *       engineVersion: 5.6.21
 *       instanceClass: db.t2.micro
 *       dbName: baz
 *       password: barbarbarbar
 *       username: foo
 *       maintenanceWindow: Fri:09:00-Fri:09:30
 *       backupRetentionPeriod: 0
 *       parameterGroupName: default.mysql5.6
 *   exampleSnapshot:
 *     type: aws:rds:Snapshot
 *     name: example
 *     properties:
 *       dbInstanceIdentifier: ${example.identifier}
 *       dbSnapshotIdentifier: testsnapshot1234
 *   exampleSnapshotCopy:
 *     type: aws:rds:SnapshotCopy
 *     name: example
 *     properties:
 *       sourceDbSnapshotIdentifier: ${exampleSnapshot.dbSnapshotArn}
 *       targetDbSnapshotIdentifier: testsnapshot1234-copy
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_db_snapshot_copy` using the snapshot identifier. For example:
 * ```sh
 * $ pulumi import aws:rds/snapshotCopy:SnapshotCopy example my-snapshot
 * ```
 * @property copyTags Whether to copy existing tags. Defaults to `false`.
 * @property destinationRegion The Destination region to place snapshot copy.
 * @property kmsKeyId KMS key ID.
 * @property optionGroupName The name of an option group to associate with the copy of the snapshot.
 * @property presignedUrl he URL that contains a Signature Version 4 signed request.
 * @property sharedAccounts (Optional) List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
 * @property sourceDbSnapshotIdentifier Snapshot identifier of the source snapshot.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property targetCustomAvailabilityZone The external custom Availability Zone.
 * @property targetDbSnapshotIdentifier The Identifier for the snapshot.
 */
public data class SnapshotCopyArgs(
    public val copyTags: Output<Boolean>? = null,
    public val destinationRegion: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val optionGroupName: Output<String>? = null,
    public val presignedUrl: Output<String>? = null,
    public val sharedAccounts: Output<List<String>>? = null,
    public val sourceDbSnapshotIdentifier: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetCustomAvailabilityZone: Output<String>? = null,
    public val targetDbSnapshotIdentifier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.SnapshotCopyArgs> {
    override fun toJava(): com.pulumi.aws.rds.SnapshotCopyArgs =
        com.pulumi.aws.rds.SnapshotCopyArgs.builder()
            .copyTags(copyTags?.applyValue({ args0 -> args0 }))
            .destinationRegion(destinationRegion?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .optionGroupName(optionGroupName?.applyValue({ args0 -> args0 }))
            .presignedUrl(presignedUrl?.applyValue({ args0 -> args0 }))
            .sharedAccounts(sharedAccounts?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .sourceDbSnapshotIdentifier(sourceDbSnapshotIdentifier?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetCustomAvailabilityZone(targetCustomAvailabilityZone?.applyValue({ args0 -> args0 }))
            .targetDbSnapshotIdentifier(targetDbSnapshotIdentifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SnapshotCopyArgs].
 */
@PulumiTagMarker
public class SnapshotCopyArgsBuilder internal constructor() {
    private var copyTags: Output<Boolean>? = null

    private var destinationRegion: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var optionGroupName: Output<String>? = null

    private var presignedUrl: Output<String>? = null

    private var sharedAccounts: Output<List<String>>? = null

    private var sourceDbSnapshotIdentifier: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetCustomAvailabilityZone: Output<String>? = null

    private var targetDbSnapshotIdentifier: Output<String>? = null

    /**
     * @param value Whether to copy existing tags. Defaults to `false`.
     */
    @JvmName("ajxsfsgmhnppsueg")
    public suspend fun copyTags(`value`: Output<Boolean>) {
        this.copyTags = value
    }

    /**
     * @param value The Destination region to place snapshot copy.
     */
    @JvmName("pyikhjvobrhygawp")
    public suspend fun destinationRegion(`value`: Output<String>) {
        this.destinationRegion = value
    }

    /**
     * @param value KMS key ID.
     */
    @JvmName("eimwywvfqgimbmdi")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The name of an option group to associate with the copy of the snapshot.
     */
    @JvmName("kjbaomdyuiunpslq")
    public suspend fun optionGroupName(`value`: Output<String>) {
        this.optionGroupName = value
    }

    /**
     * @param value he URL that contains a Signature Version 4 signed request.
     */
    @JvmName("prwojsvthtvfujwy")
    public suspend fun presignedUrl(`value`: Output<String>) {
        this.presignedUrl = value
    }

    /**
     * @param value (Optional) List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("eatgcsqlwioalwbf")
    public suspend fun sharedAccounts(`value`: Output<List<String>>) {
        this.sharedAccounts = value
    }

    @JvmName("shvkgnsgnhfgoaoe")
    public suspend fun sharedAccounts(vararg values: Output<String>) {
        this.sharedAccounts = Output.all(values.asList())
    }

    /**
     * @param values (Optional) List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("hjpjjytfyclxatfn")
    public suspend fun sharedAccounts(values: List<Output<String>>) {
        this.sharedAccounts = Output.all(values)
    }

    /**
     * @param value Snapshot identifier of the source snapshot.
     */
    @JvmName("bqrmuugbrtfolsgt")
    public suspend fun sourceDbSnapshotIdentifier(`value`: Output<String>) {
        this.sourceDbSnapshotIdentifier = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("fpnvxmqffebhocsq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The external custom Availability Zone.
     */
    @JvmName("ghafcjinixmpqgou")
    public suspend fun targetCustomAvailabilityZone(`value`: Output<String>) {
        this.targetCustomAvailabilityZone = value
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("krmjxjfmxxpnfbxg")
    public suspend fun targetDbSnapshotIdentifier(`value`: Output<String>) {
        this.targetDbSnapshotIdentifier = value
    }

    /**
     * @param value Whether to copy existing tags. Defaults to `false`.
     */
    @JvmName("vqjoeqhgxtnnqvho")
    public suspend fun copyTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTags = mapped
    }

    /**
     * @param value The Destination region to place snapshot copy.
     */
    @JvmName("jpoxagjtoyxcmphm")
    public suspend fun destinationRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationRegion = mapped
    }

    /**
     * @param value KMS key ID.
     */
    @JvmName("dadlpgqhsgeniipo")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The name of an option group to associate with the copy of the snapshot.
     */
    @JvmName("uqotviqlmrkbygxf")
    public suspend fun optionGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optionGroupName = mapped
    }

    /**
     * @param value he URL that contains a Signature Version 4 signed request.
     */
    @JvmName("dknksekhppemtcnh")
    public suspend fun presignedUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.presignedUrl = mapped
    }

    /**
     * @param value (Optional) List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("vpcngnxqfafgsryj")
    public suspend fun sharedAccounts(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharedAccounts = mapped
    }

    /**
     * @param values (Optional) List of AWS Account ids to share snapshot with, use `all` to make snaphot public.
     */
    @JvmName("kmpvfgkuhrkapukq")
    public suspend fun sharedAccounts(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sharedAccounts = mapped
    }

    /**
     * @param value Snapshot identifier of the source snapshot.
     */
    @JvmName("nbjrlfnqbdgporsh")
    public suspend fun sourceDbSnapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDbSnapshotIdentifier = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("evrfyeefcvjwsikf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("axuiuqwyylhjhspt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The external custom Availability Zone.
     */
    @JvmName("htkeaqhmcofnoshg")
    public suspend fun targetCustomAvailabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetCustomAvailabilityZone = mapped
    }

    /**
     * @param value The Identifier for the snapshot.
     */
    @JvmName("gpmcmnppbrfuycil")
    public suspend fun targetDbSnapshotIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDbSnapshotIdentifier = mapped
    }

    internal fun build(): SnapshotCopyArgs = SnapshotCopyArgs(
        copyTags = copyTags,
        destinationRegion = destinationRegion,
        kmsKeyId = kmsKeyId,
        optionGroupName = optionGroupName,
        presignedUrl = presignedUrl,
        sharedAccounts = sharedAccounts,
        sourceDbSnapshotIdentifier = sourceDbSnapshotIdentifier,
        tags = tags,
        targetCustomAvailabilityZone = targetCustomAvailabilityZone,
        targetDbSnapshotIdentifier = targetDbSnapshotIdentifier,
    )
}
