@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.ClusterScalingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property autoPause Whether to enable automatic pause. A DB cluster can be paused only when it's idle (it has no connections). If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. Defaults to `true`.
 * @property maxCapacity Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
 * @property minCapacity Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
 * @property secondsBeforeTimeout Amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. Valid values are `60` through `600`. Defaults to `300`.
 * @property secondsUntilAutoPause Time, in seconds, before an Aurora DB cluster in serverless mode is paused. Valid values are `300` through `86400`. Defaults to `300`.
 * @property timeoutAction Action to take when the timeout is reached. Valid values: `ForceApplyCapacityChange`, `RollbackCapacityChange`. Defaults to `RollbackCapacityChange`. See [documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v1.how-it-works.html#aurora-serverless.how-it-works.timeout-action).
 */
public data class ClusterScalingConfigurationArgs(
    public val autoPause: Output<Boolean>? = null,
    public val maxCapacity: Output<Int>? = null,
    public val minCapacity: Output<Int>? = null,
    public val secondsBeforeTimeout: Output<Int>? = null,
    public val secondsUntilAutoPause: Output<Int>? = null,
    public val timeoutAction: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.ClusterScalingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.ClusterScalingConfigurationArgs =
        com.pulumi.aws.rds.inputs.ClusterScalingConfigurationArgs.builder()
            .autoPause(autoPause?.applyValue({ args0 -> args0 }))
            .maxCapacity(maxCapacity?.applyValue({ args0 -> args0 }))
            .minCapacity(minCapacity?.applyValue({ args0 -> args0 }))
            .secondsBeforeTimeout(secondsBeforeTimeout?.applyValue({ args0 -> args0 }))
            .secondsUntilAutoPause(secondsUntilAutoPause?.applyValue({ args0 -> args0 }))
            .timeoutAction(timeoutAction?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterScalingConfigurationArgs].
 */
@PulumiTagMarker
public class ClusterScalingConfigurationArgsBuilder internal constructor() {
    private var autoPause: Output<Boolean>? = null

    private var maxCapacity: Output<Int>? = null

    private var minCapacity: Output<Int>? = null

    private var secondsBeforeTimeout: Output<Int>? = null

    private var secondsUntilAutoPause: Output<Int>? = null

    private var timeoutAction: Output<String>? = null

    /**
     * @param value Whether to enable automatic pause. A DB cluster can be paused only when it's idle (it has no connections). If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. Defaults to `true`.
     */
    @JvmName("glcagfbdfrkikxen")
    public suspend fun autoPause(`value`: Output<Boolean>) {
        this.autoPause = value
    }

    /**
     * @param value Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
     */
    @JvmName("hydmnfeshhgxjori")
    public suspend fun maxCapacity(`value`: Output<Int>) {
        this.maxCapacity = value
    }

    /**
     * @param value Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
     */
    @JvmName("sntjqvlruxpfxpnr")
    public suspend fun minCapacity(`value`: Output<Int>) {
        this.minCapacity = value
    }

    /**
     * @param value Amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. Valid values are `60` through `600`. Defaults to `300`.
     */
    @JvmName("smuknpqdadjubnqu")
    public suspend fun secondsBeforeTimeout(`value`: Output<Int>) {
        this.secondsBeforeTimeout = value
    }

    /**
     * @param value Time, in seconds, before an Aurora DB cluster in serverless mode is paused. Valid values are `300` through `86400`. Defaults to `300`.
     */
    @JvmName("ujshyvygenhskoij")
    public suspend fun secondsUntilAutoPause(`value`: Output<Int>) {
        this.secondsUntilAutoPause = value
    }

    /**
     * @param value Action to take when the timeout is reached. Valid values: `ForceApplyCapacityChange`, `RollbackCapacityChange`. Defaults to `RollbackCapacityChange`. See [documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v1.how-it-works.html#aurora-serverless.how-it-works.timeout-action).
     */
    @JvmName("atveemwwtnvjumvt")
    public suspend fun timeoutAction(`value`: Output<String>) {
        this.timeoutAction = value
    }

    /**
     * @param value Whether to enable automatic pause. A DB cluster can be paused only when it's idle (it has no connections). If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. Defaults to `true`.
     */
    @JvmName("ehtkmpjtbwaishwr")
    public suspend fun autoPause(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPause = mapped
    }

    /**
     * @param value Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
     */
    @JvmName("ejiclqxeleksaqjg")
    public suspend fun maxCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxCapacity = mapped
    }

    /**
     * @param value Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
     */
    @JvmName("jyaopxfijdgxivsl")
    public suspend fun minCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minCapacity = mapped
    }

    /**
     * @param value Amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. Valid values are `60` through `600`. Defaults to `300`.
     */
    @JvmName("rafryoirfdigtcre")
    public suspend fun secondsBeforeTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondsBeforeTimeout = mapped
    }

    /**
     * @param value Time, in seconds, before an Aurora DB cluster in serverless mode is paused. Valid values are `300` through `86400`. Defaults to `300`.
     */
    @JvmName("bfpvslpdlahdlqix")
    public suspend fun secondsUntilAutoPause(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondsUntilAutoPause = mapped
    }

    /**
     * @param value Action to take when the timeout is reached. Valid values: `ForceApplyCapacityChange`, `RollbackCapacityChange`. Defaults to `RollbackCapacityChange`. See [documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v1.how-it-works.html#aurora-serverless.how-it-works.timeout-action).
     */
    @JvmName("gvqxcsnopwhodutc")
    public suspend fun timeoutAction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutAction = mapped
    }

    internal fun build(): ClusterScalingConfigurationArgs = ClusterScalingConfigurationArgs(
        autoPause = autoPause,
        maxCapacity = maxCapacity,
        minCapacity = minCapacity,
        secondsBeforeTimeout = secondsBeforeTimeout,
        secondsUntilAutoPause = secondsUntilAutoPause,
        timeoutAction = timeoutAction,
    )
}
