@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.ClusterServerlessv2ScalingConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxCapacity Maximum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid capacity values are in a range of `0.5` up to `128` in steps of `0.5`.
 * @property minCapacity Minimum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid capacity values are in a range of `0.5` up to `128` in steps of `0.5`.
 */
public data class ClusterServerlessv2ScalingConfigurationArgs(
    public val maxCapacity: Output<Double>,
    public val minCapacity: Output<Double>,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.ClusterServerlessv2ScalingConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.ClusterServerlessv2ScalingConfigurationArgs =
        com.pulumi.aws.rds.inputs.ClusterServerlessv2ScalingConfigurationArgs.builder()
            .maxCapacity(maxCapacity.applyValue({ args0 -> args0 }))
            .minCapacity(minCapacity.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterServerlessv2ScalingConfigurationArgs].
 */
@PulumiTagMarker
public class ClusterServerlessv2ScalingConfigurationArgsBuilder internal constructor() {
    private var maxCapacity: Output<Double>? = null

    private var minCapacity: Output<Double>? = null

    /**
     * @param value Maximum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid capacity values are in a range of `0.5` up to `128` in steps of `0.5`.
     */
    @JvmName("onlwyiygbdchvdwo")
    public suspend fun maxCapacity(`value`: Output<Double>) {
        this.maxCapacity = value
    }

    /**
     * @param value Minimum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid capacity values are in a range of `0.5` up to `128` in steps of `0.5`.
     */
    @JvmName("wlxphkhftwnxgpjv")
    public suspend fun minCapacity(`value`: Output<Double>) {
        this.minCapacity = value
    }

    /**
     * @param value Maximum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid capacity values are in a range of `0.5` up to `128` in steps of `0.5`.
     */
    @JvmName("emmjidvsetblugns")
    public suspend fun maxCapacity(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxCapacity = mapped
    }

    /**
     * @param value Minimum capacity for an Aurora DB cluster in `provisioned` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid capacity values are in a range of `0.5` up to `128` in steps of `0.5`.
     */
    @JvmName("vnyfprxcaqcdhcca")
    public suspend fun minCapacity(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minCapacity = mapped
    }

    internal fun build(): ClusterServerlessv2ScalingConfigurationArgs =
        ClusterServerlessv2ScalingConfigurationArgs(
            maxCapacity = maxCapacity ?: throw PulumiNullFieldException("maxCapacity"),
            minCapacity = minCapacity ?: throw PulumiNullFieldException("minCapacity"),
        )
}
