@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetCertificatePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCertificate.
 * @property id Certificate identifier. For example, `rds-ca-2019`.
 * @property latestValidTill When enabled, returns the certificate with the latest `ValidTill`.
 */
public data class GetCertificatePlainArgs(
    public val id: String? = null,
    public val latestValidTill: Boolean? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetCertificatePlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetCertificatePlainArgs =
        com.pulumi.aws.rds.inputs.GetCertificatePlainArgs.builder()
            .id(id?.let({ args0 -> args0 }))
            .latestValidTill(latestValidTill?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCertificatePlainArgs].
 */
@PulumiTagMarker
public class GetCertificatePlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var latestValidTill: Boolean? = null

    /**
     * @param value Certificate identifier. For example, `rds-ca-2019`.
     */
    @JvmName("wqqpuwpftjssyarw")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value When enabled, returns the certificate with the latest `ValidTill`.
     */
    @JvmName("msckixeowpdifceo")
    public suspend fun latestValidTill(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.latestValidTill = mapped
    }

    internal fun build(): GetCertificatePlainArgs = GetCertificatePlainArgs(
        id = id,
        latestValidTill = latestValidTill,
    )
}
