@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetClusterParameterGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getClusterParameterGroup.
 * @property name DB cluster parameter group name.
 */
public data class GetClusterParameterGroupPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetClusterParameterGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetClusterParameterGroupPlainArgs =
        com.pulumi.aws.rds.inputs.GetClusterParameterGroupPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetClusterParameterGroupPlainArgs].
 */
@PulumiTagMarker
public class GetClusterParameterGroupPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value DB cluster parameter group name.
     */
    @JvmName("bcatahupiyrlsphb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetClusterParameterGroupPlainArgs = GetClusterParameterGroupPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
