@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetClusterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getCluster.
 * @property clusterIdentifier Cluster identifier of the RDS cluster.
 * @property tags A map of tags assigned to the resource.
 */
public data class GetClusterPlainArgs(
    public val clusterIdentifier: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetClusterPlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetClusterPlainArgs =
        com.pulumi.aws.rds.inputs.GetClusterPlainArgs.builder()
            .clusterIdentifier(clusterIdentifier.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetClusterPlainArgs].
 */
@PulumiTagMarker
public class GetClusterPlainArgsBuilder internal constructor() {
    private var clusterIdentifier: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Cluster identifier of the RDS cluster.
     */
    @JvmName("puqqfrxavkfpcdmb")
    public suspend fun clusterIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterIdentifier = mapped
    }

    /**
     * @param value A map of tags assigned to the resource.
     */
    @JvmName("rytnwyimawanmfai")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the resource.
     */
    @JvmName("rvsfwnetjefubmkh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetClusterPlainArgs = GetClusterPlainArgs(
        clusterIdentifier = clusterIdentifier ?: throw PulumiNullFieldException("clusterIdentifier"),
        tags = tags,
    )
}
