@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetEngineVersionFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name
 * @property values
 */
public data class GetEngineVersionFilter(
    public val name: String,
    public val values: List<String>,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetEngineVersionFilter> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetEngineVersionFilter =
        com.pulumi.aws.rds.inputs.GetEngineVersionFilter.builder()
            .name(name.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetEngineVersionFilter].
 */
@PulumiTagMarker
public class GetEngineVersionFilterBuilder internal constructor() {
    private var name: String? = null

    private var values: List<String>? = null

    /**
     * @param value
     */
    @JvmName("mqepwacqviredfgc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("yfuoaimndmglvepp")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values
     */
    @JvmName("npjkckdstimeyuxj")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetEngineVersionFilter = GetEngineVersionFilter(
        name = name ?: throw PulumiNullFieldException("name"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
