@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetEngineVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEngineVersion.
 * @property defaultOnly Whether the engine version must be an AWS-defined default version. Some engines have multiple default versions, such as for each major version. Using `default_only` may help avoid `multiple RDS engine versions` errors. See also `latest`.
 * @property engine Database engine. Engine values include `aurora`, `aurora-mysql`, `aurora-postgresql`, `docdb`, `mariadb`, `mysql`, `neptune`, `oracle-ee`, `oracle-se`, `oracle-se1`, `oracle-se2`, `postgres`, `sqlserver-ee`, `sqlserver-ex`, `sqlserver-se`, and `sqlserver-web`.
 * The following arguments are optional:
 * @property filters One or more name/value pairs to use in filtering versions. There are several valid keys; for a full reference, check out [describe-db-engine-versions in the AWS CLI reference](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/describe-db-engine-versions.html).
 * @property hasMajorTarget Whether the engine version must have one or more major upgrade targets. Not including `has_major_target` or setting it to `false` doesn't imply that there's no corresponding major upgrade target for the engine version.
 * @property hasMinorTarget Whether the engine version must have one or more minor upgrade targets. Not including `has_minor_target` or setting it to `false` doesn't imply that there's no corresponding minor upgrade target for the engine version.
 * @property includeAll Whether the engine version `status` can either be `deprecated` or `available`. When not set or set to `false`, the engine version `status` will always be `available`.
 * @property latest Whether the engine version is the most recent version matching the other criteria. This is different from `default_only` in important ways: "default" relies on AWS-defined defaults, the latest version isn't always the default, and AWS might have multiple default versions for an engine. As a result, `default_only` might not prevent errors from `multiple RDS engine versions`, while `latest` will. (`latest` can be used with `default_only`.) **Note:** The data source uses a best-effort approach at selecting the latest version. Due to the complexity of version identifiers across engines and incomplete version date information provided by AWS, using `latest` may not always result in the engine version being the actual latest version.
 * @property parameterGroupFamily Name of a specific database parameter group family. Examples of parameter group families are `mysql8.0`, `mariadb10.4`, and `postgres12`.
 * @property preferredMajorTargets Ordered list of preferred major version upgrade targets. The engine version will be the first match in the list unless the `latest` parameter is set to `true`. The engine version will be the default version if you don't include any criteria, such as `preferred_major_targets`.
 * @property preferredUpgradeTargets Ordered list of preferred version upgrade targets. The engine version will be the first match in this list unless the `latest` parameter is set to `true`. The engine version will be the default version if you don't include any criteria, such as `preferred_upgrade_targets`.
 * @property preferredVersions Ordered list of preferred versions. The engine version will be the first match in this list unless the `latest` parameter is set to `true`. The engine version will be the default version if you don't include any criteria, such as `preferred_versions`.
 * @property version
 */
public data class GetEngineVersionPlainArgs(
    public val defaultOnly: Boolean? = null,
    public val engine: String,
    public val filters: List<GetEngineVersionFilter>? = null,
    public val hasMajorTarget: Boolean? = null,
    public val hasMinorTarget: Boolean? = null,
    public val includeAll: Boolean? = null,
    public val latest: Boolean? = null,
    public val parameterGroupFamily: String? = null,
    public val preferredMajorTargets: List<String>? = null,
    public val preferredUpgradeTargets: List<String>? = null,
    public val preferredVersions: List<String>? = null,
    public val version: String? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetEngineVersionPlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetEngineVersionPlainArgs =
        com.pulumi.aws.rds.inputs.GetEngineVersionPlainArgs.builder()
            .defaultOnly(defaultOnly?.let({ args0 -> args0 }))
            .engine(engine.let({ args0 -> args0 }))
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .hasMajorTarget(hasMajorTarget?.let({ args0 -> args0 }))
            .hasMinorTarget(hasMinorTarget?.let({ args0 -> args0 }))
            .includeAll(includeAll?.let({ args0 -> args0 }))
            .latest(latest?.let({ args0 -> args0 }))
            .parameterGroupFamily(parameterGroupFamily?.let({ args0 -> args0 }))
            .preferredMajorTargets(preferredMajorTargets?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .preferredUpgradeTargets(preferredUpgradeTargets?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .preferredVersions(preferredVersions?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .version(version?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEngineVersionPlainArgs].
 */
@PulumiTagMarker
public class GetEngineVersionPlainArgsBuilder internal constructor() {
    private var defaultOnly: Boolean? = null

    private var engine: String? = null

    private var filters: List<GetEngineVersionFilter>? = null

    private var hasMajorTarget: Boolean? = null

    private var hasMinorTarget: Boolean? = null

    private var includeAll: Boolean? = null

    private var latest: Boolean? = null

    private var parameterGroupFamily: String? = null

    private var preferredMajorTargets: List<String>? = null

    private var preferredUpgradeTargets: List<String>? = null

    private var preferredVersions: List<String>? = null

    private var version: String? = null

    /**
     * @param value Whether the engine version must be an AWS-defined default version. Some engines have multiple default versions, such as for each major version. Using `default_only` may help avoid `multiple RDS engine versions` errors. See also `latest`.
     */
    @JvmName("pegpboielfdgyxnk")
    public suspend fun defaultOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.defaultOnly = mapped
    }

    /**
     * @param value Database engine. Engine values include `aurora`, `aurora-mysql`, `aurora-postgresql`, `docdb`, `mariadb`, `mysql`, `neptune`, `oracle-ee`, `oracle-se`, `oracle-se1`, `oracle-se2`, `postgres`, `sqlserver-ee`, `sqlserver-ex`, `sqlserver-se`, and `sqlserver-web`.
     * The following arguments are optional:
     */
    @JvmName("hfymfjbfyvuprocx")
    public suspend fun engine(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value One or more name/value pairs to use in filtering versions. There are several valid keys; for a full reference, check out [describe-db-engine-versions in the AWS CLI reference](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/describe-db-engine-versions.html).
     */
    @JvmName("urmwgsqyeinwwsii")
    public suspend fun filters(`value`: List<GetEngineVersionFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use in filtering versions. There are several valid keys; for a full reference, check out [describe-db-engine-versions in the AWS CLI reference](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/describe-db-engine-versions.html).
     */
    @JvmName("fmvyrpnhptnovyrf")
    public suspend fun filters(argument: List<suspend GetEngineVersionFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetEngineVersionFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use in filtering versions. There are several valid keys; for a full reference, check out [describe-db-engine-versions in the AWS CLI reference](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/describe-db-engine-versions.html).
     */
    @JvmName("bmlhrofrydwrukxh")
    public suspend fun filters(vararg argument: suspend GetEngineVersionFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetEngineVersionFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to use in filtering versions. There are several valid keys; for a full reference, check out [describe-db-engine-versions in the AWS CLI reference](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/describe-db-engine-versions.html).
     */
    @JvmName("kuyqkgwhtsrqnill")
    public suspend fun filters(argument: suspend GetEngineVersionFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetEngineVersionFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more name/value pairs to use in filtering versions. There are several valid keys; for a full reference, check out [describe-db-engine-versions in the AWS CLI reference](https://awscli.amazonaws.com/v2/documentation/api/latest/reference/rds/describe-db-engine-versions.html).
     */
    @JvmName("mfhubqwoewujbxeg")
    public suspend fun filters(vararg values: GetEngineVersionFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Whether the engine version must have one or more major upgrade targets. Not including `has_major_target` or setting it to `false` doesn't imply that there's no corresponding major upgrade target for the engine version.
     */
    @JvmName("qdcpcjgrvxetmhyn")
    public suspend fun hasMajorTarget(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hasMajorTarget = mapped
    }

    /**
     * @param value Whether the engine version must have one or more minor upgrade targets. Not including `has_minor_target` or setting it to `false` doesn't imply that there's no corresponding minor upgrade target for the engine version.
     */
    @JvmName("gdgrokcskstcbhel")
    public suspend fun hasMinorTarget(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hasMinorTarget = mapped
    }

    /**
     * @param value Whether the engine version `status` can either be `deprecated` or `available`. When not set or set to `false`, the engine version `status` will always be `available`.
     */
    @JvmName("fuyjwhvtuklipfvc")
    public suspend fun includeAll(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeAll = mapped
    }

    /**
     * @param value Whether the engine version is the most recent version matching the other criteria. This is different from `default_only` in important ways: "default" relies on AWS-defined defaults, the latest version isn't always the default, and AWS might have multiple default versions for an engine. As a result, `default_only` might not prevent errors from `multiple RDS engine versions`, while `latest` will. (`latest` can be used with `default_only`.) **Note:** The data source uses a best-effort approach at selecting the latest version. Due to the complexity of version identifiers across engines and incomplete version date information provided by AWS, using `latest` may not always result in the engine version being the actual latest version.
     */
    @JvmName("lslewwmccsevpyxd")
    public suspend fun latest(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.latest = mapped
    }

    /**
     * @param value Name of a specific database parameter group family. Examples of parameter group families are `mysql8.0`, `mariadb10.4`, and `postgres12`.
     */
    @JvmName("chqkauesicqoofkv")
    public suspend fun parameterGroupFamily(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.parameterGroupFamily = mapped
    }

    /**
     * @param value Ordered list of preferred major version upgrade targets. The engine version will be the first match in the list unless the `latest` parameter is set to `true`. The engine version will be the default version if you don't include any criteria, such as `preferred_major_targets`.
     */
    @JvmName("mgslgjltexmnxcry")
    public suspend fun preferredMajorTargets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.preferredMajorTargets = mapped
    }

    /**
     * @param values Ordered list of preferred major version upgrade targets. The engine version will be the first match in the list unless the `latest` parameter is set to `true`. The engine version will be the default version if you don't include any criteria, such as `preferred_major_targets`.
     */
    @JvmName("twrmvcenucsfdlyj")
    public suspend fun preferredMajorTargets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.preferredMajorTargets = mapped
    }

    /**
     * @param value Ordered list of preferred version upgrade targets. The engine version will be the first match in this list unless the `latest` parameter is set to `true`. The engine version will be the default version if you don't include any criteria, such as `preferred_upgrade_targets`.
     */
    @JvmName("wwjiisihoapsilfc")
    public suspend fun preferredUpgradeTargets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.preferredUpgradeTargets = mapped
    }

    /**
     * @param values Ordered list of preferred version upgrade targets. The engine version will be the first match in this list unless the `latest` parameter is set to `true`. The engine version will be the default version if you don't include any criteria, such as `preferred_upgrade_targets`.
     */
    @JvmName("qqtwmoofagjjyugg")
    public suspend fun preferredUpgradeTargets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.preferredUpgradeTargets = mapped
    }

    /**
     * @param value Ordered list of preferred versions. The engine version will be the first match in this list unless the `latest` parameter is set to `true`. The engine version will be the default version if you don't include any criteria, such as `preferred_versions`.
     */
    @JvmName("dvbomcemgdeqhfxx")
    public suspend fun preferredVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.preferredVersions = mapped
    }

    /**
     * @param values Ordered list of preferred versions. The engine version will be the first match in this list unless the `latest` parameter is set to `true`. The engine version will be the default version if you don't include any criteria, such as `preferred_versions`.
     */
    @JvmName("xjupjahthhjswlnc")
    public suspend fun preferredVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.preferredVersions = mapped
    }

    /**
     * @param value
     */
    @JvmName("nixynxewyuvakfdy")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetEngineVersionPlainArgs = GetEngineVersionPlainArgs(
        defaultOnly = defaultOnly,
        engine = engine ?: throw PulumiNullFieldException("engine"),
        filters = filters,
        hasMajorTarget = hasMajorTarget,
        hasMinorTarget = hasMinorTarget,
        includeAll = includeAll,
        latest = latest,
        parameterGroupFamily = parameterGroupFamily,
        preferredMajorTargets = preferredMajorTargets,
        preferredUpgradeTargets = preferredUpgradeTargets,
        preferredVersions = preferredVersions,
        version = version,
    )
}
