@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstance.
 * @property dbInstanceIdentifier Name of the RDS instance.
 * @property tags Map of tags, each pair of which must exactly match a pair on the desired instance.
 */
public data class GetInstancePlainArgs(
    public val dbInstanceIdentifier: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetInstancePlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetInstancePlainArgs =
        com.pulumi.aws.rds.inputs.GetInstancePlainArgs.builder()
            .dbInstanceIdentifier(dbInstanceIdentifier?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetInstancePlainArgs].
 */
@PulumiTagMarker
public class GetInstancePlainArgsBuilder internal constructor() {
    private var dbInstanceIdentifier: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the RDS instance.
     */
    @JvmName("kcmojxfammyqwfow")
    public suspend fun dbInstanceIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dbInstanceIdentifier = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match a pair on the desired instance.
     */
    @JvmName("laxrruwymscunxme")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match a pair on the desired instance.
     */
    @JvmName("cswlmggfvxpvevhs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetInstancePlainArgs = GetInstancePlainArgs(
        dbInstanceIdentifier = dbInstanceIdentifier,
        tags = tags,
    )
}
