@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property filters Configuration block(s) used to filter instances with AWS supported attributes, such as `engine`, `db-cluster-id` or `db-instance-id` for example. Detailed below.
 * @property tags Map of tags, each pair of which must exactly match a pair on the desired instances.
 */
public data class GetInstancesPlainArgs(
    public val filters: List<GetInstancesFilter>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetInstancesPlainArgs =
        com.pulumi.aws.rds.inputs.GetInstancesPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var filters: List<GetInstancesFilter>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Configuration block(s) used to filter instances with AWS supported attributes, such as `engine`, `db-cluster-id` or `db-instance-id` for example. Detailed below.
     */
    @JvmName("pqcbepxxtorkkbcg")
    public suspend fun filters(`value`: List<GetInstancesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) used to filter instances with AWS supported attributes, such as `engine`, `db-cluster-id` or `db-instance-id` for example. Detailed below.
     */
    @JvmName("vdjagvpkrcxijbqo")
    public suspend fun filters(argument: List<suspend GetInstancesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetInstancesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) used to filter instances with AWS supported attributes, such as `engine`, `db-cluster-id` or `db-instance-id` for example. Detailed below.
     */
    @JvmName("yrrsneucgubvsgct")
    public suspend fun filters(vararg argument: suspend GetInstancesFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetInstancesFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block(s) used to filter instances with AWS supported attributes, such as `engine`, `db-cluster-id` or `db-instance-id` for example. Detailed below.
     */
    @JvmName("vmysjgmrskqinhtc")
    public suspend fun filters(argument: suspend GetInstancesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetInstancesFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block(s) used to filter instances with AWS supported attributes, such as `engine`, `db-cluster-id` or `db-instance-id` for example. Detailed below.
     */
    @JvmName("blffjmktjpceiyxy")
    public suspend fun filters(vararg values: GetInstancesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Map of tags, each pair of which must exactly match a pair on the desired instances.
     */
    @JvmName("emrptmnkppkybqbr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags, each pair of which must exactly match a pair on the desired instances.
     */
    @JvmName("rseuiombrumbllno")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        filters = filters,
        tags = tags,
    )
}
