@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetOrderableDbInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOrderableDbInstance.
 * @property availabilityZoneGroup Availability zone group.
 * @property engine DB engine. Engine values include `aurora`, `aurora-mysql`, `aurora-postgresql`, `docdb`, `mariadb`, `mysql`, `neptune`, `oracle-ee`, `oracle-se`, `oracle-se1`, `oracle-se2`, `postgres`, `sqlserver-ee`, `sqlserver-ex`, `sqlserver-se`, and `sqlserver-web`.
 * @property engineLatestVersion When set to `true`, the data source attempts to return the most recent version matching the other criteria you provide. You must use `engine_latest_version` with `preferred_instance_classes` and/or `preferred_engine_versions`. Using `engine_latest_version` will avoid `multiple RDS DB Instance Classes` errors. If you use `engine_latest_version` with `preferred_instance_classes`, the data source returns the latest version for the _first_ matching instance class (instance class priority). **Note:** The data source uses a best-effort approach at selecting the latest version but due to the complexity of version identifiers across engines, using `engine_latest_version` may _not_ return the latest version in every situation.
 * @property engineVersion Version of the DB engine. If none is provided, the data source tries to use the AWS-defined default version that matches any other criteria.
 * @property instanceClass DB instance class. Examples of classes are `db.m3.2xlarge`, `db.t2.small`, and `db.m3.medium`.
 * @property licenseModel License model. Examples of license models are `general-public-license`, `bring-your-own-license`, and `amazon-license`.
 * @property preferredEngineVersions Ordered list of preferred RDS DB instance engine versions. When `engine_latest_version` is not set, the data source will return the first match in this list that matches any other criteria. If the data source finds no preferred matches or multiple matches without `engine_latest_version`, it returns an error. **CAUTION:** We don't recommend using `preferred_engine_versions` without `preferred_instance_classes` since the data source returns an arbitrary `instance_class` based on the first one AWS returns that matches the engine version and any other criteria.
 * @property preferredInstanceClasses Ordered list of preferred RDS DB instance classes. The data source will return the first match in this list that matches any other criteria. If the data source finds no preferred matches or multiple matches without `engine_latest_version`, it returns an error. If you use `preferred_instance_classes` without `preferred_engine_versions` or `engine_latest_version`, the data source returns an arbitrary `engine_version` based on the first one AWS returns matching the instance class and any other criteria.
 * @property readReplicaCapable Whether a DB instance can have a read replica.
 * @property storageType Storage types. Examples of storage types are `standard`, `io1`, `gp2`, and `aurora`.
 * @property supportedEngineModes Use to limit results to engine modes such as `provisioned`.
 * @property supportedNetworkTypes Use to limit results to network types `IPV4` or `DUAL`.
 * @property supportsClusters Whether to limit results to instances that support clusters.
 * @property supportsEnhancedMonitoring Enable this to ensure a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
 * @property supportsGlobalDatabases Enable this to ensure a DB instance supports Aurora global databases with a specific combination of other DB engine attributes.
 * @property supportsIamDatabaseAuthentication Enable this to ensure a DB instance supports IAM database authentication.
 * @property supportsIops Enable this to ensure a DB instance supports provisioned IOPS.
 * @property supportsKerberosAuthentication Enable this to ensure a DB instance supports Kerberos Authentication.
 * @property supportsMultiAz Whether to limit results to instances that are multi-AZ capable.
 * @property supportsPerformanceInsights Enable this to ensure a DB instance supports Performance Insights.
 * @property supportsStorageAutoscaling Enable this to ensure Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.
 * @property supportsStorageEncryption Enable this to ensure a DB instance supports encrypted storage.
 * @property vpc Boolean that indicates whether to show only VPC or non-VPC offerings.
 */
public data class GetOrderableDbInstancePlainArgs(
    public val availabilityZoneGroup: String? = null,
    public val engine: String,
    public val engineLatestVersion: Boolean? = null,
    public val engineVersion: String? = null,
    public val instanceClass: String? = null,
    public val licenseModel: String? = null,
    public val preferredEngineVersions: List<String>? = null,
    public val preferredInstanceClasses: List<String>? = null,
    public val readReplicaCapable: Boolean? = null,
    public val storageType: String? = null,
    public val supportedEngineModes: List<String>? = null,
    public val supportedNetworkTypes: List<String>? = null,
    public val supportsClusters: Boolean? = null,
    public val supportsEnhancedMonitoring: Boolean? = null,
    public val supportsGlobalDatabases: Boolean? = null,
    public val supportsIamDatabaseAuthentication: Boolean? = null,
    public val supportsIops: Boolean? = null,
    public val supportsKerberosAuthentication: Boolean? = null,
    public val supportsMultiAz: Boolean? = null,
    public val supportsPerformanceInsights: Boolean? = null,
    public val supportsStorageAutoscaling: Boolean? = null,
    public val supportsStorageEncryption: Boolean? = null,
    public val vpc: Boolean? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetOrderableDbInstancePlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetOrderableDbInstancePlainArgs =
        com.pulumi.aws.rds.inputs.GetOrderableDbInstancePlainArgs.builder()
            .availabilityZoneGroup(availabilityZoneGroup?.let({ args0 -> args0 }))
            .engine(engine.let({ args0 -> args0 }))
            .engineLatestVersion(engineLatestVersion?.let({ args0 -> args0 }))
            .engineVersion(engineVersion?.let({ args0 -> args0 }))
            .instanceClass(instanceClass?.let({ args0 -> args0 }))
            .licenseModel(licenseModel?.let({ args0 -> args0 }))
            .preferredEngineVersions(preferredEngineVersions?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .preferredInstanceClasses(preferredInstanceClasses?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .readReplicaCapable(readReplicaCapable?.let({ args0 -> args0 }))
            .storageType(storageType?.let({ args0 -> args0 }))
            .supportedEngineModes(supportedEngineModes?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .supportedNetworkTypes(supportedNetworkTypes?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .supportsClusters(supportsClusters?.let({ args0 -> args0 }))
            .supportsEnhancedMonitoring(supportsEnhancedMonitoring?.let({ args0 -> args0 }))
            .supportsGlobalDatabases(supportsGlobalDatabases?.let({ args0 -> args0 }))
            .supportsIamDatabaseAuthentication(supportsIamDatabaseAuthentication?.let({ args0 -> args0 }))
            .supportsIops(supportsIops?.let({ args0 -> args0 }))
            .supportsKerberosAuthentication(supportsKerberosAuthentication?.let({ args0 -> args0 }))
            .supportsMultiAz(supportsMultiAz?.let({ args0 -> args0 }))
            .supportsPerformanceInsights(supportsPerformanceInsights?.let({ args0 -> args0 }))
            .supportsStorageAutoscaling(supportsStorageAutoscaling?.let({ args0 -> args0 }))
            .supportsStorageEncryption(supportsStorageEncryption?.let({ args0 -> args0 }))
            .vpc(vpc?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOrderableDbInstancePlainArgs].
 */
@PulumiTagMarker
public class GetOrderableDbInstancePlainArgsBuilder internal constructor() {
    private var availabilityZoneGroup: String? = null

    private var engine: String? = null

    private var engineLatestVersion: Boolean? = null

    private var engineVersion: String? = null

    private var instanceClass: String? = null

    private var licenseModel: String? = null

    private var preferredEngineVersions: List<String>? = null

    private var preferredInstanceClasses: List<String>? = null

    private var readReplicaCapable: Boolean? = null

    private var storageType: String? = null

    private var supportedEngineModes: List<String>? = null

    private var supportedNetworkTypes: List<String>? = null

    private var supportsClusters: Boolean? = null

    private var supportsEnhancedMonitoring: Boolean? = null

    private var supportsGlobalDatabases: Boolean? = null

    private var supportsIamDatabaseAuthentication: Boolean? = null

    private var supportsIops: Boolean? = null

    private var supportsKerberosAuthentication: Boolean? = null

    private var supportsMultiAz: Boolean? = null

    private var supportsPerformanceInsights: Boolean? = null

    private var supportsStorageAutoscaling: Boolean? = null

    private var supportsStorageEncryption: Boolean? = null

    private var vpc: Boolean? = null

    /**
     * @param value Availability zone group.
     */
    @JvmName("kwrrytxyqmokessw")
    public suspend fun availabilityZoneGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.availabilityZoneGroup = mapped
    }

    /**
     * @param value DB engine. Engine values include `aurora`, `aurora-mysql`, `aurora-postgresql`, `docdb`, `mariadb`, `mysql`, `neptune`, `oracle-ee`, `oracle-se`, `oracle-se1`, `oracle-se2`, `postgres`, `sqlserver-ee`, `sqlserver-ex`, `sqlserver-se`, and `sqlserver-web`.
     */
    @JvmName("ylocukrhnbdlsbyg")
    public suspend fun engine(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value When set to `true`, the data source attempts to return the most recent version matching the other criteria you provide. You must use `engine_latest_version` with `preferred_instance_classes` and/or `preferred_engine_versions`. Using `engine_latest_version` will avoid `multiple RDS DB Instance Classes` errors. If you use `engine_latest_version` with `preferred_instance_classes`, the data source returns the latest version for the _first_ matching instance class (instance class priority). **Note:** The data source uses a best-effort approach at selecting the latest version but due to the complexity of version identifiers across engines, using `engine_latest_version` may _not_ return the latest version in every situation.
     */
    @JvmName("ggvpghrvkkuxhncb")
    public suspend fun engineLatestVersion(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engineLatestVersion = mapped
    }

    /**
     * @param value Version of the DB engine. If none is provided, the data source tries to use the AWS-defined default version that matches any other criteria.
     */
    @JvmName("pymtdipkpaaujtre")
    public suspend fun engineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engineVersion = mapped
    }

    /**
     * @param value DB instance class. Examples of classes are `db.m3.2xlarge`, `db.t2.small`, and `db.m3.medium`.
     */
    @JvmName("iqymvdvwkbfqcjms")
    public suspend fun instanceClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceClass = mapped
    }

    /**
     * @param value License model. Examples of license models are `general-public-license`, `bring-your-own-license`, and `amazon-license`.
     */
    @JvmName("mawwolddkmrybotu")
    public suspend fun licenseModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.licenseModel = mapped
    }

    /**
     * @param value Ordered list of preferred RDS DB instance engine versions. When `engine_latest_version` is not set, the data source will return the first match in this list that matches any other criteria. If the data source finds no preferred matches or multiple matches without `engine_latest_version`, it returns an error. **CAUTION:** We don't recommend using `preferred_engine_versions` without `preferred_instance_classes` since the data source returns an arbitrary `instance_class` based on the first one AWS returns that matches the engine version and any other criteria.
     */
    @JvmName("drbkvwjyqqrypjkr")
    public suspend fun preferredEngineVersions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.preferredEngineVersions = mapped
    }

    /**
     * @param values Ordered list of preferred RDS DB instance engine versions. When `engine_latest_version` is not set, the data source will return the first match in this list that matches any other criteria. If the data source finds no preferred matches or multiple matches without `engine_latest_version`, it returns an error. **CAUTION:** We don't recommend using `preferred_engine_versions` without `preferred_instance_classes` since the data source returns an arbitrary `instance_class` based on the first one AWS returns that matches the engine version and any other criteria.
     */
    @JvmName("usrweliihipdrbhg")
    public suspend fun preferredEngineVersions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.preferredEngineVersions = mapped
    }

    /**
     * @param value Ordered list of preferred RDS DB instance classes. The data source will return the first match in this list that matches any other criteria. If the data source finds no preferred matches or multiple matches without `engine_latest_version`, it returns an error. If you use `preferred_instance_classes` without `preferred_engine_versions` or `engine_latest_version`, the data source returns an arbitrary `engine_version` based on the first one AWS returns matching the instance class and any other criteria.
     */
    @JvmName("ibyrjysbreuvfdql")
    public suspend fun preferredInstanceClasses(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.preferredInstanceClasses = mapped
    }

    /**
     * @param values Ordered list of preferred RDS DB instance classes. The data source will return the first match in this list that matches any other criteria. If the data source finds no preferred matches or multiple matches without `engine_latest_version`, it returns an error. If you use `preferred_instance_classes` without `preferred_engine_versions` or `engine_latest_version`, the data source returns an arbitrary `engine_version` based on the first one AWS returns matching the instance class and any other criteria.
     */
    @JvmName("mpbsraxspswcsowg")
    public suspend fun preferredInstanceClasses(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.preferredInstanceClasses = mapped
    }

    /**
     * @param value Whether a DB instance can have a read replica.
     */
    @JvmName("wxrgllgfymxhynff")
    public suspend fun readReplicaCapable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.readReplicaCapable = mapped
    }

    /**
     * @param value Storage types. Examples of storage types are `standard`, `io1`, `gp2`, and `aurora`.
     */
    @JvmName("xcpmgheswykjgosm")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.storageType = mapped
    }

    /**
     * @param value Use to limit results to engine modes such as `provisioned`.
     */
    @JvmName("tfjvjetsjdqmrvmu")
    public suspend fun supportedEngineModes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportedEngineModes = mapped
    }

    /**
     * @param values Use to limit results to engine modes such as `provisioned`.
     */
    @JvmName("brhjmyklxubpbsxu")
    public suspend fun supportedEngineModes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.supportedEngineModes = mapped
    }

    /**
     * @param value Use to limit results to network types `IPV4` or `DUAL`.
     */
    @JvmName("pkykglkjienworrj")
    public suspend fun supportedNetworkTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportedNetworkTypes = mapped
    }

    /**
     * @param values Use to limit results to network types `IPV4` or `DUAL`.
     */
    @JvmName("jdwxqvwffagygjxh")
    public suspend fun supportedNetworkTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.supportedNetworkTypes = mapped
    }

    /**
     * @param value Whether to limit results to instances that support clusters.
     */
    @JvmName("xujevewlwdrwwmhr")
    public suspend fun supportsClusters(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsClusters = mapped
    }

    /**
     * @param value Enable this to ensure a DB instance supports Enhanced Monitoring at intervals from 1 to 60 seconds.
     */
    @JvmName("jhpgbfrbdhusxgoo")
    public suspend fun supportsEnhancedMonitoring(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsEnhancedMonitoring = mapped
    }

    /**
     * @param value Enable this to ensure a DB instance supports Aurora global databases with a specific combination of other DB engine attributes.
     */
    @JvmName("wftkibkymtboueqt")
    public suspend fun supportsGlobalDatabases(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsGlobalDatabases = mapped
    }

    /**
     * @param value Enable this to ensure a DB instance supports IAM database authentication.
     */
    @JvmName("viwxospjtvopsggk")
    public suspend fun supportsIamDatabaseAuthentication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsIamDatabaseAuthentication = mapped
    }

    /**
     * @param value Enable this to ensure a DB instance supports provisioned IOPS.
     */
    @JvmName("kahadkiqqmmdefuk")
    public suspend fun supportsIops(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsIops = mapped
    }

    /**
     * @param value Enable this to ensure a DB instance supports Kerberos Authentication.
     */
    @JvmName("rqcmgfanosbofxjp")
    public suspend fun supportsKerberosAuthentication(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsKerberosAuthentication = mapped
    }

    /**
     * @param value Whether to limit results to instances that are multi-AZ capable.
     */
    @JvmName("twihctrdynvslfvr")
    public suspend fun supportsMultiAz(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsMultiAz = mapped
    }

    /**
     * @param value Enable this to ensure a DB instance supports Performance Insights.
     */
    @JvmName("bnyeldbduqpdjntk")
    public suspend fun supportsPerformanceInsights(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsPerformanceInsights = mapped
    }

    /**
     * @param value Enable this to ensure Amazon RDS can automatically scale storage for DB instances that use the specified DB instance class.
     */
    @JvmName("setcxbhencqlpgyv")
    public suspend fun supportsStorageAutoscaling(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsStorageAutoscaling = mapped
    }

    /**
     * @param value Enable this to ensure a DB instance supports encrypted storage.
     */
    @JvmName("olucaclxskmqwrbv")
    public suspend fun supportsStorageEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.supportsStorageEncryption = mapped
    }

    /**
     * @param value Boolean that indicates whether to show only VPC or non-VPC offerings.
     */
    @JvmName("xihloetthcaqwkop")
    public suspend fun vpc(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vpc = mapped
    }

    internal fun build(): GetOrderableDbInstancePlainArgs = GetOrderableDbInstancePlainArgs(
        availabilityZoneGroup = availabilityZoneGroup,
        engine = engine ?: throw PulumiNullFieldException("engine"),
        engineLatestVersion = engineLatestVersion,
        engineVersion = engineVersion,
        instanceClass = instanceClass,
        licenseModel = licenseModel,
        preferredEngineVersions = preferredEngineVersions,
        preferredInstanceClasses = preferredInstanceClasses,
        readReplicaCapable = readReplicaCapable,
        storageType = storageType,
        supportedEngineModes = supportedEngineModes,
        supportedNetworkTypes = supportedNetworkTypes,
        supportsClusters = supportsClusters,
        supportsEnhancedMonitoring = supportsEnhancedMonitoring,
        supportsGlobalDatabases = supportsGlobalDatabases,
        supportsIamDatabaseAuthentication = supportsIamDatabaseAuthentication,
        supportsIops = supportsIops,
        supportsKerberosAuthentication = supportsKerberosAuthentication,
        supportsMultiAz = supportsMultiAz,
        supportsPerformanceInsights = supportsPerformanceInsights,
        supportsStorageAutoscaling = supportsStorageAutoscaling,
        supportsStorageEncryption = supportsStorageEncryption,
        vpc = vpc,
    )
}
