@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetParameterGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getParameterGroup.
 * @property name DB parameter group name.
 */
public data class GetParameterGroupPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetParameterGroupPlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetParameterGroupPlainArgs =
        com.pulumi.aws.rds.inputs.GetParameterGroupPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetParameterGroupPlainArgs].
 */
@PulumiTagMarker
public class GetParameterGroupPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value DB parameter group name.
     */
    @JvmName("shlifrhxkpgmwpfm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetParameterGroupPlainArgs = GetParameterGroupPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
