@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetProxyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getProxy.
 * @property name Name of the DB proxy.
 */
public data class GetProxyPlainArgs(
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetProxyPlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetProxyPlainArgs =
        com.pulumi.aws.rds.inputs.GetProxyPlainArgs.builder()
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProxyPlainArgs].
 */
@PulumiTagMarker
public class GetProxyPlainArgsBuilder internal constructor() {
    private var name: String? = null

    /**
     * @param value Name of the DB proxy.
     */
    @JvmName("akcesbxxmuntcykp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetProxyPlainArgs = GetProxyPlainArgs(
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
