@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.GetReservedInstanceOfferingPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReservedInstanceOffering.
 * @property dbInstanceClass DB instance class for the reserved DB instance.
 * @property duration Duration of the reservation in years or seconds. Valid values are `1`, `3`, `31536000`, `94608000`
 * @property multiAz Whether the reservation applies to Multi-AZ deployments.
 * @property offeringType Offering type of this reserved DB instance. Valid values are `No Upfront`, `Partial Upfront`, `All Upfront`.
 * @property productDescription Description of the reserved DB instance.
 */
public data class GetReservedInstanceOfferingPlainArgs(
    public val dbInstanceClass: String,
    public val duration: Int,
    public val multiAz: Boolean,
    public val offeringType: String,
    public val productDescription: String,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.GetReservedInstanceOfferingPlainArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.GetReservedInstanceOfferingPlainArgs =
        com.pulumi.aws.rds.inputs.GetReservedInstanceOfferingPlainArgs.builder()
            .dbInstanceClass(dbInstanceClass.let({ args0 -> args0 }))
            .duration(duration.let({ args0 -> args0 }))
            .multiAz(multiAz.let({ args0 -> args0 }))
            .offeringType(offeringType.let({ args0 -> args0 }))
            .productDescription(productDescription.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReservedInstanceOfferingPlainArgs].
 */
@PulumiTagMarker
public class GetReservedInstanceOfferingPlainArgsBuilder internal constructor() {
    private var dbInstanceClass: String? = null

    private var duration: Int? = null

    private var multiAz: Boolean? = null

    private var offeringType: String? = null

    private var productDescription: String? = null

    /**
     * @param value DB instance class for the reserved DB instance.
     */
    @JvmName("wkpwjvgccdeowhqm")
    public suspend fun dbInstanceClass(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dbInstanceClass = mapped
    }

    /**
     * @param value Duration of the reservation in years or seconds. Valid values are `1`, `3`, `31536000`, `94608000`
     */
    @JvmName("ngnefycweicpyqtq")
    public suspend fun duration(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.duration = mapped
    }

    /**
     * @param value Whether the reservation applies to Multi-AZ deployments.
     */
    @JvmName("efpmgsrgxuhbsisq")
    public suspend fun multiAz(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.multiAz = mapped
    }

    /**
     * @param value Offering type of this reserved DB instance. Valid values are `No Upfront`, `Partial Upfront`, `All Upfront`.
     */
    @JvmName("ijmfodywllrxbusm")
    public suspend fun offeringType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.offeringType = mapped
    }

    /**
     * @param value Description of the reserved DB instance.
     */
    @JvmName("dsdkjwappajmrgrq")
    public suspend fun productDescription(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productDescription = mapped
    }

    internal fun build(): GetReservedInstanceOfferingPlainArgs = GetReservedInstanceOfferingPlainArgs(
        dbInstanceClass = dbInstanceClass ?: throw PulumiNullFieldException("dbInstanceClass"),
        duration = duration ?: throw PulumiNullFieldException("duration"),
        multiAz = multiAz ?: throw PulumiNullFieldException("multiAz"),
        offeringType = offeringType ?: throw PulumiNullFieldException("offeringType"),
        productDescription = productDescription ?: throw PulumiNullFieldException("productDescription"),
    )
}
