@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.InstanceBlueGreenUpdateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enables low-downtime updates when `true`.
 * Default is `false`.
 * [instance-replication]:
 * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Replication.html
 * [instance-maintenance]:
 * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html
 * [blue-green]:
 * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html
 */
public data class InstanceBlueGreenUpdateArgs(
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.InstanceBlueGreenUpdateArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.InstanceBlueGreenUpdateArgs =
        com.pulumi.aws.rds.inputs.InstanceBlueGreenUpdateArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceBlueGreenUpdateArgs].
 */
@PulumiTagMarker
public class InstanceBlueGreenUpdateArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Enables low-downtime updates when `true`.
     * Default is `false`.
     * [instance-replication]:
     * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Replication.html
     * [instance-maintenance]:
     * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html
     * [blue-green]:
     * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html
     */
    @JvmName("apcyyqikbynqbdyc")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Enables low-downtime updates when `true`.
     * Default is `false`.
     * [instance-replication]:
     * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Overview.Replication.html
     * [instance-maintenance]:
     * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html
     * [blue-green]:
     * https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/blue-green-deployments.html
     */
    @JvmName("lyxljvvjymndhqgx")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): InstanceBlueGreenUpdateArgs = InstanceBlueGreenUpdateArgs(
        enabled = enabled,
    )
}
