@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.InstanceS3ImportArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName The bucket name where your backup is stored
 * @property bucketPrefix Can be blank, but is the path to your backup
 * @property ingestionRole Role applied to load the data.
 * @property sourceEngine Source engine for the backup
 * @property sourceEngineVersion Version of the source engine used to make the backup
 * This will not recreate the resource if the S3 object changes in some way.  It's only used to initialize the database.
 */
public data class InstanceS3ImportArgs(
    public val bucketName: Output<String>,
    public val bucketPrefix: Output<String>? = null,
    public val ingestionRole: Output<String>,
    public val sourceEngine: Output<String>,
    public val sourceEngineVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.InstanceS3ImportArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.InstanceS3ImportArgs =
        com.pulumi.aws.rds.inputs.InstanceS3ImportArgs.builder()
            .bucketName(bucketName.applyValue({ args0 -> args0 }))
            .bucketPrefix(bucketPrefix?.applyValue({ args0 -> args0 }))
            .ingestionRole(ingestionRole.applyValue({ args0 -> args0 }))
            .sourceEngine(sourceEngine.applyValue({ args0 -> args0 }))
            .sourceEngineVersion(sourceEngineVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceS3ImportArgs].
 */
@PulumiTagMarker
public class InstanceS3ImportArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var bucketPrefix: Output<String>? = null

    private var ingestionRole: Output<String>? = null

    private var sourceEngine: Output<String>? = null

    private var sourceEngineVersion: Output<String>? = null

    /**
     * @param value The bucket name where your backup is stored
     */
    @JvmName("pclndeoiwojfplfw")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value Can be blank, but is the path to your backup
     */
    @JvmName("ksermaqpinujghwn")
    public suspend fun bucketPrefix(`value`: Output<String>) {
        this.bucketPrefix = value
    }

    /**
     * @param value Role applied to load the data.
     */
    @JvmName("cpsyftsrgkyefqak")
    public suspend fun ingestionRole(`value`: Output<String>) {
        this.ingestionRole = value
    }

    /**
     * @param value Source engine for the backup
     */
    @JvmName("deimymcyadigckkw")
    public suspend fun sourceEngine(`value`: Output<String>) {
        this.sourceEngine = value
    }

    /**
     * @param value Version of the source engine used to make the backup
     * This will not recreate the resource if the S3 object changes in some way.  It's only used to initialize the database.
     */
    @JvmName("oiwkhntaliygpswc")
    public suspend fun sourceEngineVersion(`value`: Output<String>) {
        this.sourceEngineVersion = value
    }

    /**
     * @param value The bucket name where your backup is stored
     */
    @JvmName("vnitgyahjmfgrdkb")
    public suspend fun bucketName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value Can be blank, but is the path to your backup
     */
    @JvmName("ftbkpmebldhrrjvw")
    public suspend fun bucketPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPrefix = mapped
    }

    /**
     * @param value Role applied to load the data.
     */
    @JvmName("alrojyoqdoboappm")
    public suspend fun ingestionRole(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ingestionRole = mapped
    }

    /**
     * @param value Source engine for the backup
     */
    @JvmName("tkxsvokehvefsyep")
    public suspend fun sourceEngine(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceEngine = mapped
    }

    /**
     * @param value Version of the source engine used to make the backup
     * This will not recreate the resource if the S3 object changes in some way.  It's only used to initialize the database.
     */
    @JvmName("btvnwiplqbtrpdtx")
    public suspend fun sourceEngineVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceEngineVersion = mapped
    }

    internal fun build(): InstanceS3ImportArgs = InstanceS3ImportArgs(
        bucketName = bucketName ?: throw PulumiNullFieldException("bucketName"),
        bucketPrefix = bucketPrefix,
        ingestionRole = ingestionRole ?: throw PulumiNullFieldException("ingestionRole"),
        sourceEngine = sourceEngine ?: throw PulumiNullFieldException("sourceEngine"),
        sourceEngineVersion = sourceEngineVersion ?: throw PulumiNullFieldException("sourceEngineVersion"),
    )
}
