@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.ParameterGroupParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applyMethod "immediate" (default), or "pending-reboot". Some
 * engines can't apply some parameters without a reboot, and you will need to
 * specify "pending-reboot" here.
 * @property name The name of the DB parameter.
 * @property value The value of the DB parameter.
 */
public data class ParameterGroupParameterArgs(
    public val applyMethod: Output<String>? = null,
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.ParameterGroupParameterArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.ParameterGroupParameterArgs =
        com.pulumi.aws.rds.inputs.ParameterGroupParameterArgs.builder()
            .applyMethod(applyMethod?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ParameterGroupParameterArgs].
 */
@PulumiTagMarker
public class ParameterGroupParameterArgsBuilder internal constructor() {
    private var applyMethod: Output<String>? = null

    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value "immediate" (default), or "pending-reboot". Some
     * engines can't apply some parameters without a reboot, and you will need to
     * specify "pending-reboot" here.
     */
    @JvmName("jcoxhkyuiekxgdig")
    public suspend fun applyMethod(`value`: Output<String>) {
        this.applyMethod = value
    }

    /**
     * @param value The name of the DB parameter.
     */
    @JvmName("xugvyvrliylwfrut")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value of the DB parameter.
     */
    @JvmName("njwvvtqdahhegrmj")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value "immediate" (default), or "pending-reboot". Some
     * engines can't apply some parameters without a reboot, and you will need to
     * specify "pending-reboot" here.
     */
    @JvmName("oduxgkecrwlqdwtk")
    public suspend fun applyMethod(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applyMethod = mapped
    }

    /**
     * @param value The name of the DB parameter.
     */
    @JvmName("sgermkrtvdravchu")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value of the DB parameter.
     */
    @JvmName("qjtswjofmjplpebm")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ParameterGroupParameterArgs = ParameterGroupParameterArgs(
        applyMethod = applyMethod,
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
