@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.ProxyAuthArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authScheme The type of authentication that the proxy uses for connections from the proxy to the underlying database. One of `SECRETS`.
 * @property clientPasswordAuthType The type of authentication the proxy uses for connections from clients. Valid values are `MYSQL_NATIVE_PASSWORD`, `POSTGRES_SCRAM_SHA_256`, `POSTGRES_MD5`, and `SQL_SERVER_AUTHENTICATION`.
 * @property description A user-specified description about the authentication used by a proxy to log in as a specific database user.
 * @property iamAuth Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy. One of `DISABLED`, `REQUIRED`.
 * @property secretArn The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
 * @property username The name of the database user to which the proxy connects.
 */
public data class ProxyAuthArgs(
    public val authScheme: Output<String>? = null,
    public val clientPasswordAuthType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val iamAuth: Output<String>? = null,
    public val secretArn: Output<String>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.ProxyAuthArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.ProxyAuthArgs =
        com.pulumi.aws.rds.inputs.ProxyAuthArgs.builder()
            .authScheme(authScheme?.applyValue({ args0 -> args0 }))
            .clientPasswordAuthType(clientPasswordAuthType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .iamAuth(iamAuth?.applyValue({ args0 -> args0 }))
            .secretArn(secretArn?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProxyAuthArgs].
 */
@PulumiTagMarker
public class ProxyAuthArgsBuilder internal constructor() {
    private var authScheme: Output<String>? = null

    private var clientPasswordAuthType: Output<String>? = null

    private var description: Output<String>? = null

    private var iamAuth: Output<String>? = null

    private var secretArn: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The type of authentication that the proxy uses for connections from the proxy to the underlying database. One of `SECRETS`.
     */
    @JvmName("expcidrxenpqreax")
    public suspend fun authScheme(`value`: Output<String>) {
        this.authScheme = value
    }

    /**
     * @param value The type of authentication the proxy uses for connections from clients. Valid values are `MYSQL_NATIVE_PASSWORD`, `POSTGRES_SCRAM_SHA_256`, `POSTGRES_MD5`, and `SQL_SERVER_AUTHENTICATION`.
     */
    @JvmName("nvxqklyndaoyyyhx")
    public suspend fun clientPasswordAuthType(`value`: Output<String>) {
        this.clientPasswordAuthType = value
    }

    /**
     * @param value A user-specified description about the authentication used by a proxy to log in as a specific database user.
     */
    @JvmName("sgvaqylnnrnobsei")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy. One of `DISABLED`, `REQUIRED`.
     */
    @JvmName("lsvcvrkysewyntsg")
    public suspend fun iamAuth(`value`: Output<String>) {
        this.iamAuth = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
     */
    @JvmName("qgsknfjctururdnx")
    public suspend fun secretArn(`value`: Output<String>) {
        this.secretArn = value
    }

    /**
     * @param value The name of the database user to which the proxy connects.
     */
    @JvmName("dvccqlbcwtnbqurw")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The type of authentication that the proxy uses for connections from the proxy to the underlying database. One of `SECRETS`.
     */
    @JvmName("lurvckaobnvesxlp")
    public suspend fun authScheme(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authScheme = mapped
    }

    /**
     * @param value The type of authentication the proxy uses for connections from clients. Valid values are `MYSQL_NATIVE_PASSWORD`, `POSTGRES_SCRAM_SHA_256`, `POSTGRES_MD5`, and `SQL_SERVER_AUTHENTICATION`.
     */
    @JvmName("jolqhynfqopobnpj")
    public suspend fun clientPasswordAuthType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientPasswordAuthType = mapped
    }

    /**
     * @param value A user-specified description about the authentication used by a proxy to log in as a specific database user.
     */
    @JvmName("bofkcgrtvawucvgb")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether to require or disallow AWS Identity and Access Management (IAM) authentication for connections to the proxy. One of `DISABLED`, `REQUIRED`.
     */
    @JvmName("gfhahgrvftvoifvo")
    public suspend fun iamAuth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamAuth = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) representing the secret that the proxy uses to authenticate to the RDS DB instance or Aurora DB cluster. These secrets are stored within Amazon Secrets Manager.
     */
    @JvmName("wwscaylibeuaebxy")
    public suspend fun secretArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretArn = mapped
    }

    /**
     * @param value The name of the database user to which the proxy connects.
     */
    @JvmName("uxhuciklrfdpphiv")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ProxyAuthArgs = ProxyAuthArgs(
        authScheme = authScheme,
        clientPasswordAuthType = clientPasswordAuthType,
        description = description,
        iamAuth = iamAuth,
        secretArn = secretArn,
        username = username,
    )
}
