@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.inputs

import com.pulumi.aws.rds.inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property connectionBorrowTimeout The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.
 * @property initQuery One or more SQL statements for the proxy to run when opening each new database connection. Typically used with `SET` statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single `SET` statement, such as `SET x=1, y=2`.
 * @property maxConnectionsPercent The maximum size of the connection pool for each target in a target group. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
 * @property maxIdleConnectionsPercent Controls how actively the proxy closes idle database connections in the connection pool. A high value enables the proxy to leave a high percentage of idle connections open. A low value causes the proxy to close idle client connections and return the underlying database connections to the connection pool. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
 * @property sessionPinningFilters Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. This setting is only supported for MySQL engine family databases. Currently, the only allowed value is `EXCLUDE_VARIABLE_SETS`.
 */
public data class ProxyDefaultTargetGroupConnectionPoolConfigArgs(
    public val connectionBorrowTimeout: Output<Int>? = null,
    public val initQuery: Output<String>? = null,
    public val maxConnectionsPercent: Output<Int>? = null,
    public val maxIdleConnectionsPercent: Output<Int>? = null,
    public val sessionPinningFilters: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.rds.inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgs> {
    override fun toJava(): com.pulumi.aws.rds.inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgs =
        com.pulumi.aws.rds.inputs.ProxyDefaultTargetGroupConnectionPoolConfigArgs.builder()
            .connectionBorrowTimeout(connectionBorrowTimeout?.applyValue({ args0 -> args0 }))
            .initQuery(initQuery?.applyValue({ args0 -> args0 }))
            .maxConnectionsPercent(maxConnectionsPercent?.applyValue({ args0 -> args0 }))
            .maxIdleConnectionsPercent(maxIdleConnectionsPercent?.applyValue({ args0 -> args0 }))
            .sessionPinningFilters(
                sessionPinningFilters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [ProxyDefaultTargetGroupConnectionPoolConfigArgs].
 */
@PulumiTagMarker
public class ProxyDefaultTargetGroupConnectionPoolConfigArgsBuilder internal constructor() {
    private var connectionBorrowTimeout: Output<Int>? = null

    private var initQuery: Output<String>? = null

    private var maxConnectionsPercent: Output<Int>? = null

    private var maxIdleConnectionsPercent: Output<Int>? = null

    private var sessionPinningFilters: Output<List<String>>? = null

    /**
     * @param value The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.
     */
    @JvmName("pbfuinpoavwvxgmu")
    public suspend fun connectionBorrowTimeout(`value`: Output<Int>) {
        this.connectionBorrowTimeout = value
    }

    /**
     * @param value One or more SQL statements for the proxy to run when opening each new database connection. Typically used with `SET` statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single `SET` statement, such as `SET x=1, y=2`.
     */
    @JvmName("eurhkkorcogydmjc")
    public suspend fun initQuery(`value`: Output<String>) {
        this.initQuery = value
    }

    /**
     * @param value The maximum size of the connection pool for each target in a target group. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
     */
    @JvmName("qlsimgxromfjolcv")
    public suspend fun maxConnectionsPercent(`value`: Output<Int>) {
        this.maxConnectionsPercent = value
    }

    /**
     * @param value Controls how actively the proxy closes idle database connections in the connection pool. A high value enables the proxy to leave a high percentage of idle connections open. A low value causes the proxy to close idle client connections and return the underlying database connections to the connection pool. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
     */
    @JvmName("rxlfksatnajegoym")
    public suspend fun maxIdleConnectionsPercent(`value`: Output<Int>) {
        this.maxIdleConnectionsPercent = value
    }

    /**
     * @param value Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. This setting is only supported for MySQL engine family databases. Currently, the only allowed value is `EXCLUDE_VARIABLE_SETS`.
     */
    @JvmName("fnapqtfsqgemnvaw")
    public suspend fun sessionPinningFilters(`value`: Output<List<String>>) {
        this.sessionPinningFilters = value
    }

    @JvmName("uxjwgtgaemhuucdr")
    public suspend fun sessionPinningFilters(vararg values: Output<String>) {
        this.sessionPinningFilters = Output.all(values.asList())
    }

    /**
     * @param values Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. This setting is only supported for MySQL engine family databases. Currently, the only allowed value is `EXCLUDE_VARIABLE_SETS`.
     */
    @JvmName("cajnspcjwastujfx")
    public suspend fun sessionPinningFilters(values: List<Output<String>>) {
        this.sessionPinningFilters = Output.all(values)
    }

    /**
     * @param value The number of seconds for a proxy to wait for a connection to become available in the connection pool. Only applies when the proxy has opened its maximum number of connections and all connections are busy with client sessions.
     */
    @JvmName("rlsfmkitbdtildmr")
    public suspend fun connectionBorrowTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionBorrowTimeout = mapped
    }

    /**
     * @param value One or more SQL statements for the proxy to run when opening each new database connection. Typically used with `SET` statements to make sure that each connection has identical settings such as time zone and character set. This setting is empty by default. For multiple statements, use semicolons as the separator. You can also include multiple variables in a single `SET` statement, such as `SET x=1, y=2`.
     */
    @JvmName("ispnacjoxsoxwpjv")
    public suspend fun initQuery(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initQuery = mapped
    }

    /**
     * @param value The maximum size of the connection pool for each target in a target group. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
     */
    @JvmName("syqsdundemyyanmt")
    public suspend fun maxConnectionsPercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConnectionsPercent = mapped
    }

    /**
     * @param value Controls how actively the proxy closes idle database connections in the connection pool. A high value enables the proxy to leave a high percentage of idle connections open. A low value causes the proxy to close idle client connections and return the underlying database connections to the connection pool. For Aurora MySQL, it is expressed as a percentage of the max_connections setting for the RDS DB instance or Aurora DB cluster used by the target group.
     */
    @JvmName("iinyhtpbeievwoev")
    public suspend fun maxIdleConnectionsPercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxIdleConnectionsPercent = mapped
    }

    /**
     * @param value Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. This setting is only supported for MySQL engine family databases. Currently, the only allowed value is `EXCLUDE_VARIABLE_SETS`.
     */
    @JvmName("uxclxmsqnxdtxlbs")
    public suspend fun sessionPinningFilters(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionPinningFilters = mapped
    }

    /**
     * @param values Each item in the list represents a class of SQL operations that normally cause all later statements in a session using a proxy to be pinned to the same underlying database connection. Including an item in the list exempts that class of SQL operations from the pinning behavior. This setting is only supported for MySQL engine family databases. Currently, the only allowed value is `EXCLUDE_VARIABLE_SETS`.
     */
    @JvmName("ufbavndtejgjdffv")
    public suspend fun sessionPinningFilters(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionPinningFilters = mapped
    }

    internal fun build(): ProxyDefaultTargetGroupConnectionPoolConfigArgs =
        ProxyDefaultTargetGroupConnectionPoolConfigArgs(
            connectionBorrowTimeout = connectionBorrowTimeout,
            initQuery = initQuery,
            maxConnectionsPercent = maxConnectionsPercent,
            maxIdleConnectionsPercent = maxIdleConnectionsPercent,
            sessionPinningFilters = sessionPinningFilters,
        )
}
