@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applyMethod "immediate" (default), or "pending-reboot". Some
 * engines can't apply some parameters without a reboot, and you will need to
 * specify "pending-reboot" here.
 * @property name The name of the DB parameter.
 * @property value The value of the DB parameter.
 */
public data class ClusterParameterGroupParameter(
    public val applyMethod: String? = null,
    public val name: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.ClusterParameterGroupParameter): ClusterParameterGroupParameter = ClusterParameterGroupParameter(
            applyMethod = javaType.applyMethod().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            `value` = javaType.`value`(),
        )
    }
}
