@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property restoreToTime Date and time in UTC format to restore the database cluster to. Conflicts with `use_latest_restorable_time`.
 * @property restoreType Type of restore to be performed.
 * Valid options are `full-copy` (default) and `copy-on-write`.
 * @property sourceClusterIdentifier Identifier of the source database cluster from which to restore. When restoring from a cluster in another AWS account, the identifier is the ARN of that cluster.
 * @property sourceClusterResourceId Cluster resource ID of the source database cluster from which to restore. To be used for restoring a deleted cluster in the same account which still has a retained automatic backup available.
 * @property useLatestRestorableTime Set to true to restore the database cluster to the latest restorable backup time. Defaults to false. Conflicts with `restore_to_time`.
 */
public data class ClusterRestoreToPointInTime(
    public val restoreToTime: String? = null,
    public val restoreType: String? = null,
    public val sourceClusterIdentifier: String? = null,
    public val sourceClusterResourceId: String? = null,
    public val useLatestRestorableTime: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.ClusterRestoreToPointInTime): ClusterRestoreToPointInTime = ClusterRestoreToPointInTime(
            restoreToTime = javaType.restoreToTime().map({ args0 -> args0 }).orElse(null),
            restoreType = javaType.restoreType().map({ args0 -> args0 }).orElse(null),
            sourceClusterIdentifier = javaType.sourceClusterIdentifier().map({ args0 -> args0 }).orElse(null),
            sourceClusterResourceId = javaType.sourceClusterResourceId().map({ args0 -> args0 }).orElse(null),
            useLatestRestorableTime = javaType.useLatestRestorableTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
