@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketName Bucket name where your backup is stored
 * @property bucketPrefix Can be blank, but is the path to your backup
 * @property ingestionRole Role applied to load the data.
 * @property sourceEngine Source engine for the backup
 * @property sourceEngineVersion Version of the source engine used to make the backup
 * This will not recreate the resource if the S3 object changes in some way. It's only used to initialize the database. This only works currently with the aurora engine. See AWS for currently supported engines and options. See [Aurora S3 Migration Docs](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/AuroraMySQL.Migrating.ExtMySQL.html#AuroraMySQL.Migrating.ExtMySQL.S3).
 */
public data class ClusterS3Import(
    public val bucketName: String,
    public val bucketPrefix: String? = null,
    public val ingestionRole: String,
    public val sourceEngine: String,
    public val sourceEngineVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.ClusterS3Import): ClusterS3Import =
            ClusterS3Import(
                bucketName = javaType.bucketName(),
                bucketPrefix = javaType.bucketPrefix().map({ args0 -> args0 }).orElse(null),
                ingestionRole = javaType.ingestionRole(),
                sourceEngine = javaType.sourceEngine(),
                sourceEngineVersion = javaType.sourceEngineVersion(),
            )
    }
}
