@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.rds.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property autoPause Whether to enable automatic pause. A DB cluster can be paused only when it's idle (it has no connections). If a DB cluster is paused for more than seven days, the DB cluster might be backed up with a snapshot. In this case, the DB cluster is restored when there is a request to connect to it. Defaults to `true`.
 * @property maxCapacity Maximum capacity for an Aurora DB cluster in `serverless` DB engine mode. The maximum capacity must be greater than or equal to the minimum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `16`.
 * @property minCapacity Minimum capacity for an Aurora DB cluster in `serverless` DB engine mode. The minimum capacity must be lesser than or equal to the maximum capacity. Valid Aurora MySQL capacity values are `1`, `2`, `4`, `8`, `16`, `32`, `64`, `128`, `256`. Valid Aurora PostgreSQL capacity values are (`2`, `4`, `8`, `16`, `32`, `64`, `192`, and `384`). Defaults to `1`.
 * @property secondsBeforeTimeout Amount of time, in seconds, that Aurora Serverless v1 tries to find a scaling point to perform seamless scaling before enforcing the timeout action. Valid values are `60` through `600`. Defaults to `300`.
 * @property secondsUntilAutoPause Time, in seconds, before an Aurora DB cluster in serverless mode is paused. Valid values are `300` through `86400`. Defaults to `300`.
 * @property timeoutAction Action to take when the timeout is reached. Valid values: `ForceApplyCapacityChange`, `RollbackCapacityChange`. Defaults to `RollbackCapacityChange`. See [documentation](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless-v1.how-it-works.html#aurora-serverless.how-it-works.timeout-action).
 */
public data class ClusterScalingConfiguration(
    public val autoPause: Boolean? = null,
    public val maxCapacity: Int? = null,
    public val minCapacity: Int? = null,
    public val secondsBeforeTimeout: Int? = null,
    public val secondsUntilAutoPause: Int? = null,
    public val timeoutAction: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.rds.outputs.ClusterScalingConfiguration): ClusterScalingConfiguration = ClusterScalingConfiguration(
            autoPause = javaType.autoPause().map({ args0 -> args0 }).orElse(null),
            maxCapacity = javaType.maxCapacity().map({ args0 -> args0 }).orElse(null),
            minCapacity = javaType.minCapacity().map({ args0 -> args0 }).orElse(null),
            secondsBeforeTimeout = javaType.secondsBeforeTimeout().map({ args0 -> args0 }).orElse(null),
            secondsUntilAutoPause = javaType.secondsUntilAutoPause().map({ args0 -> args0 }).orElse(null),
            timeoutAction = javaType.timeoutAction().map({ args0 -> args0 }).orElse(null),
        )
    }
}
